/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.lock;

import java.io.IOException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.jdbc.JdbcDirectory;
import org.apache.lucene.store.jdbc.lock.JdbcLock;
import org.apache.lucene.store.jdbc.support.JdbcTemplate;

public class PhantomReadLock
extends Lock
implements JdbcLock {
    private JdbcDirectory jdbcDirectory;
    private String name;

    public void configure(JdbcDirectory jdbcDirectory, String name) throws IOException {
        this.jdbcDirectory = jdbcDirectory;
        this.name = name;
    }

    public void initializeDatabase(JdbcDirectory jdbcDirectory) {
    }

    public boolean obtain() {
        try {
            if (this.jdbcDirectory.getDialect().useExistsBeforeInsertLock() && this.jdbcDirectory.fileExists(this.name)) {
                return false;
            }
            this.jdbcDirectory.getJdbcTemplate().executeUpdate(this.jdbcDirectory.getTable().sqlInsert(), new JdbcTemplate.PrepateStatementAwareCallback(){

                public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                    ps.setFetchSize(1);
                    ps.setString(1, PhantomReadLock.this.name);
                    ps.setBlob(2, (Blob)null);
                    ps.setLong(3, 0L);
                    ps.setBoolean(4, false);
                }
            });
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void release() {
        try {
            this.jdbcDirectory.getJdbcTemplate().executeUpdate(this.jdbcDirectory.getTable().sqlDeleteByName(), new JdbcTemplate.PrepateStatementAwareCallback(){

                public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                    ps.setFetchSize(1);
                    ps.setString(1, PhantomReadLock.this.name);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isLocked() {
        try {
            return this.jdbcDirectory.fileExists(this.name);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return "PhantomReadLock[" + this.name + "/" + this.jdbcDirectory.getTable() + "]";
    }
}

