/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.wrapper;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.RAMOutputStream;

public class SyncMemoryMirrorDirectoryWrapper
extends Directory {
    private Directory dir;
    private RAMDirectory ramDir;

    public SyncMemoryMirrorDirectoryWrapper(Directory dir) throws IOException {
        this.dir = dir;
        this.ramDir = new RAMDirectory(dir);
    }

    public void deleteFile(String name) throws IOException {
        this.ramDir.deleteFile(name);
        this.dir.deleteFile(name);
    }

    public boolean fileExists(String name) throws IOException {
        return this.ramDir.fileExists(name);
    }

    public long fileLength(String name) throws IOException {
        return this.ramDir.fileLength(name);
    }

    public long fileModified(String name) throws IOException {
        return this.ramDir.fileModified(name);
    }

    public String[] list() throws IOException {
        return this.ramDir.list();
    }

    public void renameFile(String from, String to) throws IOException {
        this.ramDir.renameFile(from, to);
        this.dir.renameFile(from, to);
    }

    public void touchFile(String name) throws IOException {
        this.ramDir.touchFile(name);
        this.dir.touchFile(name);
    }

    public Lock makeLock(String name) {
        return this.ramDir.makeLock(name);
    }

    public void close() throws IOException {
        this.ramDir.close();
        this.dir.close();
    }

    public IndexInput openInput(String name) throws IOException {
        return this.ramDir.openInput(name);
    }

    public IndexOutput createOutput(String name) throws IOException {
        return new SyncMemoryMirrorIndexOutput(this.dir.createOutput(name), (RAMOutputStream)this.ramDir.createOutput(name));
    }

    public static class SyncMemoryMirrorIndexOutput
    extends IndexOutput {
        private IndexOutput origIndexOutput;
        private RAMOutputStream ramIndexOutput;

        public SyncMemoryMirrorIndexOutput(IndexOutput origIndexOutput, RAMOutputStream ramIndexOutput) {
            this.origIndexOutput = origIndexOutput;
            this.ramIndexOutput = ramIndexOutput;
        }

        public void writeByte(byte b) throws IOException {
            this.ramIndexOutput.writeByte(b);
        }

        public void writeBytes(byte[] data, int size) throws IOException {
            this.ramIndexOutput.writeBytes(data, size);
        }

        public void seek(long size) throws IOException {
            this.ramIndexOutput.seek(size);
        }

        public long length() throws IOException {
            return this.ramIndexOutput.length();
        }

        public long getFilePointer() {
            return this.ramIndexOutput.getFilePointer();
        }

        public void flush() throws IOException {
            this.ramIndexOutput.flush();
        }

        public void close() throws IOException {
            this.ramIndexOutput.close();
            this.ramIndexOutput.writeTo(this.origIndexOutput);
            this.origIndexOutput.close();
        }
    }
}

