/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Compass;
import org.compass.core.CompassException;
import org.compass.core.config.CompassMappingBinding;
import org.compass.core.config.CompassMappingProcessor;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.InputStreamMappingResolver;
import org.compass.core.config.binding.XmlMappingBinding;
import org.compass.core.config.binding.XmlMetaDataBinding;
import org.compass.core.config.builder.ConfigurationBuilder;
import org.compass.core.config.builder.SmartConfigurationBuilder;
import org.compass.core.converter.Converter;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.converter.DefaultConverterLookup;
import org.compass.core.engine.naming.DefaultPropertyNamingStrategyFactory;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.impl.DefaultCompass;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.metadata.CompassMetaData;
import org.compass.core.metadata.impl.DefaultCompassMetaData;
import org.compass.core.util.JdkVersion;

public class CompassConfiguration {
    protected static final Log log;
    private CompassMetaData metaData;
    private CompassMapping mapping;
    private CompassSettings settings;
    protected CompassMappingBinding mappingBinding;
    protected ConfigurationBuilder configurationBuilder = new SmartConfigurationBuilder();
    private HashMap temporaryConvertersByName = new HashMap();

    public CompassConfiguration() {
        this.mapping = new CompassMapping();
        this.metaData = new DefaultCompassMetaData();
        this.settings = new CompassSettings();
        this.mappingBinding = new CompassMappingBinding();
        this.addMappingBindings(this.mappingBinding);
        this.mappingBinding.setUpBinding(this.mapping, this.metaData, this.settings);
    }

    protected void addMappingBindings(CompassMappingBinding mappingBinding) {
        mappingBinding.addMappingBinding(new XmlMetaDataBinding());
        mappingBinding.addMappingBinding(new XmlMappingBinding());
    }

    public CompassSettings getSettings() {
        return this.settings;
    }

    public CompassConfiguration setSetting(String setting, String value) {
        this.settings.setSetting(setting, value);
        return this;
    }

    public CompassConfiguration setConnection(String connection) {
        this.settings.setSetting("compass.engine.connection", connection);
        return this;
    }

    public CompassConfiguration registerConverter(String converterName, Converter converter) {
        this.temporaryConvertersByName.put(converterName, converter);
        return this;
    }

    public Compass buildCompass() throws CompassException {
        CompassSettings copySettings = this.settings.copy();
        DefaultConverterLookup converterLookup = new DefaultConverterLookup();
        this.registerExtraConverters(converterLookup);
        converterLookup.configure(copySettings);
        Iterator it = this.temporaryConvertersByName.keySet().iterator();
        while (it.hasNext()) {
            String converterName = (String)it.next();
            Converter converter = (Converter)this.temporaryConvertersByName.get(converterName);
            converterLookup.registerConverter(converterName, converter);
        }
        CompassMapping copyCompassMapping = this.mapping.copy(converterLookup);
        DefaultPropertyNamingStrategyFactory propertyNamingStrategyFactory = new DefaultPropertyNamingStrategyFactory();
        PropertyNamingStrategy propertyNamingStrategy = propertyNamingStrategyFactory.createNamingStrategy(copySettings);
        CompassMappingProcessor mappingProcessor = new CompassMappingProcessor();
        mappingProcessor.process(copyCompassMapping, propertyNamingStrategy, converterLookup, copySettings);
        CompassMetaData copyMetaData = this.metaData.copy();
        return new DefaultCompass(copyCompassMapping, converterLookup, copyMetaData, propertyNamingStrategy, copySettings);
    }

    protected void registerExtraConverters(ConverterLookup converterLookup) {
    }

    public CompassConfiguration configure() throws ConfigurationException {
        this.configure("/compass.cfg.xml");
        return this;
    }

    public CompassConfiguration configure(String resource) throws ConfigurationException {
        log.info((Object)("Configuring from resource [" + resource + "]"));
        this.configurationBuilder.configure(resource, this);
        return this;
    }

    public CompassConfiguration configure(URL url) throws ConfigurationException {
        log.info((Object)("Configuring from url [" + url.toExternalForm() + "]"));
        this.configurationBuilder.configure(url, this);
        return this;
    }

    public CompassConfiguration configure(File configFile) throws ConfigurationException {
        log.info((Object)("Configuring from file [" + configFile.getAbsolutePath() + "]"));
        this.configurationBuilder.configure(configFile, this);
        return this;
    }

    public CompassConfiguration addMappingResover(InputStreamMappingResolver mappingResolver) throws ConfigurationException {
        boolean hasAddedResource = this.mappingBinding.addMappingResolver(mappingResolver);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match mapping resolver [" + mappingResolver + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping resolver [" + mappingResolver + "]"));
        }
        return this;
    }

    public CompassConfiguration addResource(String path, ClassLoader classLoader) throws ConfigurationException {
        boolean hasAddedResource = this.mappingBinding.addResource(path, classLoader);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match resource [" + path + "] and class loader [" + classLoader + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping resource [" + path + "] from class loader [" + classLoader + "]"));
        }
        return this;
    }

    public CompassConfiguration addResource(String path) throws ConfigurationException {
        boolean hasAddedResource = this.mappingBinding.addResource(path);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match resource [" + path + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping resource [" + path + "] in class loader"));
        }
        return this;
    }

    public CompassConfiguration addFile(String filePath) throws ConfigurationException {
        boolean hasAddedResource = this.mappingBinding.addFile(filePath);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match file [" + filePath + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping file [" + filePath + "]"));
        }
        return this;
    }

    public CompassConfiguration addFile(File file) throws ConfigurationException {
        boolean hasAddedResource = this.mappingBinding.addFile(file);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match file [" + file.getAbsolutePath() + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping file [" + file.getAbsolutePath() + "]"));
        }
        return this;
    }

    public CompassConfiguration addPackage(String packageName) throws ConfigurationException {
        boolean hasAddedResource = this.mappingBinding.addPackage(packageName);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match package [" + packageName + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping package [" + packageName + "]"));
        }
        return this;
    }

    public CompassConfiguration addClass(Class searchableClass) throws ConfigurationException {
        boolean hasAddedResource = this.mappingBinding.addClass(searchableClass);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match class [" + searchableClass.getName() + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping class [" + searchableClass + "]"));
        }
        return this;
    }

    public CompassConfiguration addDirectory(File dir) throws ConfigurationException {
        boolean hasAddedResource = this.mappingBinding.addDirectory(dir);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match directory [" + dir.getAbsolutePath() + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping directory [" + dir.getAbsolutePath() + "]"));
        }
        return this;
    }

    public CompassConfiguration addJar(File jar) throws ConfigurationException {
        boolean hasAddedResource = this.mappingBinding.addJar(jar);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match jar [" + jar.getAbsolutePath() + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping jar [" + jar.getName() + "]"));
        }
        return this;
    }

    public CompassConfiguration addURL(URL url) throws ConfigurationException {
        boolean hasAddedResource = this.mappingBinding.addURL(url);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match URL [" + url.toExternalForm() + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping URL [" + url.toExternalForm() + "]"));
        }
        return this;
    }

    public CompassConfiguration addInputStream(InputStream inputStream, String resourceName) throws ConfigurationException {
        boolean hasAddedResource = this.mappingBinding.addInputStream(inputStream, resourceName);
        if (!hasAddedResource) {
            throw new ConfigurationException("No mapping match input stream [" + resourceName + "]");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping InputStream [" + resourceName + "]"));
        }
        return this;
    }

    static {
        if (JdkVersion.getMajorJavaVersion() >= 2) {
            System.setProperty("org.compass.core.util.backport.java.util.concurrent.NanoTimerProvider", "org.compass.core.util.concurrent.SystemNanoTimer");
        }
        log = LogFactory.getLog((Class)CompassConfiguration.class);
    }
}

