/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;

public class ResolveExtendsMappingProcessor
implements MappingProcessor {
    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        ArrayList<AliasMapping> innerMappingsCopy = new ArrayList<AliasMapping>();
        Iterator it = compassMapping.mappingsIt();
        while (it.hasNext()) {
            AliasMapping origAliasMapping = (AliasMapping)it.next();
            AliasMapping aliasMapping = origAliasMapping.shallowCopy();
            this.resolveExtends(compassMapping, aliasMapping, origAliasMapping);
            innerMappingsCopy.add(aliasMapping);
        }
        compassMapping.clearMappings();
        it = innerMappingsCopy.iterator();
        while (it.hasNext()) {
            compassMapping.addMapping((AliasMapping)it.next());
        }
        it = compassMapping.mappingsIt();
        while (it.hasNext()) {
            AliasMapping aliasMapping = (AliasMapping)it.next();
            this.resolveExtending(compassMapping, aliasMapping, new HashSet());
        }
        return compassMapping;
    }

    private void resolveExtending(CompassMapping compassMapping, AliasMapping aliasMapping, HashSet extendingAliases) {
        if (aliasMapping.getExtendedAliases() != null) {
            for (int i = 0; i < aliasMapping.getExtendedAliases().length; ++i) {
                String extendedAlias = aliasMapping.getExtendedAliases()[i];
                AliasMapping extendedAliasMapping = compassMapping.getAliasMapping(extendedAlias);
                if (extendedAliasMapping.getExtendingAliases() != null) {
                    for (int j = 0; j < extendedAliasMapping.getExtendingAliases().length; ++j) {
                        extendingAliases.add(extendedAliasMapping.getExtendingAliases()[j]);
                    }
                }
                extendingAliases.add(aliasMapping.getAlias());
                extendedAliasMapping.setExtendingAliases(extendingAliases.toArray(new String[extendingAliases.size()]));
                this.resolveExtending(compassMapping, extendedAliasMapping, extendingAliases);
            }
        }
    }

    private void resolveExtends(CompassMapping compassMapping, AliasMapping aliasMapping, AliasMapping copyFromAliasMapping) throws MappingException {
        if (copyFromAliasMapping.getExtendedAliases() != null) {
            for (int i = 0; i < copyFromAliasMapping.getExtendedAliases().length; ++i) {
                String extendedAlias = copyFromAliasMapping.getExtendedAliases()[i];
                AliasMapping extendedAliasMapping = compassMapping.getAliasMapping(extendedAlias);
                if (extendedAliasMapping == null) {
                    throw new MappingException("Failed to find alias [" + extendedAlias + "] in alias [" + aliasMapping.getAlias() + "] extends section");
                }
                this.resolveExtends(compassMapping, aliasMapping, (AliasMapping)extendedAliasMapping.copy());
            }
        }
        Iterator aliasMappingIt = copyFromAliasMapping.mappingsIt();
        while (aliasMappingIt.hasNext()) {
            aliasMapping.addMapping((Mapping)aliasMappingIt.next());
        }
    }
}

