/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.compass.core.accessor.AccessorUtils;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.HasRefAliasMapping;

public class ResolveRefAliasProcessor
implements MappingProcessor {
    private CompassMapping compassMapping;

    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        this.compassMapping = compassMapping;
        Iterator rIt = compassMapping.mappingsIt();
        while (rIt.hasNext()) {
            Mapping mapping = (Mapping)rIt.next();
            if (!(mapping instanceof ClassMapping)) continue;
            ClassMapping classMapping = (ClassMapping)mapping;
            Iterator it = classMapping.mappingsIt();
            while (it.hasNext()) {
                Mapping innerMapping = (Mapping)it.next();
                if (!(innerMapping instanceof HasRefAliasMapping)) continue;
                this.processMapping(classMapping, (HasRefAliasMapping)innerMapping);
            }
        }
        return compassMapping;
    }

    void processMapping(ClassMapping classMapping, HasRefAliasMapping mapping) throws MappingException {
        if (mapping.getRefAliases() == null) {
            Class clazz = mapping.getRefClass();
            if (clazz == null && (clazz = AccessorUtils.getGenericCollectionParameter(mapping.getGetter())) == null) {
                clazz = mapping.getGetter().getReturnType();
            }
            if (clazz == null) {
                throw new MappingException("This should not happen");
            }
            if (this.compassMapping.hasMultipleClassMapping(clazz.getName())) {
                throw new MappingException("Tried to resolve ref-alias for property [" + mapping.getName() + "] in alias [" + classMapping.getAlias() + "], but there are multiple class mappings for [" + clazz.getName() + "]. Please set the ref-alias explicitly.");
            }
            HashSet<String> aliases = new HashSet<String>();
            Iterator it = this.compassMapping.mappingsIt();
            while (it.hasNext()) {
                ClassMapping iterateClassMapping;
                Mapping iterateMapping = (Mapping)it.next();
                if (!(iterateMapping instanceof ClassMapping) || !clazz.isAssignableFrom((iterateClassMapping = (ClassMapping)iterateMapping).getClazz())) continue;
                aliases.add(iterateClassMapping.getAlias());
            }
            if (aliases.size() == 0) {
                if (Collection.class.isAssignableFrom(mapping.getGetter().getReturnType())) {
                    throw new MappingException("Failed to resolve ref-alias for collection property [" + mapping.getName() + "] in alias [" + classMapping.getAlias() + "]. You must set the ref-alias for it, or use Java 5 generics for the collection type." + " Have you added the class mapping to Compass?");
                }
                throw new MappingException("Tried to resolve ref-alias for property [" + mapping.getName() + "] in alias [" + classMapping.getAlias() + "], but no class mapping was found for [" + clazz.getName() + "]");
            }
            mapping.setRefAliases(aliases.toArray(new String[aliases.size()]));
        }
        String[] aliases = mapping.getRefAliases();
        LinkedHashSet<String> aliasesSet = new LinkedHashSet<String>();
        ArrayList<AliasMapping> refMappings = new ArrayList<AliasMapping>();
        for (int i = 0; i < aliases.length; ++i) {
            String[] extendingAliases;
            AliasMapping refAliasMapping = this.compassMapping.getAliasMapping(aliases[i]);
            if (refAliasMapping == null) {
                throw new MappingException("Failed to resolve ref-alias [" + aliases[i] + "] for [" + mapping.getName() + "] in alias [" + classMapping.getAlias() + "]");
            }
            if (aliasesSet.contains(aliases[i])) continue;
            if (refAliasMapping instanceof ClassMapping) {
                aliasesSet.add(aliases[i]);
                refMappings.add(refAliasMapping);
            }
            if ((extendingAliases = refAliasMapping.getExtendingAliases()) == null) continue;
            for (int j = 0; j < extendingAliases.length; ++j) {
                AliasMapping aliasMapping = this.compassMapping.getAliasMapping(extendingAliases[j]);
                if (aliasesSet.contains(aliasMapping.getAlias()) || !(aliasMapping instanceof ClassMapping)) continue;
                aliasesSet.add(aliasMapping.getAlias());
                refMappings.add(aliasMapping);
            }
        }
        mapping.setRefAliases(aliasesSet.toArray(new String[aliasesSet.size()]));
        mapping.setRefClassMappings(refMappings.toArray(new ClassMapping[refMappings.size()]));
    }
}

