/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic;

import java.util.Locale;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.converter.basic.AbstractBasicConverter;
import org.compass.core.converter.basic.FormatConverter;
import org.compass.core.converter.basic.ThreadSafeFormat;

public abstract class AbstractFormatConverter
extends AbstractBasicConverter
implements CompassConfigurable,
FormatConverter {
    protected ThreadSafeFormat formatter;
    protected boolean hasFormatter = true;

    public void configure(CompassSettings settings) throws CompassException {
        String format = settings.getSetting("format");
        if (format == null) {
            format = this.doGetDefaultFormat();
        }
        if (format == null) {
            this.hasFormatter = false;
            return;
        }
        String localeSetting = settings.getSetting("format.locale");
        Locale locale = localeSetting != null ? new Locale(localeSetting) : Locale.getDefault();
        ThreadSafeFormat.FormatterFactory formatterFactory = this.doCreateFormatterFactory();
        formatterFactory.configure(format, locale);
        int minPoolSize = settings.getSettingAsInt("format.minPoolSize", 4);
        int maxPoolSize = settings.getSettingAsInt("format.minPoolSize", 20);
        this.formatter = new ThreadSafeFormat(minPoolSize, maxPoolSize, formatterFactory);
    }

    public void setFormat(String format) {
        ThreadSafeFormat.FormatterFactory formatterFactory = this.doCreateFormatterFactory();
        formatterFactory.configure(format, Locale.getDefault());
        this.formatter = new ThreadSafeFormat(4, 20, formatterFactory);
    }

    public FormatConverter copy() {
        try {
            return (FormatConverter)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new CompassException("Should not happen", e);
        }
    }

    protected abstract ThreadSafeFormat.FormatterFactory doCreateFormatterFactory();

    protected String doGetDefaultFormat() {
        return null;
    }
}

