/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.rsem;

import java.lang.reflect.Array;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.mapping.ResourceMappingConverter;
import org.compass.core.engine.SearchEngine;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.marshall.MarshallingContext;

public class RawResourceMappingConverter
implements ResourceMappingConverter {
    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        Resource rootResource = (Resource)root;
        resource.copy(rootResource);
        return true;
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        return resource;
    }

    public boolean marshallIds(Resource idResource, Object id, ResourceMapping resourceMapping, MarshallingContext context) throws ConversionException {
        SearchEngine searchEngine = context.getSearchEngine();
        ResourcePropertyMapping[] ids = resourceMapping.getIdMappings();
        if (id instanceof Resource) {
            for (int i = 0; i < ids.length; ++i) {
                Resource rId = (Resource)id;
                idResource.addProperty(rId.getProperty(ids[i].getPath().getPath()));
            }
        } else if (id.getClass().isArray()) {
            if (Array.getLength(id) != ids.length) {
                throw new ConversionException("Trying to load resource with [" + Array.getLength(id) + "] while has ids mappings of [" + ids.length + "]");
            }
            if (Property.class.isAssignableFrom(id.getClass().getComponentType())) {
                for (int i = 0; i < ids.length; ++i) {
                    idResource.addProperty((Property)Array.get(id, i));
                }
            } else {
                for (int i = 0; i < ids.length; ++i) {
                    idResource.addProperty(searchEngine.createProperty(ids[i].getPath().getPath(), Array.get(id, i).toString(), Property.Store.YES, Property.Index.UN_TOKENIZED));
                }
            }
        } else {
            if (ids.length != 1) {
                throw new ConversionException("Trying to load resource which has more than one id mappings with only one id value");
            }
            if (id instanceof Property) {
                idResource.addProperty((Property)id);
            } else {
                idResource.addProperty(searchEngine.createProperty(ids[0].getPath().getPath(), id.toString(), Property.Store.YES, Property.Index.UN_TOKENIZED));
            }
        }
        return true;
    }

    public Object[] unmarshallIds(Object id, ResourceMapping resourceMapping, MarshallingContext context) throws ConversionException {
        Object[] ids = resourceMapping.getIdMappings();
        Object[] idsValues = new Object[ids.length];
        if (id instanceof Resource) {
            Resource resource = (Resource)id;
            for (int i = 0; i < ids.length; ++i) {
                idsValues[i] = resource.getProperty(ids[i].getPath().getPath());
            }
        } else {
            throw new ConversionException("Object [" + id + "] not supported");
        }
        return ids;
    }
}

