/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.spi.MultiResource;
import org.compass.core.spi.ResourceKey;
import org.compass.core.util.StringUtils;

public class LuceneMultiResource
implements MultiResource,
Map {
    private LuceneResource currentResource;
    private ArrayList resources = new ArrayList();
    private String alias;
    private transient LuceneSearchEngine searchEngine;

    public LuceneMultiResource(String alias, LuceneSearchEngine searchEngine) {
        this.alias = alias;
        this.searchEngine = searchEngine;
        this.currentResource = new LuceneResource(alias, searchEngine);
        this.resources.add(this.currentResource);
    }

    public int size() {
        return this.resources.size();
    }

    public Resource currentResource() {
        return this.currentResource;
    }

    public ResourceKey resourceKey() {
        return this.currentResource.resourceKey();
    }

    public void addResource() {
        this.currentResource = new LuceneResource(this.alias, this.searchEngine);
        this.resources.add(this.currentResource);
    }

    public Resource resource(int i) {
        return (Resource)this.resources.get(i);
    }

    public void clear() {
        this.resources.clear();
        this.currentResource = null;
    }

    public String getAlias() {
        return this.currentResource.getAlias();
    }

    public String getId() {
        return this.currentResource.getId();
    }

    public String[] getIds() {
        return this.currentResource.getIds();
    }

    public Property getIdProperty() {
        return this.currentResource.getIdProperty();
    }

    public Property[] getIdProperties() {
        return this.currentResource.getIdProperties();
    }

    public String get(String name) {
        return this.currentResource.get(name);
    }

    public Object getObject(String name) {
        return this.currentResource.getObject(name);
    }

    public String[] getValues(String name) {
        return this.currentResource.getValues(name);
    }

    public Resource addProperty(String name, Object value) throws SearchEngineException {
        this.currentResource.addProperty(name, value);
        return this;
    }

    public Resource addProperty(String name, Reader value) throws SearchEngineException {
        this.currentResource.addProperty(name, value);
        return this;
    }

    public Resource addProperty(Property property) {
        this.currentResource.addProperty(property);
        return this;
    }

    public Resource removeProperty(String name) {
        this.currentResource.removeProperty(name);
        return this;
    }

    public Resource removeProperties(String name) {
        this.currentResource.removeProperties(name);
        return this;
    }

    public Property getProperty(String name) {
        return this.currentResource.getProperty(name);
    }

    public Property[] getProperties(String name) {
        return this.currentResource.getProperties(name);
    }

    public Property[] getProperties() {
        return this.currentResource.getProperties();
    }

    public float getBoost() {
        return this.currentResource.getBoost();
    }

    public Resource setBoost(float boost) {
        this.currentResource.setBoost(boost);
        return this;
    }

    public void copy(Resource resource) {
        this.clear();
        if (resource instanceof MultiResource) {
            MultiResource multiResource = (MultiResource)resource;
            for (int i = 0; i < multiResource.size(); ++i) {
                this.addResource();
                this.currentResource.copy(multiResource.resource(i));
            }
        } else {
            this.currentResource = (LuceneResource)resource;
            this.resources.add(resource);
        }
    }

    public String toString() {
        if (this.resources.size() == 1) {
            return this.resource(0).toString();
        }
        return StringUtils.collectionToCommaDelimitedString(this.resources);
    }

    public boolean isEmpty() {
        return this.currentResource.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.currentResource.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.currentResource.containsValue(value);
    }

    public Collection values() {
        return this.currentResource.values();
    }

    public void putAll(Map t) {
        this.currentResource.putAll(t);
    }

    public Set entrySet() {
        return this.currentResource.entrySet();
    }

    public Set keySet() {
        return this.currentResource.keySet();
    }

    public Object get(Object key) {
        return this.currentResource.get(key);
    }

    public Object remove(Object key) {
        return this.currentResource.remove(key);
    }

    public Object put(Object key, Object value) {
        return this.currentResource.put(key, value);
    }
}

