/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.optimizer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineOptimizer;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.optimizer.LuceneSearchEngineOptimizer;
import org.compass.core.util.backport.java.util.concurrent.Executors;
import org.compass.core.util.backport.java.util.concurrent.ScheduledExecutorService;
import org.compass.core.util.backport.java.util.concurrent.TimeUnit;
import org.compass.core.util.concurrent.SingleThreadThreadFactory;

public class ScheduledLuceneSearchEngineOptimizer
implements LuceneSearchEngineOptimizer {
    private static final Log log = LogFactory.getLog((Class)ScheduledLuceneSearchEngineOptimizer.class);
    private LuceneSearchEngineOptimizer optimizer;
    private ScheduledExecutorService scheduledExecutorService;

    public ScheduledLuceneSearchEngineOptimizer(LuceneSearchEngineOptimizer optimizer) {
        this.optimizer = optimizer;
    }

    public LuceneSearchEngineOptimizer getWrappedOptimizer() {
        return this.optimizer;
    }

    public synchronized void start() throws SearchEngineException {
        if (this.isRunning()) {
            throw new IllegalStateException("Optimizer is already running");
        }
        this.optimizer.start();
        CompassSettings settings = this.getSearchEngineFactory().getSettings();
        boolean daemon = settings.getSettingAsBoolean("compass.engine.optimizer.schedule.daemon", true);
        long period = (long)(settings.getSettingAsFloat("compass.engine.optimizer.schedule.period", 10.0f) * 1000.0f);
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting scheduled optimizer [" + this.optimizer.getClass() + "] with period [" + period + "ms] daemon [" + daemon + "]"));
        }
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new SingleThreadThreadFactory("Compass Scheduled Optimizer", daemon));
        ScheduledOptimizeRunnable scheduledOptimizeRunnable = new ScheduledOptimizeRunnable(this.getSearchEngineFactory().getOptimizer());
        this.scheduledExecutorService.scheduleWithFixedDelay(scheduledOptimizeRunnable, period, period, TimeUnit.MILLISECONDS);
    }

    public synchronized void stop() throws SearchEngineException {
        if (!this.isRunning()) {
            throw new IllegalStateException("Optimizer is not running");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Stopping scheduled optimizer [" + this.optimizer.getClass() + "]"));
        }
        this.optimizer.stop();
        this.scheduledExecutorService.shutdown();
        this.scheduledExecutorService = null;
    }

    public LuceneSearchEngineFactory getSearchEngineFactory() {
        return this.optimizer.getSearchEngineFactory();
    }

    public void setSearchEngineFactory(LuceneSearchEngineFactory searchEngineFactory) {
        this.optimizer.setSearchEngineFactory(searchEngineFactory);
    }

    public boolean needOptimization() throws SearchEngineException {
        return this.optimizer.needOptimization();
    }

    public void optimize() throws SearchEngineException {
        this.optimizer.optimize();
    }

    public boolean needOptimization(String subIndex) throws SearchEngineException {
        return this.optimizer.needOptimization(subIndex);
    }

    public void optimize(String subIndex) throws SearchEngineException {
        this.optimizer.optimize(subIndex);
    }

    public boolean isRunning() {
        return this.optimizer.isRunning();
    }

    public boolean canBeScheduled() {
        return false;
    }

    private static class ScheduledOptimizeRunnable
    implements Runnable {
        private SearchEngineOptimizer optimizer;

        public ScheduledOptimizeRunnable(SearchEngineOptimizer optimizer) {
            this.optimizer = optimizer;
        }

        public void run() {
            block3: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Checking for index optimization");
                }
                try {
                    this.optimizer.optimize();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"Failed to optimize", (Throwable)e);
                }
            }
        }
    }
}

