/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.query;

import java.util.ArrayList;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;

public class LuceneSearchEngineQuerySpanNearBuilder
implements SearchEngineQueryBuilder.SearchEngineQuerySpanNearBuilder {
    private LuceneSearchEngine searchEngine;
    private String resourceProperty;
    private int slop = 0;
    private boolean inOrder = true;
    private ArrayList values = new ArrayList();

    public LuceneSearchEngineQuerySpanNearBuilder(LuceneSearchEngine searchEngine, String resourceProperty) {
        this.searchEngine = searchEngine;
        this.resourceProperty = resourceProperty;
    }

    public SearchEngineQueryBuilder.SearchEngineQuerySpanNearBuilder setSlop(int slop) {
        this.slop = slop;
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineQuerySpanNearBuilder setInOrder(boolean inOrder) {
        this.inOrder = inOrder;
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineQuerySpanNearBuilder add(String value) {
        this.values.add(new SpanTermQuery(new Term(this.resourceProperty, value)));
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineQuerySpanNearBuilder add(SearchEngineQuery.SearchEngineSpanQuery query) {
        this.values.add(((LuceneSearchEngineQuery.LuceneSearchEngineSpanQuery)query).getQuery());
        return this;
    }

    public SearchEngineQuery.SearchEngineSpanQuery toQuery() {
        SpanQuery[] spanQueries = this.values.toArray(new SpanQuery[this.values.size()]);
        SpanNearQuery spanNearQuery = new SpanNearQuery(spanQueries, this.slop, this.inOrder);
        return new LuceneSearchEngineQuery.LuceneSearchEngineSpanQuery(this.searchEngine, (SpanQuery)spanNearQuery);
    }
}

