/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.query;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.queryparser.LuceneQueryParser;

public class LuceneSearchEngineQueryStringBuilder
implements SearchEngineQueryBuilder.SearchEngineQueryStringBuilder {
    private LuceneSearchEngine searchEngine;
    private Analyzer analyzer;
    private String defaultSearchProperty;
    private String queryString;
    private QueryParser.Operator operator = QueryParser.Operator.OR;
    private LuceneQueryParser queryParser;

    public LuceneSearchEngineQueryStringBuilder(LuceneSearchEngine searchEngine, String queryString) {
        this.searchEngine = searchEngine;
        this.queryString = queryString;
        this.analyzer = searchEngine.getSearchEngineFactory().getAnalyzerManager().getSearchAnalyzer();
        this.queryParser = searchEngine.getSearchEngineFactory().getQueryParserManager().getDefaultQueryParser();
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder setAnalyzer(String analyzer) {
        this.analyzer = this.searchEngine.getSearchEngineFactory().getAnalyzerManager().getAnalyzerMustExist(analyzer);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder setAnalyzerByAlias(String alias) {
        this.analyzer = this.searchEngine.getSearchEngineFactory().getAnalyzerManager().getAnalyzerByAliasMustExists(alias);
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder setDefaultSearchProperty(String defaultSearchProperty) {
        this.defaultSearchProperty = defaultSearchProperty;
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder useAndDefaultOperator() {
        this.operator = QueryParser.Operator.AND;
        return this;
    }

    public SearchEngineQueryBuilder.SearchEngineQueryStringBuilder setQueryParser(String queryParser) {
        this.queryParser = this.searchEngine.getSearchEngineFactory().getQueryParserManager().getQueryParser(queryParser);
        return this;
    }

    public SearchEngineQuery toQuery() {
        String defaultSearch = this.defaultSearchProperty;
        if (defaultSearch == null) {
            defaultSearch = this.searchEngine.getSearchEngineFactory().getLuceneSettings().getDefaultSearchPropery();
        }
        Query qQuery = this.queryParser.parse(defaultSearch, this.operator, this.analyzer, this.queryString);
        return new LuceneSearchEngineQuery(this.searchEngine, qQuery);
    }
}

