/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LuceneUtils;
import org.apache.lucene.store.Directory;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.event.SearchEngineEventManager;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSettings;
import org.compass.core.lucene.engine.store.LuceneSearchEngineStore;
import org.compass.core.lucene.engine.store.LuceneStoreTemplate;
import org.compass.core.lucene.engine.store.wrapper.DirectoryWrapperProvider;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.StringUtils;

public abstract class AbstractLuceneSearchEngineStore
implements LuceneSearchEngineStore {
    protected Log log = LogFactory.getLog(this.getClass());
    private Map aliasesBySubIndex = new HashMap();
    private Map subIndexesByAlias = new HashMap();
    private String[] subIndexes;
    protected LuceneStoreTemplate template;
    protected String connectionString;
    protected String subContext;
    private LuceneSettings luceneSettings;
    private DirectoryWrapperProvider[] directoryWrapperProviders;
    private HashMap dirs = new HashMap();

    public AbstractLuceneSearchEngineStore(String connectionString, String subContext) {
        this.connectionString = connectionString;
        this.subContext = subContext;
    }

    public void configure(LuceneSearchEngineFactory searchEngineFactory, CompassSettings settings, CompassMapping mapping) {
        this.template = new LuceneStoreTemplate(this);
        this.luceneSettings = searchEngineFactory.getLuceneSettings();
        HashSet<String> subIndexesSet = new HashSet<String>();
        ResourceMapping[] rootMappings = mapping.getRootMappings();
        for (int i = 0; i < rootMappings.length; ++i) {
            ResourceMapping resourceMapping = rootMappings[i];
            String alias = resourceMapping.getAlias();
            String[] tempSubIndexes = resourceMapping.getSubIndexHash().getSubIndexes();
            for (int j = 0; j < tempSubIndexes.length; ++j) {
                String subIndex = tempSubIndexes[j];
                subIndexesSet.add(subIndex.intern());
                ArrayList<String> list = (ArrayList<String>)this.subIndexesByAlias.get(alias);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.subIndexesByAlias.put(alias, list);
                }
                list.add(subIndex);
                list = (ArrayList<String>)this.aliasesBySubIndex.get(subIndex);
                if (this.aliasesBySubIndex.get(subIndex) == null) {
                    list = new ArrayList<String>();
                    this.aliasesBySubIndex.put(subIndex, list);
                }
                list.add(alias);
            }
        }
        this.subIndexes = subIndexesSet.toArray(new String[subIndexesSet.size()]);
        Map dwSettingGroups = settings.getSettingGroups("compass.engine.store.wrapper");
        if (dwSettingGroups.size() > 0) {
            ArrayList<DirectoryWrapperProvider> dws = new ArrayList<DirectoryWrapperProvider>();
            Iterator it = dwSettingGroups.entrySet().iterator();
            while (it.hasNext()) {
                DirectoryWrapperProvider dw;
                CompassSettings dwSettings;
                String dwType;
                Map.Entry entry = it.next();
                String dwName = (String)entry.getKey();
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Building directory wrapper [" + dwName + "]"));
                }
                if ((dwType = (dwSettings = (CompassSettings)entry.getValue()).getSetting("type")) == null) {
                    throw new ConfigurationException("Directory wrapper [" + dwName + "] has no type associated with it");
                }
                try {
                    dw = (DirectoryWrapperProvider)ClassUtils.forName(dwType).newInstance();
                }
                catch (Exception e) {
                    throw new ConfigurationException("Failed to create directory wrapper [" + dwName + "]", e);
                }
                if (dw instanceof CompassConfigurable) {
                    ((CompassConfigurable)((Object)dw)).configure(dwSettings);
                }
                dws.add(dw);
            }
            this.directoryWrapperProviders = dws.toArray(new DirectoryWrapperProvider[dws.size()]);
        }
    }

    public void close() {
        this.closeDirectories();
        this.doClose();
    }

    protected void closeDirectories() {
        Iterator it = this.dirs.values().iterator();
        while (it.hasNext()) {
            Directory dir = (Directory)it.next();
            try {
                dir.close();
            }
            catch (IOException e) {
                this.log.debug((Object)"Failed to close directory while shutting down, ignoring", (Throwable)e);
            }
        }
        this.dirs.clear();
    }

    protected void doClose() {
    }

    public void performScheduledTasks() {
    }

    public void closeDirectory(String subIndex, Directory dir) throws SearchEngineException {
    }

    public int getNumberOfAliasesBySubIndex(String subIndex) {
        return ((ArrayList)this.aliasesBySubIndex.get(subIndex)).size();
    }

    public Directory getDirectoryBySubIndex(String subIndex, boolean create) throws SearchEngineException {
        Directory dir = (Directory)this.dirs.get(subIndex);
        if (dir == null) {
            dir = this.openDirectoryBySubIndex(subIndex, create);
            this.dirs.put(subIndex, dir);
            return dir;
        }
        if (create) {
            try {
                dir.close();
            }
            catch (IOException e) {
                this.log.warn((Object)"Failed to close directory", (Throwable)e);
            }
            dir = this.openDirectoryBySubIndex(subIndex, create);
            this.dirs.put(subIndex, dir);
        }
        return dir;
    }

    private Directory openDirectoryBySubIndex(String subIndex, boolean create) throws SearchEngineException {
        Directory dir = this.doOpenDirectoryBySubIndex(subIndex, create);
        if (this.directoryWrapperProviders != null) {
            for (int i = 0; i < this.directoryWrapperProviders.length; ++i) {
                dir = this.directoryWrapperProviders[i].wrap(subIndex, dir);
            }
        }
        return dir;
    }

    protected abstract Directory doOpenDirectoryBySubIndex(String var1, boolean var2) throws SearchEngineException;

    private void createIndex(String subIndex) throws SearchEngineException {
        this.template.executeForSubIndex(subIndex, true, new LuceneSearchEngineStore.LuceneStoreCallback(){

            public Object doWithStore(Directory dir) throws IOException {
                IndexWriter indexWriter = new IndexWriter(dir, (Analyzer)new StandardAnalyzer(), true);
                indexWriter.close();
                return null;
            }
        });
    }

    protected boolean indexExists(String subIndex) throws SearchEngineException {
        try {
            Boolean retVal = (Boolean)this.template.executeForSubIndex(subIndex, false, new LuceneSearchEngineStore.LuceneStoreCallback(){

                public Object doWithStore(Directory dir) throws IOException {
                    return AbstractLuceneSearchEngineStore.this.indexExists(dir);
                }
            });
            return retVal;
        }
        catch (SearchEngineException e) {
            return false;
        }
    }

    protected Boolean indexExists(Directory dir) throws IOException {
        if (!IndexReader.indexExists((Directory)dir)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected boolean verifyIndex(String subIndex) throws SearchEngineException {
        if (!this.indexExists(subIndex)) {
            this.createIndex(subIndex);
            return true;
        }
        return false;
    }

    public void createIndex() throws SearchEngineException {
        for (int i = 0; i < this.subIndexes.length; ++i) {
            this.createIndex(this.subIndexes[i]);
        }
    }

    public boolean verifyIndex() throws SearchEngineException {
        boolean createdIndex = false;
        for (int i = 0; i < this.subIndexes.length; ++i) {
            if (!this.verifyIndex(this.subIndexes[i])) continue;
            createdIndex = true;
        }
        return createdIndex;
    }

    public boolean indexExists() throws SearchEngineException {
        for (int i = 0; i < this.subIndexes.length; ++i) {
            if (this.indexExists(this.subIndexes[i])) continue;
            return false;
        }
        return true;
    }

    public void deleteIndex() throws SearchEngineException {
        this.closeDirectories();
        this.doDeleteIndex();
    }

    protected abstract void doDeleteIndex() throws SearchEngineException;

    public String[] getSubIndexes() {
        return this.subIndexes;
    }

    public String[] calcSubIndexes(String[] subIndexes, String[] aliases) {
        int i;
        if (aliases == null) {
            if (subIndexes == null) {
                return this.getSubIndexes();
            }
            return subIndexes;
        }
        HashSet ret = new HashSet();
        for (i = 0; i < aliases.length; ++i) {
            ArrayList subIndexesList = (ArrayList)this.subIndexesByAlias.get(aliases[i]);
            if (subIndexesList == null) {
                throw new IllegalArgumentException("No sub-index is mapped to alias [" + aliases[i] + "]");
            }
            for (int j = 0; j < subIndexesList.size(); ++j) {
                ret.add(subIndexesList.get(j));
            }
        }
        if (subIndexes != null) {
            for (i = 0; i < subIndexes.length; ++i) {
                ret.add(subIndexes[i]);
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    public boolean isLocked(String subIndex) throws SearchEngineException {
        Boolean retVal = (Boolean)this.template.executeForSubIndex(subIndex, false, new LuceneSearchEngineStore.LuceneStoreCallback(){

            public Object doWithStore(Directory dir) throws IOException {
                return IndexReader.isLocked((Directory)dir);
            }
        });
        return retVal;
    }

    public void registerEventListeners(SearchEngine searchEngine, SearchEngineEventManager eventManager) {
    }

    public void copyFrom(final LuceneSearchEngineStore searchEngineStore) throws SearchEngineException {
        CopyFromHolder holder = this.doBeforeCopyFrom();
        final byte[] buffer = new byte[32768];
        final LuceneStoreTemplate srcTemplate = new LuceneStoreTemplate(searchEngineStore);
        try {
            for (int i = 0; i < this.getSubIndexes().length; ++i) {
                final String subIndex = this.getSubIndexes()[i];
                this.template.executeForSubIndex(subIndex, holder.createOriginalDirectory, new LuceneSearchEngineStore.LuceneStoreCallback(){

                    public Object doWithStore(final Directory dest) {
                        srcTemplate.executeForSubIndex(subIndex, false, new LuceneSearchEngineStore.LuceneStoreCallback(){

                            public Object doWithStore(Directory src) throws IOException {
                                LuceneUtils.copy(src, searchEngineStore.getLuceneSettings().isUseCompoundFile(), dest, AbstractLuceneSearchEngineStore.this.luceneSettings.isUseCompoundFile(), buffer, AbstractLuceneSearchEngineStore.this.luceneSettings.getTransactionCommitTimeout());
                                return null;
                            }
                        });
                        return null;
                    }
                });
            }
        }
        catch (Exception e) {
            this.doAfterFailedCopyFrom(holder);
            if (e instanceof SearchEngineException) {
                throw (SearchEngineException)e;
            }
            throw new SearchEngineException("Failed to copy from " + searchEngineStore, e);
        }
        this.doAfterSuccessfulCopyFrom(holder);
    }

    protected CopyFromHolder doBeforeCopyFrom() throws SearchEngineException {
        CopyFromHolder holder = new CopyFromHolder();
        holder.createOriginalDirectory = false;
        return holder;
    }

    protected void doAfterSuccessfulCopyFrom(CopyFromHolder holder) throws SearchEngineException {
    }

    protected void doAfterFailedCopyFrom(CopyFromHolder holder) throws SearchEngineException {
    }

    public LuceneSettings getLuceneSettings() {
        return this.luceneSettings;
    }

    public String toString() {
        return "store [" + this.connectionString + "][" + this.subContext + "] sub-indexes [" + StringUtils.arrayToCommaDelimitedString(this.subIndexes) + "]";
    }

    protected class CopyFromHolder {
        boolean createOriginalDirectory = false;
        Object data;

        protected CopyFromHolder() {
        }
    }
}

