/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store.wrapper;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.wrapper.AsyncMemoryMirrorDirectoryWrapper;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.store.wrapper.DirectoryWrapperProvider;
import org.compass.core.util.backport.java.util.concurrent.ExecutorService;
import org.compass.core.util.backport.java.util.concurrent.Executors;
import org.compass.core.util.concurrent.SingleThreadThreadFactory;

public class AsyncMemoryMirrorDirectoryWrapperProvider
implements DirectoryWrapperProvider,
CompassConfigurable {
    private long awaitTermination;
    private boolean sharedThread;
    private ExecutorService executorService;

    public void configure(CompassSettings settings) throws CompassException {
        this.awaitTermination = settings.getSettingAsLong("awaitTermination", 5L);
        this.sharedThread = settings.getSettingAsBoolean("sharedThread", true);
        if (this.sharedThread) {
            this.executorService = this.doCreateExecutorService();
        }
    }

    public Directory wrap(String subIndex, Directory dir) throws SearchEngineException {
        try {
            if (this.sharedThread) {
                return new AsyncMemoryMirrorDirectoryWrapper(dir, this.awaitTermination, this.executorService);
            }
            return new AsyncMemoryMirrorDirectoryWrapper(dir, this.awaitTermination, this.doCreateExecutorService());
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to wrap directory [" + dir + "] with async memory wrapper", e);
        }
    }

    protected ExecutorService doCreateExecutorService() {
        return Executors.newSingleThreadExecutor(new SingleThreadThreadFactory("AsyncMirror Directory Wrapper", false));
    }
}

