/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction;

import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.lucene.index.HasSubIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;

public class BitSetByAliasFilter
extends Filter {
    private static final long serialVersionUID = 3618980083415921974L;
    private static final AllSetBitSet allSetBitSet = new AllSetBitSet();
    private HashMap bitSets = new HashMap();
    private boolean hasDeletes = false;
    private HashMap deleteBySubIndex = new HashMap();

    public void clear() {
        this.bitSets.clear();
        this.deleteBySubIndex.clear();
        this.hasDeletes = false;
    }

    public boolean hasDeletes() {
        return this.hasDeletes;
    }

    public IntArray getDeletesBySubIndex(String subIndex) {
        return (IntArray)this.deleteBySubIndex.get(subIndex);
    }

    public Iterator subIndexDeletesIt() {
        return this.deleteBySubIndex.keySet().iterator();
    }

    public void markDeleteBySubIndex(String subIndex, int docNum, int maxDoc) {
        BitSet bitSet = (BitSet)this.bitSets.get(subIndex);
        if (bitSet == null) {
            bitSet = new BitSet(maxDoc);
            bitSet.set(0, maxDoc, true);
            this.bitSets.put(subIndex, bitSet);
        }
        bitSet.set(docNum, false);
        IntArray aliasDeletions = (IntArray)this.deleteBySubIndex.get(subIndex);
        if (aliasDeletions == null) {
            aliasDeletions = new IntArray();
            this.deleteBySubIndex.put(subIndex, aliasDeletions);
        }
        aliasDeletions.add(docNum);
        this.hasDeletes = true;
    }

    public BitSet bits(IndexReader reader) throws IOException {
        if (!(reader instanceof HasSubIndexReader)) {
            return allSetBitSet;
        }
        HasSubIndexReader hasSubIndexReader = (HasSubIndexReader)reader;
        BitSet bitSet = (BitSet)this.bitSets.get(hasSubIndexReader.getSubIndex());
        if (bitSet != null) {
            return bitSet;
        }
        return allSetBitSet;
    }

    public static class IntArray {
        private static final int DEFAULT_SIZE = 10;
        public int[] array = new int[10];
        public int length = 0;

        public void add(int val) {
            if (this.length == this.array.length) {
                int[] tempArray = new int[this.array.length + 10];
                System.arraycopy(this.array, 0, tempArray, 0, this.array.length);
                this.array = tempArray;
            }
            this.array[this.length++] = val;
        }
    }

    public static class AllSetBitSet
    extends BitSet {
        public int cardinality() {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public int length() {
            throw new UnsupportedOperationException();
        }

        public int size() {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return false;
        }

        public int nextClearBit(int fromIndex) {
            throw new UnsupportedOperationException();
        }

        public int nextSetBit(int fromIndex) {
            throw new UnsupportedOperationException();
        }

        public void clear(int bitIndex) {
            throw new UnsupportedOperationException();
        }

        public void set(int bitIndex) {
        }

        public boolean get(int bitIndex) {
            return true;
        }

        public void clear(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        public void flip(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        public void set(int fromIndex, int toIndex) {
        }

        public void set(int fromIndex, int toIndex, boolean value) {
        }

        public void set(int bitIndex, boolean value) {
        }

        public Object clone() {
            return super.clone();
        }

        public boolean equals(Object obj) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "AllBitSet";
        }

        public BitSet get(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        public void and(BitSet set) {
            throw new UnsupportedOperationException();
        }

        public void andNot(BitSet set) {
            throw new UnsupportedOperationException();
        }

        public void or(BitSet set) {
            throw new UnsupportedOperationException();
        }

        public void xor(BitSet set) {
            throw new UnsupportedOperationException();
        }

        public boolean intersects(BitSet set) {
            throw new UnsupportedOperationException();
        }
    }
}

