/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.transaction;

import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.config.CompassSettings;
import org.compass.core.jndi.NamingHelper;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.transaction.AbstractTransactionFactory;
import org.compass.core.transaction.TransactionException;
import org.compass.core.transaction.TransactionManagerLookup;
import org.compass.core.transaction.TransactionManagerLookupFactory;
import org.compass.core.transaction.UserTransactionAdapter;
import org.compass.core.util.backport.java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractJTATransactionFactory
extends AbstractTransactionFactory {
    private static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    private transient Map currentSessionMap = new ConcurrentHashMap();
    private InitialContext context;
    private String utName;
    private UserTransaction userTransaction;
    private TransactionManager transactionManager;

    public void doConfigure(CompassSettings settings) throws CompassException {
        boolean cacheUserTransaction;
        try {
            this.context = NamingHelper.getInitialContext(settings);
        }
        catch (NamingException ne) {
            throw new CompassException("Could not obtain initial context", ne);
        }
        this.utName = settings.getSetting("compass.transaction.userTransactionName");
        TransactionManagerLookup lookup = TransactionManagerLookupFactory.getTransactionManagerLookup(settings);
        if (lookup != null) {
            this.transactionManager = lookup.getTransactionManager(settings);
            if (this.transactionManager == null) {
                throw new CompassException("Failed to find transaction manager");
            }
            if (this.utName == null) {
                this.utName = lookup.getUserTransactionName();
            }
        } else {
            throw new CompassException("Must register a transaction manager lookup using the compass.transaction.managerLookup property");
        }
        if (this.utName == null) {
            this.utName = DEFAULT_USER_TRANSACTION_NAME;
        }
        if (cacheUserTransaction = settings.getSettingAsBoolean("compass.transaction.cacheUserTransaction", true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Caching JTA UserTransaction from Jndi [" + this.utName + "]"));
            }
            this.userTransaction = this.lookupUserTransaction();
        }
    }

    protected boolean isWithinExistingTransaction(InternalCompassSession session) throws CompassException {
        try {
            return this.getUserTransaction().getStatus() != 6;
        }
        catch (SystemException e) {
            throw new CompassException("Failed to get staus on JTA transaciton", e);
        }
    }

    public CompassSession getTransactionBoundSession() throws CompassException {
        UserTransaction ut = this.getUserTransaction();
        try {
            if (ut.getStatus() == 6) {
                return null;
            }
            Transaction tr = this.transactionManager.getTransaction();
            return (CompassSession)this.currentSessionMap.get(tr);
        }
        catch (SystemException e) {
            throw new TransactionException("Failed to fetch transaction bound session", e);
        }
    }

    protected void doBindSessionToTransaction(CompassTransaction tr, CompassSession session) throws CompassException {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            this.currentSessionMap.put(tx, session);
        }
        catch (SystemException e) {
            throw new TransactionException("Failed to bind session to transcation", e);
        }
    }

    public void unbindSessionFromTransaction(Transaction tx) {
        this.currentSessionMap.remove(tx);
    }

    protected TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    protected UserTransaction getUserTransaction() throws TransactionException {
        if (this.userTransaction != null) {
            return this.userTransaction;
        }
        return this.lookupUserTransaction();
    }

    private UserTransaction lookupUserTransaction() throws TransactionException {
        UserTransaction ut;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Looking for UserTransaction under [" + this.utName + "]"));
        }
        try {
            ut = (UserTransaction)this.context.lookup(this.utName);
        }
        catch (NamingException ne) {
            ut = null;
        }
        if (ut == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Failed to locate a UserTransaction under [" + this.utName + "], creating UserTransactionAdapter in its place"));
            }
            ut = new UserTransactionAdapter(this.transactionManager);
        }
        return ut;
    }
}

