/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.lifecycle;

import javax.persistence.EntityManagerFactory;
import org.compass.gps.device.jpa.AbstractDeviceJpaEntityListener;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.lifecycle.JpaEntityLifecycleInjector;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.event.EventListeners;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.impl.SessionFactoryImpl;

public class HibernateJpaEntityLifecycleInjector
implements JpaEntityLifecycleInjector {
    public void injectLifecycle(EntityManagerFactory entityManagerFactory, JpaGpsDevice device) throws JpaGpsDeviceException {
        HibernateEntityManagerFactory hibernateEntityManagerFactory = (HibernateEntityManagerFactory)entityManagerFactory;
        SessionFactoryImpl sessionFactory = (SessionFactoryImpl)hibernateEntityManagerFactory.getSessionFactory();
        EventListeners eventListeners = sessionFactory.getEventListeners();
        HibernateEventListener hibernateEventListener = new HibernateEventListener(device);
        PostInsertEventListener[] postInsertEventListeners = eventListeners.getPostInsertEventListeners();
        PostInsertEventListener[] tempPostInsertEventListeners = new PostInsertEventListener[postInsertEventListeners.length + 1];
        System.arraycopy(postInsertEventListeners, 0, tempPostInsertEventListeners, 0, postInsertEventListeners.length);
        tempPostInsertEventListeners[postInsertEventListeners.length] = hibernateEventListener;
        eventListeners.setPostInsertEventListeners(tempPostInsertEventListeners);
        PostUpdateEventListener[] postUpdateEventListeners = eventListeners.getPostUpdateEventListeners();
        PostUpdateEventListener[] tempPostUpdateEventListeners = new PostUpdateEventListener[postUpdateEventListeners.length + 1];
        System.arraycopy(postUpdateEventListeners, 0, tempPostUpdateEventListeners, 0, postUpdateEventListeners.length);
        tempPostUpdateEventListeners[postUpdateEventListeners.length] = hibernateEventListener;
        eventListeners.setPostUpdateEventListeners(tempPostUpdateEventListeners);
        PostDeleteEventListener[] postDeleteEventListeners = eventListeners.getPostDeleteEventListeners();
        PostDeleteEventListener[] tempPostDeleteEventListeners = new PostDeleteEventListener[postDeleteEventListeners.length + 1];
        System.arraycopy(postDeleteEventListeners, 0, tempPostDeleteEventListeners, 0, postDeleteEventListeners.length);
        tempPostDeleteEventListeners[postDeleteEventListeners.length] = hibernateEventListener;
        eventListeners.setPostDeleteEventListeners(tempPostDeleteEventListeners);
    }

    private class HibernateEventListener
    extends AbstractDeviceJpaEntityListener
    implements PostInsertEventListener,
    PostUpdateEventListener,
    PostDeleteEventListener {
        private JpaGpsDevice device;

        public HibernateEventListener(JpaGpsDevice device) {
            this.device = device;
        }

        protected JpaGpsDevice getDevice() {
            return this.device;
        }

        public void onPostInsert(PostInsertEvent postInsertEvent) {
            this.postPersist(postInsertEvent.getEntity());
        }

        public void onPostUpdate(PostUpdateEvent postUpdateEvent) {
            this.postUpdate(postUpdateEvent.getEntity());
        }

        public void onPostDelete(PostDeleteEvent postDeleteEvent) {
            this.postRemove(postDeleteEvent.getEntity());
        }
    }
}

