/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.contrib;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.Calls;
import org.directwebremoting.extend.Replies;
import org.directwebremoting.extend.Reply;
import org.directwebremoting.impl.DefaultRemoter;
import org.directwebremoting.util.Logger;

public class ParallelDefaultRemoter
extends DefaultRemoter {
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$contrib$ParallelDefaultRemoter == null ? (class$org$directwebremoting$contrib$ParallelDefaultRemoter = ParallelDefaultRemoter.class$("org.directwebremoting.contrib.ParallelDefaultRemoter")) : class$org$directwebremoting$contrib$ParallelDefaultRemoter);
    private int corePoolsize = 10;
    private int maximumPoolsize = 100;
    private long keepAliveTime = 5000L;
    private long timeout = 10000L;
    private ThreadPoolExecutor executorService = (ThreadPoolExecutor)Executors.newCachedThreadPool();
    static /* synthetic */ Class class$org$directwebremoting$contrib$ParallelDefaultRemoter;

    public ParallelDefaultRemoter() {
        this.executorService.setCorePoolSize(this.corePoolsize);
        this.executorService.setMaximumPoolSize(this.maximumPoolsize);
        this.executorService.setKeepAliveTime(this.keepAliveTime, TimeUnit.MILLISECONDS);
        log.info(this.executorService.getClass().getName().indexOf("edu.emory.mathcs.backport") > -1 ? "Backport of java.util.concurrent package used !" : "java.util.concurrent package used !");
    }

    public void setParallelDefaultRemoterTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setParallelDefaultRemoterCorePoolsize(int corePoolsize) {
        this.corePoolsize = corePoolsize;
        this.executorService.setCorePoolSize(corePoolsize);
    }

    public void setParallelDefaultRemoterMaximumPoolsize(int maximumPoolsize) {
        this.maximumPoolsize = maximumPoolsize;
        this.executorService.setMaximumPoolSize(maximumPoolsize);
    }

    public void setParallelDefaultRemoterKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
        this.executorService.setKeepAliveTime(keepAliveTime, TimeUnit.MILLISECONDS);
    }

    public Replies execute(Calls calls) {
        int callNum;
        Replies replies = new Replies(calls.getBatchId());
        Future[] future = new Future[calls.getCallCount()];
        if (calls.getCallCount() == 1) {
            return super.execute(calls);
        }
        for (callNum = 0; callNum < calls.getCallCount(); ++callNum) {
            Call call = calls.getCall(callNum);
            future[callNum] = this.executorService.submit((Callable)new OneCall(call));
        }
        for (callNum = 0; callNum < calls.getCallCount(); ++callNum) {
            try {
                Reply reply = (Reply)future[callNum].get(this.timeout, TimeUnit.MILLISECONDS);
                replies.addReply(reply);
                continue;
            }
            catch (InterruptedException ex) {
                log.warn("Method execution failed: ", ex);
                replies.addReply(new Reply(calls.getCall(callNum).getCallId(), null, ex));
                continue;
            }
            catch (ExecutionException ex) {
                log.warn("Method execution failed: ", ex);
                replies.addReply(new Reply(calls.getCall(callNum).getCallId(), null, ex));
                continue;
            }
            catch (TimeoutException ex) {
                log.warn("Method execution failed: ", ex);
                replies.addReply(new Reply(calls.getCall(callNum).getCallId(), null, ex));
            }
        }
        return replies;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class OneCall
    implements Callable {
        private Call call;

        public OneCall(Call call) {
            this.call = call;
        }

        public Object call() {
            return ParallelDefaultRemoter.this.execute(this.call);
        }
    }
}

