/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.extend.WaitController;
import org.directwebremoting.impl.AbstractServerLoadMonitor;
import org.directwebremoting.util.HitMonitor;
import org.directwebremoting.util.Logger;

public class DefaultServerLoadMonitor
extends AbstractServerLoadMonitor
implements ServerLoadMonitor {
    protected static final int usageHighDisconnectedTime = 1000;
    protected static final int usageHighInitialConnectedTime = 49000;
    protected static final int usageHighFinalConnectedTime = 1000;
    protected static final int usageDiggConnectedTime = 0;
    protected static final int usageDiggMinDisconnectedTime = 2000;
    protected static final int hitOutRoundTripTime = 2000;
    protected static final int threadOutRoundTripTime = 50000;
    protected int maxWaitingThreads = 100;
    protected int maxHitsPerSecond = 100;
    protected int maxConnectedTime = 60000;
    protected static final int USAGE_LOW = 0;
    protected static final int USAGE_HIGH = 1;
    protected static final int USAGE_DIGG = 2;
    protected static final String[] USAGE_NAMES = new String[]{"Low", "High", "Digg"};
    protected int mode = 0;
    protected int connectedTime = 60000;
    protected int disconnectedTime = 1000;
    protected static final int SECONDS_MONITORED = 10;
    protected HitMonitor hitMonitor = new HitMonitor(10);
    protected int waitingThreads = 0;
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$impl$DefaultServerLoadMonitor == null ? (class$org$directwebremoting$impl$DefaultServerLoadMonitor = DefaultServerLoadMonitor.class$("org.directwebremoting.impl.DefaultServerLoadMonitor")) : class$org$directwebremoting$impl$DefaultServerLoadMonitor);
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultServerLoadMonitor;

    public long getConnectedTime() {
        return this.connectedTime;
    }

    public int getDisconnectedTime() {
        return this.disconnectedTime;
    }

    public void threadWaitStarting(WaitController controller) {
        this.hitMonitor.recordHit();
        ++this.waitingThreads;
        super.threadWaitStarting(controller);
        this.checkLoading();
    }

    public void threadWaitEnding(WaitController controller) {
        --this.waitingThreads;
        super.threadWaitEnding(controller);
    }

    private void checkLoading() {
        float load;
        float hitsPerSecond = (float)this.hitMonitor.getHitsInLastPeriod() / 10.0f;
        if (this.waitingThreads < this.maxWaitingThreads) {
            this.connectedTime = this.maxConnectedTime;
            this.disconnectedTime = 0;
            this.setMode(0);
            return;
        }
        int roundTripAtThreadOutSeconds = 50;
        int hitsPerSecondAtThreadOut = this.maxWaitingThreads / roundTripAtThreadOutSeconds;
        int hitsPerSecondAtHitOut = this.maxHitsPerSecond;
        if (hitsPerSecond < (float)hitsPerSecondAtThreadOut) {
            this.connectedTime = 49000;
            this.disconnectedTime = 1000;
            this.setMode(1);
            return;
        }
        if (this.mode == 2) {
            load = hitsPerSecond / (float)this.maxHitsPerSecond;
            this.connectedTime = 0;
            this.disconnectedTime = (int)((float)this.disconnectedTime * load);
            if (this.disconnectedTime > 2000) {
                this.setMode(2);
                return;
            }
        }
        if (hitsPerSecond < (float)hitsPerSecondAtHitOut) {
            float factor = (float)this.waitingThreads / (float)this.maxWaitingThreads;
            this.connectedTime = (int)((float)this.connectedTime / factor);
            if (this.connectedTime > 49000) {
                this.connectedTime = 49000;
            }
            if (this.connectedTime < 1000) {
                this.connectedTime = 1000;
            }
            this.disconnectedTime = 1000;
            this.setMode(1);
            return;
        }
        load = hitsPerSecond / (float)this.maxHitsPerSecond;
        this.connectedTime = 0;
        this.disconnectedTime = (int)((float)this.disconnectedTime * load);
        if (this.disconnectedTime < 2000) {
            this.disconnectedTime = 2000;
        }
        this.setMode(2);
    }

    protected void setMode(int mode) {
        if (log.isDebugEnabled() && mode != this.mode) {
            log.debug("Changing modes, from " + USAGE_NAMES[this.mode] + " to " + USAGE_NAMES[mode]);
        }
        this.mode = mode;
    }

    public void setMaxWaitingThreads(int maxWaitingThreads) {
        this.maxWaitingThreads = maxWaitingThreads;
    }

    public void setMaxHitsPerSecond(int maxHitsPerSecond) {
        this.maxHitsPerSecond = maxHitsPerSecond;
    }

    void setMaxConnectedTime(int maxConnectedTime) {
        this.maxConnectedTime = maxConnectedTime;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

