/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import com.informix.jdbc.IfxConnection;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.stringUtil;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;

public class dateUtil {
    public static final int NUMSECSINHR = 3600;
    public static final int NUMSECSINDY = 86400;
    public static final int NUMSECSINWK = 604800;
    public static final int NUMSECSINMN = 18144000;
    public static final int NUMSECSINYR = 217728000;
    private static final char ERA_ID = 'E';
    private static final char DAY_ID = 'D';
    private static final char MONTH_ID = 'M';
    private static final char YEAR_ID = 'Y';
    private static final char PERCENT = '%';
    private static final char CQUOTE = '\'';
    private static final char SPACE = ' ';
    private static final char FOUR_DIGIT_YEAR = '4';
    private static final char TWO_DIGIT_YEAR = '2';
    private static final String SLASH = "/";
    private static final String COLON = ":";
    private static final String HYPHEN = "-";
    private static final String PERIOD = ".";
    private static final String NOSEP = "0";
    private static final String UNDERSCORE = "_";
    private static final String SQUOTE = "'";
    private static final String CDIRTAG = ";;;;";
    private static final String WDIRTAG = ";;;;;";
    private static final String ZEROS = "000000000";
    private static final String AM = "AM";
    private static final String PM = "PM";
    private static final String NONALPHANUMTOKS = "/-.: ~`!@#$%^&*()_+=\t\n\r\b{}[]|\\:;'\"<>,?";
    static int[] numDaysArr = new int[12];

    public static int calcNumDays(String string) {
        if (!dateUtil.isValidDate(string)) {
            return -1;
        }
        dateUtil.numDaysArr[0] = 0;
        dateUtil.numDaysArr[1] = 31;
        dateUtil.numDaysArr[2] = 59;
        dateUtil.numDaysArr[3] = 90;
        dateUtil.numDaysArr[4] = 120;
        dateUtil.numDaysArr[5] = 151;
        dateUtil.numDaysArr[6] = 181;
        dateUtil.numDaysArr[7] = 212;
        dateUtil.numDaysArr[8] = 243;
        dateUtil.numDaysArr[9] = 273;
        dateUtil.numDaysArr[10] = 304;
        dateUtil.numDaysArr[11] = 334;
        StringTokenizer stringTokenizer = new StringTokenizer(string, HYPHEN);
        int n = 0;
        if (dateUtil.isValidDate(string)) {
            int n2 = stringUtil.stringToInt(stringTokenizer.nextToken());
            int n3 = stringUtil.stringToInt(stringTokenizer.nextToken());
            int n4 = stringUtil.stringToInt(stringTokenizer.nextToken());
            n = numDaysArr[n3 - 1] + n4;
            if (n3 > 2 && dateUtil.isLeapYear(n2)) {
                ++n;
            }
        }
        return n;
    }

    public static boolean isValidTimeStamp(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() != 2) {
            return false;
        }
        if (!dateUtil.isValidDate(stringTokenizer.nextToken())) {
            return false;
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.indexOf(46) == -1) {
            return dateUtil.isValidTime(string2);
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, PERIOD);
        if (stringTokenizer2.countTokens() != 2) {
            return false;
        }
        if (!dateUtil.isValidTime(stringTokenizer2.nextToken())) {
            return false;
        }
        String string3 = stringTokenizer2.nextToken();
        return stringUtil.isANum(string3) && string3.length() <= 8;
    }

    public static String IfxTimeStamp(String string) {
        if (string.length() > 25) {
            return string.substring(0, 25);
        }
        return string;
    }

    public static boolean isValidTime(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, COLON);
        if (stringTokenizer.countTokens() != 3) {
            return false;
        }
        int n = stringUtil.stringToInt(stringTokenizer.nextToken());
        if (n < 0 || n > 23) {
            return false;
        }
        int n2 = stringUtil.stringToInt(stringTokenizer.nextToken());
        if (n2 < 0 || n2 > 59) {
            return false;
        }
        int n3 = stringUtil.stringToInt(stringTokenizer.nextToken());
        return n3 >= 0 && n3 <= 59;
    }

    public static boolean isValidDate(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, HYPHEN);
        if (stringTokenizer.countTokens() != 3) {
            return false;
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.length() != 4) {
            return false;
        }
        int n = stringUtil.stringToInt(string2);
        int n2 = stringUtil.stringToInt(stringTokenizer.nextToken());
        if (n2 < 1 || n2 > 12) {
            return false;
        }
        int n3 = stringUtil.stringToInt(stringTokenizer.nextToken());
        switch (n2) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                if (n3 >= 1 && n3 <= 31) break;
                return false;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                if (n3 >= 1 && n3 <= 30) break;
                return false;
            }
            case 2: {
                int n4 = 28;
                if (n % 4 == 0 && n % 100 != 0 || n % 400 == 0) {
                    n4 = 29;
                }
                if (n3 >= 1 && n3 <= n4) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static long gregToJulian(String string) {
        int n = stringUtil.stringToInt(string.substring(0, 4));
        int n2 = stringUtil.stringToInt(string.substring(5, 7));
        int n3 = stringUtil.stringToInt(string.substring(8, 10));
        long l = 1461 * (n + 4800 + (n2 - 14) / 12) / 4 + 367 * (n2 - 2 - 12 * ((n2 - 14) / 12)) / 12 - 3 * ((n + 4900 + (n2 - 14) / 12) / 100) / 4 + n3 - 32075;
        return l;
    }

    public static boolean isLeapYear(int n) {
        return n % 4 == 0 && n % 100 != 0 || n % 400 == 0;
    }

    private static String getdbDateStr(java.sql.Date date, String string, String string2) throws SQLException {
        String string3 = "";
        String string4 = "";
        String string5 = null;
        boolean bl = false;
        int n = 0;
        Locale locale = dateUtil.getLocaleValue(string);
        if (string2.length() < 4 || string2.length() > 6) {
            throw IfxErrMsg.getSQLException(-79797, "\"" + string2 + "\"", locale);
        }
        String string6 = string2.substring(string2.length() - 1);
        if (string6.equals(SLASH) || string6.equals(HYPHEN) || string6.equals(PERIOD)) {
            string5 = string6;
            bl = true;
        } else if (string6.equals(NOSEP)) {
            string5 = "";
            bl = true;
        } else {
            if (!(string6.equals("E") || string6.equals("2") || string6.equals("4") || string6.equals("M") || string6.equals("D"))) {
                bl = true;
            }
            string5 = SLASH;
        }
        n = bl ? string2.length() - 1 : string2.length();
        block7: for (int i2 = 0; i2 < n; ++i2) {
            switch (string2.charAt(i2)) {
                case 'E': {
                    if (i2 == 0) {
                        string3 = string3 + "GGG ";
                        continue block7;
                    }
                    string3 = string3 + " GGG ";
                    continue block7;
                }
                case 'D': {
                    string3 = string3 + "dd" + string5;
                    continue block7;
                }
                case 'M': {
                    string3 = string3 + "MM" + string5;
                    continue block7;
                }
                case 'Y': {
                    if (i2 + 1 == n) {
                        throw IfxErrMsg.getSQLException(-79798, "\"" + string2 + "\"", locale);
                    }
                    if (string2.charAt(i2 + 1) == '2' || string2.charAt(i2 + 1) == '4') continue block7;
                    throw IfxErrMsg.getSQLException(-79799, "\"" + string2 + "\"", locale);
                }
                case '2': 
                case '4': {
                    if (i2 == 0 || string2.charAt(i2 - 1) != 'Y') {
                        throw IfxErrMsg.getSQLException(-79800, "\"" + string2 + "\"", locale);
                    }
                    if (string2.charAt(i2) == '2') {
                        string3 = string3 + "yy" + string5;
                        continue block7;
                    }
                    string3 = string3 + "yyyy" + string5;
                    continue block7;
                }
                default: {
                    throw IfxErrMsg.getSQLException(-79801, "\"" + string2 + "\"", locale);
                }
            }
        }
        if (string5.equals("")) {
            string4 = dateUtil.formatDate(date, locale, string3);
            return string4;
        }
        string4 = dateUtil.formatDate(date, locale, string3.substring(0, string3.length() - 1));
        return string4;
    }

    private static String getglDateStr(Object object, String string, String string2, boolean bl) throws SQLException {
        String string3 = "";
        String string4 = "";
        boolean bl2 = false;
        String[] stringArray = new String[5];
        Locale locale = dateUtil.getLocaleValue(string);
        block35: for (int i2 = 0; i2 < string2.length(); ++i2) {
            switch (string2.charAt(i2)) {
                case '%': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        string3 = string3 + "%";
                        continue block35;
                    }
                    if (!bl2) continue block35;
                    string3 = string3 + SQUOTE;
                    bl2 = false;
                    continue block35;
                }
                case '\'': {
                    if (bl2) {
                        string3 = string3 + SQUOTE + SQUOTE + SQUOTE;
                        bl2 = false;
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + SQUOTE;
                    continue block35;
                }
                case 'a': {
                    Object object2;
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        Locale locale2 = new Locale("fr", "CH", "");
                        object2 = new Locale("tr", "TR", "");
                        if (bl && (locale.toString().equals(((Locale)object2).toString()) || locale.toString().equals(Locale.CANADA_FRENCH.toString()) || locale.toString().equals(locale2.toString()))) {
                            if (bl2) {
                                string3 = string3 + dateUtil.getInfmxglPattern(object, 'a', locale);
                                continue block35;
                            }
                            string3 = string3 + SQUOTE + dateUtil.getInfmxglPattern(object, 'a', locale);
                            bl2 = true;
                            continue block35;
                        }
                        string3 = string3 + "E";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "a";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "a";
                    bl2 = true;
                    continue block35;
                }
                case 'A': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        string3 = string3 + "EEEEE";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "A";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "A";
                    bl2 = true;
                    continue block35;
                }
                case 'b': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        Locale locale3 = new Locale("fr", "CH", "");
                        if (bl && (locale.toString().equals(Locale.JAPAN.toString()) || locale.toString().equals(Locale.CANADA_FRENCH.toString()) || locale.toString().equals(locale3.toString()))) {
                            if (bl2) {
                                string3 = string3 + dateUtil.getInfmxglPattern(object, 'b', locale);
                                continue block35;
                            }
                            string3 = string3 + SQUOTE + dateUtil.getInfmxglPattern(object, 'b', locale);
                            bl2 = true;
                            continue block35;
                        }
                        string3 = string3 + "MMM";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "b";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "b";
                    bl2 = true;
                    continue block35;
                }
                case 'B': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (bl && locale.toString().equals(Locale.JAPAN.toString())) {
                            if (bl2) {
                                string3 = string3 + dateUtil.getInfmxglPattern(object, 'B', locale);
                                continue block35;
                            }
                            string3 = string3 + SQUOTE + dateUtil.getInfmxglPattern(object, 'B', locale);
                            bl2 = true;
                            continue block35;
                        }
                        string3 = string3 + "MMMMM";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "B";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "B";
                    bl2 = true;
                    continue block35;
                }
                case 'c': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (object instanceof java.sql.Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        string3 = string3 + "yyyy-MM-dd HH:mm:ss";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "c";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "c";
                    bl2 = true;
                    continue block35;
                }
                case 'C': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        string3 = string3 + CDIRTAG + "yyyy";
                        continue block35;
                    }
                    if (i2 >= 2 && string2.charAt(i2 - 1) == 'E' && string2.charAt(i2 - 2) == '%') {
                        string3 = string3 + CDIRTAG + "yyyy" + " GGGGG ";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "C";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "C";
                    bl2 = true;
                    continue block35;
                }
                case 'd': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        string3 = string3 + "dd";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "d";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "d";
                    bl2 = true;
                    continue block35;
                }
                case 'D': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        string3 = string3 + "MM/dd/yy";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "D";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "D";
                    bl2 = true;
                    continue block35;
                }
                case 'e': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        string3 = string3 + "d";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "e";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "e";
                    bl2 = true;
                    continue block35;
                }
                case 'E': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') continue block35;
                    if (bl2) {
                        string3 = string3 + "E";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "E";
                    bl2 = true;
                    continue block35;
                }
                case 'F': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (object instanceof java.sql.Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        if (i2 + 1 > string2.length() || Character.isDigit(string2.charAt(i2 + 1))) continue block35;
                        String string5 = Integer.toString(((Timestamp)object).getNanos());
                        if (string5.length() < 2) {
                            string5 = string5.substring(0, string5.length()) + ZEROS.substring(0, 2 - string5.length());
                        } else if (string5.length() > 2) {
                            string5 = string5.substring(0, 2);
                        }
                        string3 = string3 + PERIOD + string5;
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "F";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "F";
                    bl2 = true;
                    continue block35;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': {
                    Object object2;
                    if (i2 >= 2 && string2.charAt(i2 - 1) == 'F' && string2.charAt(i2 - 2) == '%') {
                        int n = stringUtil.stringToInt(string2.substring(i2, i2 + 1));
                        object2 = Integer.toString(((Timestamp)object).getNanos());
                        if (((String)object2).length() < n) {
                            object2 = ((String)object2).substring(0, ((String)object2).length()) + ZEROS.substring(0, n - ((String)object2).length());
                        } else if (((String)object2).length() > n) {
                            object2 = ((String)object2).substring(0, n);
                        }
                        string3 = string3 + PERIOD + (String)object2;
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + string2.substring(i2, i2 + 1);
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + string2.substring(i2, i2 + 1);
                    bl2 = true;
                    continue block35;
                }
                case 'h': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        Locale locale4 = new Locale("fr", "CH", "");
                        if (bl && (locale.toString().equals(Locale.JAPAN.toString()) || locale.toString().equals(Locale.CANADA_FRENCH.toString()) || locale.toString().equals(locale4.toString()))) {
                            if (bl2) {
                                string3 = string3 + dateUtil.getInfmxglPattern(object, 'h', locale);
                                continue block35;
                            }
                            string3 = string3 + SQUOTE + dateUtil.getInfmxglPattern(object, 'h', locale);
                            bl2 = true;
                            continue block35;
                        }
                        string3 = string3 + "MMM";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "h";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "h";
                    bl2 = true;
                    continue block35;
                }
                case 'H': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (object instanceof java.sql.Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        string3 = string3 + "HH";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "H";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "H";
                    bl2 = true;
                    continue block35;
                }
                case 'i': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') continue block35;
                    if (bl2) {
                        string3 = string3 + "i";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "i";
                    bl2 = true;
                    continue block35;
                }
                case 'I': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (object instanceof java.sql.Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        string3 = string3 + "hh";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "I";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "I";
                    bl2 = true;
                    continue block35;
                }
                case 'M': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (object instanceof java.sql.Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        string3 = string3 + "mm";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "M";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "M";
                    bl2 = true;
                    continue block35;
                }
                case 'p': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (object instanceof java.sql.Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        string3 = string3 + "aa";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "p";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "p";
                    bl2 = true;
                    continue block35;
                }
                case 'r': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (object instanceof java.sql.Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        string3 = string3 + "hh:mm:ss aaaa";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "r";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "r";
                    bl2 = true;
                    continue block35;
                }
                case 'R': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (object instanceof java.sql.Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        string3 = string3 + "HH:mm";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "R";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "R";
                    bl2 = true;
                    continue block35;
                }
                case 'S': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (object instanceof java.sql.Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        string3 = string3 + "ss";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "S";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "S";
                    bl2 = true;
                    continue block35;
                }
                case 'T': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (object instanceof java.sql.Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        string3 = string3 + "HH:mm:ss";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "T";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "T";
                    bl2 = true;
                    continue block35;
                }
                case 'X': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (object instanceof java.sql.Date) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        string3 = string3 + "HH:mm:ss";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "X";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "X";
                    bl2 = true;
                    continue block35;
                }
                case 'y': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%' || i2 >= 2 && string2.charAt(i2 - 1) == 'i' && string2.charAt(i2 - 2) == '%') {
                        string3 = string3 + "yy";
                        continue block35;
                    }
                    if (i2 >= 2 && string2.charAt(i2 - 1) == 'E' && string2.charAt(i2 - 2) == '%') {
                        string3 = string3 + "yy" + " GGGGG ";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "y";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "y";
                    bl2 = true;
                    continue block35;
                }
                case 'Y': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%' || i2 >= 2 && string2.charAt(i2 - 1) == 'i' && string2.charAt(i2 - 2) == '%') {
                        string3 = string3 + "yyyy";
                        continue block35;
                    }
                    if (i2 >= 2 && string2.charAt(i2 - 1) == 'E' && string2.charAt(i2 - 2) == '%') {
                        string3 = string3 + "yyyy" + " GGGGG ";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "Y";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "Y";
                    bl2 = true;
                    continue block35;
                }
                case 'm': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        string3 = string3 + "MM";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "m";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "m";
                    bl2 = true;
                    continue block35;
                }
                case 'n': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        string3 = string3 + "\f";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "n";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "n";
                    bl2 = true;
                    continue block35;
                }
                case 't': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        string3 = string3 + "\t";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "t";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "t";
                    bl2 = true;
                    continue block35;
                }
                case 'w': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        string3 = string3 + WDIRTAG + "E";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "w";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "w";
                    bl2 = true;
                    continue block35;
                }
                case 'x': {
                    stringArray = dateUtil.getLocaleDateOrder(locale, true);
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        string3 = string3 + dateUtil.getglDateXPattern(stringArray);
                        continue block35;
                    }
                    if (i2 >= 2 && string2.charAt(i2 - 1) == 'E' && string2.charAt(i2 - 2) == '%') {
                        string3 = string3 + dateUtil.getglDateXPattern(stringArray) + " GGGGG ";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "x";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "x";
                    bl2 = true;
                    continue block35;
                }
                case 'g': {
                    if (i2 >= 2 && string2.charAt(i2 - 1) == 'E' && string2.charAt(i2 - 2) == '%') {
                        string3 = string3 + CDIRTAG + "yyyy" + " G ";
                        continue block35;
                    }
                    if (bl2) {
                        string3 = string3 + "g";
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + "g";
                    bl2 = true;
                    continue block35;
                }
                default: {
                    if (Character.isLetter(string2.charAt(i2)) && !bl2) {
                        string3 = string3 + SQUOTE + string2.substring(i2, i2 + 1);
                        bl2 = true;
                        continue block35;
                    }
                    if (Character.isLetter(string2.charAt(i2)) && bl2 || !Character.isLetter(string2.charAt(i2)) && !bl2) {
                        string3 = string3 + string2.substring(i2, i2 + 1);
                        continue block35;
                    }
                    string3 = string3 + SQUOTE + string2.substring(i2, i2 + 1);
                    bl2 = false;
                }
            }
        }
        if (bl2) {
            string3 = string3 + SQUOTE;
        }
        string4 = dateUtil.formatDate(object, locale, string3);
        return string4;
    }

    private static String getLocaleDateStr(java.sql.Date date, String string) {
        DateFormat dateFormat = null;
        String string2 = null;
        int n = 3;
        Locale locale = dateUtil.getLocaleValue(string);
        dateFormat = DateFormat.getDateInstance(n, locale);
        string2 = dateFormat.format(date);
        return string2;
    }

    private static String getLocaleDateTimeStr(Object object, String string) {
        DateFormat dateFormat = null;
        String string2 = null;
        int n = 2;
        Locale locale = dateUtil.getLocaleValue(string);
        if (object instanceof Timestamp) {
            int n2 = 2;
            dateFormat = DateFormat.getDateTimeInstance(n2, n, locale);
            string2 = dateFormat.format((Timestamp)object);
        } else {
            dateFormat = DateFormat.getTimeInstance(n, locale);
            string2 = dateFormat.format((Time)object);
        }
        return string2;
    }

    private static String formatDate(Object object, Locale locale, String string) {
        SimpleDateFormat simpleDateFormat;
        int n = 0;
        int n2 = 0;
        String string2 = null;
        if (string.indexOf(WDIRTAG) == -1) {
            simpleDateFormat = locale == null || !locale.getLanguage().equals("th") ? new SimpleDateFormat(string, locale) : new SimpleDateFormat(string, new Locale("th"));
            string2 = object instanceof java.sql.Date ? simpleDateFormat.format((java.sql.Date)object) : simpleDateFormat.format((Timestamp)object);
        } else {
            DateFormatSymbols dateFormatSymbols = null;
            dateFormatSymbols = locale == null || !locale.getLanguage().equals("th") ? new DateFormatSymbols(locale) : new DateFormatSymbols(new Locale("th"));
            String[] stringArray = dateFormatSymbols.getShortWeekdays();
            simpleDateFormat = new SimpleDateFormat(string, dateFormatSymbols);
            string2 = object instanceof java.sql.Date ? simpleDateFormat.format((java.sql.Date)object) : simpleDateFormat.format((Timestamp)object);
            int n3 = 0;
            int n4 = 0;
            while (n3 < string2.length() && (n = string2.indexOf(WDIRTAG, n3)) != -1) {
                for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
                    if (string2.indexOf(WDIRTAG + stringArray[i2 + 1], n3) == -1) continue;
                    n4 = i2;
                    break;
                }
                string2 = string2.substring(0, n) + n4 + string2.substring(n + WDIRTAG.length() + stringArray[n4 + 1].length());
                n3 = n + 1;
            }
        }
        while (n2 < string2.length() && (n = string2.indexOf(CDIRTAG, n2)) != -1) {
            string2 = string2.substring(0, n) + string2.substring(n + CDIRTAG.length(), n + CDIRTAG.length() + 2) + string2.substring(n + CDIRTAG.length() + 4);
            n2 = n + 2;
        }
        return string2;
    }

    private static String convertdbDate(String string, String string2, String string3) throws SQLException {
        String string4 = null;
        Locale locale = dateUtil.getLocaleValue(string2);
        if (!dateUtil.isValidDate(string)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + string + "\"", locale);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, HYPHEN);
        int n = stringUtil.stringToInt(stringTokenizer.nextToken());
        int n2 = stringUtil.stringToInt(stringTokenizer.nextToken()) - 1;
        int n3 = stringUtil.stringToInt(stringTokenizer.nextToken());
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, n3);
        java.sql.Date date = new java.sql.Date(gregorianCalendar.getTime().getTime());
        string4 = dateUtil.getdbDateStr(date, string2, string3);
        return string4;
    }

    private static String convertdbDateTime(String string, IfxConnection ifxConnection, String string2, boolean bl) throws SQLException {
        String string3 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        StringTokenizer stringTokenizer = null;
        String string4 = ifxConnection.getclLocale();
        GregorianCalendar gregorianCalendar = null;
        Timestamp timestamp = null;
        Locale locale = dateUtil.getLocaleValue(string4);
        boolean bl2 = true;
        if (!bl) {
            if (!dateUtil.isValidTimeStamp(string)) {
                throw IfxErrMsg.getSQLException(-79712, "\"" + string + "\"", locale);
            }
            stringTokenizer = new StringTokenizer(string, "-:. ");
            n = stringUtil.stringToInt(stringTokenizer.nextToken());
            n2 = stringUtil.stringToInt(stringTokenizer.nextToken()) - 1;
            n3 = stringUtil.stringToInt(stringTokenizer.nextToken());
            n4 = stringUtil.stringToInt(stringTokenizer.nextToken());
            n5 = stringUtil.stringToInt(stringTokenizer.nextToken());
            n6 = stringUtil.stringToInt(stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                if (stringUtil.isANum(string5) && string5.length() <= 9) {
                    if (string5.length() < 9) {
                        string5 = string5 + ZEROS.substring(0, 9 - string5.length());
                    }
                    n7 = stringUtil.stringToInt(string5);
                } else {
                    throw IfxErrMsg.getSQLException(-79786, string, locale);
                }
            }
            gregorianCalendar = new GregorianCalendar(n, n2, n3, n4, n5, n6);
            timestamp = new Timestamp(gregorianCalendar.getTime().getTime());
            if (n7 != 0) {
                timestamp.setNanos(n7);
            }
            string3 = dateUtil.getglDateStr(timestamp, string4, string2, bl2);
        } else {
            if (!dateUtil.isValidTime(string)) {
                throw IfxErrMsg.getSQLException(-79711, "\"" + string + "\"", locale);
            }
            stringTokenizer = new StringTokenizer(string, COLON);
            n4 = stringUtil.stringToInt(stringTokenizer.nextToken());
            n5 = stringUtil.stringToInt(stringTokenizer.nextToken());
            n6 = stringUtil.stringToInt(stringTokenizer.nextToken());
            GregorianCalendar gregorianCalendar2 = null;
            gregorianCalendar2 = dateUtil.getCurrentDateGC(ifxConnection);
            n = gregorianCalendar2.get(1);
            n2 = gregorianCalendar2.get(2);
            n3 = gregorianCalendar2.get(5);
            gregorianCalendar = new GregorianCalendar(n, n2, n3, n4, n5, n6);
            timestamp = new Timestamp(gregorianCalendar.getTime().getTime());
            string3 = dateUtil.getglDateStr(timestamp, string4, string2, bl2);
        }
        return string3;
    }

    private static String convertglDate(String string, String string2, String string3) throws SQLException {
        String string4 = null;
        Locale locale = dateUtil.getLocaleValue(string2);
        if (!dateUtil.isValidDate(string)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + string + "\"", locale);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, HYPHEN);
        int n = stringUtil.stringToInt(stringTokenizer.nextToken());
        int n2 = stringUtil.stringToInt(stringTokenizer.nextToken()) - 1;
        int n3 = stringUtil.stringToInt(stringTokenizer.nextToken());
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, n3);
        java.sql.Date date = new java.sql.Date(gregorianCalendar.getTime().getTime());
        boolean bl = true;
        string4 = dateUtil.getglDateStr(date, string2, string3, bl);
        return string4;
    }

    private static String convertcllDate(String string, String string2) throws SQLException {
        String string3 = null;
        Locale locale = dateUtil.getLocaleValue(string2);
        if (!dateUtil.isValidDate(string)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + string + "\"", locale);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, HYPHEN);
        int n = stringUtil.stringToInt(stringTokenizer.nextToken());
        int n2 = stringUtil.stringToInt(stringTokenizer.nextToken()) - 1;
        int n3 = stringUtil.stringToInt(stringTokenizer.nextToken());
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, n3);
        java.sql.Date date = new java.sql.Date(gregorianCalendar.getTime().getTime());
        string3 = dateUtil.getLocaleDateStr(date, string2);
        return string3;
    }

    private static String convertcllDateTime(String string, String string2, boolean bl) throws SQLException {
        String string3 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        StringTokenizer stringTokenizer = null;
        Locale locale = dateUtil.getLocaleValue(string2);
        if (!bl) {
            Object object;
            if (!dateUtil.isValidTimeStamp(string)) {
                throw IfxErrMsg.getSQLException(-79712, "\"" + string + "\"", locale);
            }
            stringTokenizer = new StringTokenizer(string, "-:. ");
            n = stringUtil.stringToInt(stringTokenizer.nextToken());
            n2 = stringUtil.stringToInt(stringTokenizer.nextToken()) - 1;
            n3 = stringUtil.stringToInt(stringTokenizer.nextToken());
            n4 = stringUtil.stringToInt(stringTokenizer.nextToken());
            n5 = stringUtil.stringToInt(stringTokenizer.nextToken());
            n6 = stringUtil.stringToInt(stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (stringUtil.isANum((String)object) && ((String)object).length() <= 9) {
                    if (((String)object).length() < 9) {
                        object = (String)object + ZEROS.substring(0, 9 - ((String)object).length());
                    }
                    n7 = stringUtil.stringToInt((String)object);
                } else {
                    throw IfxErrMsg.getSQLException(-79786, string, locale);
                }
            }
            object = new GregorianCalendar(n, n2, n3, n4, n5, n6);
            Timestamp timestamp = new Timestamp(((Calendar)object).getTime().getTime());
            if (n7 != 0) {
                timestamp.setNanos(n7);
            }
            string3 = dateUtil.getLocaleDateTimeStr(timestamp, string2);
        } else {
            if (!dateUtil.isValidTime(string)) {
                throw IfxErrMsg.getSQLException(-79711, "\"" + string + "\"", locale);
            }
            stringTokenizer = new StringTokenizer(string, COLON);
            n4 = stringUtil.stringToInt(stringTokenizer.nextToken());
            n5 = stringUtil.stringToInt(stringTokenizer.nextToken());
            n6 = stringUtil.stringToInt(stringTokenizer.nextToken());
            Time time = new Time(n4, n5, n6);
            string3 = dateUtil.getLocaleDateTimeStr(time, string2);
        }
        return string3;
    }

    private static java.sql.Date getdbDateObj(String string, IfxConnection ifxConnection) throws SQLException {
        String string2 = ifxConnection.getdbDate();
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        GregorianCalendar gregorianCalendar = null;
        gregorianCalendar = dateUtil.getCurrentDateGC(ifxConnection);
        int n4 = gregorianCalendar.get(1) / 100;
        int n5 = n4 * 100;
        int n6 = 0;
        int n7 = 1;
        StringTokenizer stringTokenizer = null;
        java.sql.Date date = null;
        boolean bl2 = false;
        if (string2.length() < 4 || string2.length() > 6) {
            throw IfxErrMsg.getSQLException(-79797, "\"" + string2 + "\"", ifxConnection);
        }
        String string5 = string2.substring(string2.length() - 1);
        if (string5.equals(SLASH) || string5.equals(HYPHEN) || string5.equals(PERIOD)) {
            string3 = string5;
            bl = true;
        } else if (string5.equals(NOSEP)) {
            string3 = "";
            bl = true;
        } else {
            if (!(string5.equals("E") || string5.equals("2") || string5.equals("4") || string5.equals("M") || string5.equals("D"))) {
                bl = true;
            }
            string3 = SLASH;
        }
        n2 = bl ? string2.length() - 1 : string2.length();
        if (!string3.equals("") && (stringTokenizer = new StringTokenizer(string, string3 + " ")).countTokens() < 3) {
            throw IfxErrMsg.getSQLException(-79802, "\"" + string + "\"", ifxConnection);
        }
        block10: for (int i2 = 0; i2 < n2; ++i2) {
            if (string3.equals("") && n >= string.length()) {
                throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
            }
            if (!string3.equals("") && !stringTokenizer.hasMoreTokens()) {
                throw IfxErrMsg.getSQLException(-79804, "\"" + string + "\"", ifxConnection);
            }
            if (!string3.equals("") && string2.charAt(i2) != 'Y') {
                string4 = stringTokenizer.nextToken();
            }
            switch (string2.charAt(i2)) {
                case 'E': {
                    if (!string3.equals("")) continue block10;
                    if (n <= string.length()) {
                        n3 = string.indexOf(32, n);
                        if (n3 != -1) {
                            n = n3 + 1;
                            continue block10;
                        }
                        throw IfxErrMsg.getSQLException(-79805, "\"" + string + "\"", ifxConnection);
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                }
                case 'D': {
                    if (!string3.equals("")) {
                        n7 = stringUtil.stringToInt(string4);
                        if (n7 != 0) continue block10;
                        throw IfxErrMsg.getSQLException(-79806, "\"" + string + "\"", ifxConnection);
                    }
                    if (n + 2 <= string.length()) {
                        n7 = stringUtil.stringToInt(string.substring(n, n + 2));
                        if (n7 == 0) {
                            throw IfxErrMsg.getSQLException(-79806, "\"" + string + "\"", ifxConnection);
                        }
                        n += 2;
                        continue block10;
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                }
                case 'M': {
                    if (!string3.equals("")) {
                        n6 = stringUtil.stringToInt(string4) - 1;
                        if (n6 != -1) continue block10;
                        throw IfxErrMsg.getSQLException(-79807, "\"" + string + "\"", ifxConnection);
                    }
                    if (n + 2 <= string.length()) {
                        n6 = stringUtil.stringToInt(string.substring(n, n + 2)) - 1;
                        if (n6 == -1) {
                            throw IfxErrMsg.getSQLException(-79807, "\"" + string + "\"", ifxConnection);
                        }
                        n += 2;
                        continue block10;
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                }
                case 'Y': {
                    if (i2 + 1 == n2) {
                        throw IfxErrMsg.getSQLException(-79798, "\"" + string2 + "\"", ifxConnection);
                    }
                    if (string2.charAt(i2 + 1) == '2' || string2.charAt(i2 + 1) == '4') continue block10;
                    throw IfxErrMsg.getSQLException(-79799, "\"" + string2 + "\"", ifxConnection);
                }
                case '2': {
                    if (i2 == 0 || string2.charAt(i2 - 1) != 'Y') {
                        throw IfxErrMsg.getSQLException(-79800, "\"" + string2 + "\"", ifxConnection);
                    }
                    if (!string3.equals("")) {
                        n5 = stringUtil.stringToInt(string4);
                        if (string4.length() >= 3) continue block10;
                        bl2 = true;
                        continue block10;
                    }
                    if (n + 2 <= string.length()) {
                        n5 = stringUtil.stringToInt(string.substring(n, n + 2));
                        bl2 = true;
                        n += 2;
                        continue block10;
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + string2 + "\"", ifxConnection);
                }
                case '4': {
                    if (i2 == 0 || string2.charAt(i2 - 1) != 'Y') {
                        throw IfxErrMsg.getSQLException(-79800, "\"" + string2 + "\"", ifxConnection);
                    }
                    if (!string3.equals("")) {
                        n5 = stringUtil.stringToInt(string4);
                        if (string4.length() >= 3) continue block10;
                        bl2 = true;
                        continue block10;
                    }
                    if (n + 4 <= string.length()) {
                        n5 = stringUtil.stringToInt(string.substring(n, n + 4));
                        n += 4;
                        continue block10;
                    }
                    throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                }
                default: {
                    throw IfxErrMsg.getSQLException(-79801, "\"" + string2 + "\"", ifxConnection);
                }
            }
        }
        if (!dateUtil.isValidDate(n5, n6 + 1, n7)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + string + "\"", ifxConnection);
        }
        try {
            if (bl2) {
                n5 += dateUtil.getCentury(ifxConnection, n5, n6 + 1, n7);
            }
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar(n5, n6, n7);
            date = new java.sql.Date(gregorianCalendar2.getTime().getTime());
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79786, exception.toString(), ifxConnection);
        }
        return date;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object getglDateObj(String string, IfxConnection ifxConnection, boolean bl, boolean bl2) throws SQLException {
        String string2 = null;
        string2 = bl ? (ifxConnection.getdbDate() != null ? ifxConnection.getdbDate() : ifxConnection.getglDate()) : (ifxConnection.getdbTime() != null ? ifxConnection.getdbTime() : ifxConnection.getglDateTime());
        String string3 = ifxConnection.getclLocale();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = 0;
        int n10 = 0;
        GregorianCalendar gregorianCalendar = null;
        gregorianCalendar = dateUtil.getCurrentDateGC(ifxConnection);
        if (bl) {
            n10 = gregorianCalendar.get(1) / 100;
            n3 = n10 * 100;
            n4 = 0;
            n5 = 1;
        } else if (!bl2) {
            n3 = -1;
            n4 = -1;
            n5 = -1;
        } else {
            n3 = gregorianCalendar.get(1);
            n4 = gregorianCalendar.get(2);
            n5 = gregorianCalendar.get(5);
        }
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        DateFormatSymbols dateFormatSymbols = null;
        String[] stringArray = new String[8];
        String[] stringArray2 = new String[13];
        String[] stringArray3 = new String[13];
        Object var28_28 = null;
        String[] stringArray4 = new String[3];
        String string11 = null;
        int n11 = 0;
        StringTokenizer stringTokenizer = null;
        StringTokenizer stringTokenizer2 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        boolean bl3 = false;
        String string15 = null;
        Locale locale = dateUtil.getLocaleValue(string3);
        dateFormatSymbols = new DateFormatSymbols(locale);
        block32: for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (n >= string.length()) {
                throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
            }
            switch (string2.charAt(i2)) {
                case '%': {
                    if (i2 == 0 || string2.charAt(i2 - 1) != '%') continue block32;
                    ++n;
                    continue block32;
                }
                case 'a': {
                    int n12;
                    int n13;
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        stringArray = dateFormatSymbols.getShortWeekdays();
                        n13 = 0;
                        for (n12 = 0; n12 < stringArray.length - 1; ++n12) {
                            string13 = stringArray[n12 + 1].toLowerCase(locale);
                            n13 = stringArray[n12 + 1].length();
                            if (n + n13 <= string.length()) {
                                Locale locale2 = new Locale("tr", "TR", "");
                                string12 = string.substring(n, n + n13).toLowerCase(locale);
                                if (string12.indexOf(string13) != -1) {
                                    Locale locale3 = new Locale("fr", "CH", "");
                                    if (locale.toString().equals(locale3.toString())) {
                                        n += 3;
                                        continue block32;
                                    }
                                    n += n13;
                                    continue block32;
                                }
                                if (!locale.toString().equals(Locale.CANADA_FRENCH.toString()) && !locale.toString().equals(locale2.toString()) || string12.indexOf(string13.substring(0, 3)) == -1) continue;
                                n += 3;
                                continue block32;
                            }
                            if (n + 3 > string.length()) continue;
                            string12 = string.substring(n, n + 3).toLowerCase(locale);
                            if (n13 < 3 || !string12.equals(string13.substring(0, 3))) continue;
                            n += 3;
                            continue block32;
                        }
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'A': {
                    int n12;
                    int n13;
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        stringArray = dateFormatSymbols.getWeekdays();
                        n13 = 0;
                        for (n12 = 0; n12 < stringArray.length - 1; ++n12) {
                            n13 = stringArray[n12 + 1].length();
                            if (n + n13 > string.length() || (string12 = string.substring(n, n + n13).toLowerCase(locale)).indexOf(string13 = stringArray[n12 + 1].toLowerCase(locale)) == -1) continue;
                            n += n13;
                            continue block32;
                        }
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'b': 
                case 'h': {
                    int n12;
                    int n13;
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        n13 = 0;
                        n12 = 0;
                        stringArray2 = dateFormatSymbols.getShortMonths();
                        for (int i3 = 0; i3 < stringArray2.length - 1; ++i3) {
                            Locale locale4;
                            string14 = stringArray2[i3].toLowerCase(locale);
                            n12 = stringArray2[i3].length();
                            if (n + n12 <= string.length()) {
                                locale4 = new Locale("fr", "CH", "");
                                string12 = string.substring(n, n + n12).toLowerCase(locale);
                                if (string12.indexOf(string14) != -1) {
                                    n4 = i3;
                                    n13 = 1;
                                    n += n12;
                                    break;
                                }
                                if (!locale.toString().equals(Locale.CANADA_FRENCH.toString()) && !locale.toString().equals(locale4.toString()) || string12.indexOf(string14.substring(0, 3)) == -1 && (!string14.equals("juin") || !string12.substring(0, 3).equals("jun")) && (!string14.equals("juil.") || !string12.substring(0, 3).equals("jul"))) continue;
                                n4 = i3;
                                n13 = 1;
                                n += 3;
                                break;
                            }
                            if (n + 3 > string.length()) continue;
                            locale4 = new Locale("fr", "CH", "");
                            string12 = string.substring(n, n + 3).toLowerCase(locale);
                            if (n12 >= 3 && string12.equals(string14.substring(0, 3))) {
                                n4 = i3;
                                n13 = 1;
                                n += 3;
                                break;
                            }
                            if (!locale.toString().equals(Locale.CANADA_FRENCH.toString()) && !locale.toString().equals(locale4.toString()) || (!string14.equals("juin") || !string12.equals("jun")) && (!string14.equals("juil.") || !string12.equals("jul"))) continue;
                            n4 = i3;
                            n13 = 1;
                            n += 3;
                            break;
                        }
                        if (n13 != 0) continue block32;
                        String[] stringArray5 = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", ""};
                        dateFormatSymbols.setShortMonths(stringArray5);
                        stringArray3 = dateFormatSymbols.getShortMonths();
                        for (int i4 = 0; i4 < stringArray3.length - 1; ++i4) {
                            n12 = stringArray3[i4].length();
                            if (n + n12 > string.length() || (string12 = string.substring(n, n + n12).toLowerCase(locale)).indexOf(stringArray3[i4]) == -1) continue;
                            n4 = i4;
                            n += n12;
                            continue block32;
                        }
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'c': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (bl) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        if (n + 19 <= string.length()) {
                            n2 = n + 19;
                        } else if (n + 18 <= string.length()) {
                            n2 = n + 18;
                        } else if (n + 17 <= string.length()) {
                            n2 = n + 17;
                        } else if (n + 16 <= string.length()) {
                            n2 = n + 16;
                        } else if (n + 15 <= string.length()) {
                            n2 = n + 15;
                        } else if (n + 14 <= string.length()) {
                            n2 = n + 14;
                        } else if (n + 13 <= string.length()) {
                            n2 = n + 13;
                        } else {
                            if (n + 12 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                            n2 = n + 12;
                        }
                        stringTokenizer2 = new StringTokenizer(string.substring(n, n2), NONALPHANUMTOKS);
                        if (stringTokenizer2.countTokens() < 6) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + string + "\"", ifxConnection);
                        }
                        n11 = 0;
                        string11 = stringTokenizer2.nextToken();
                        n3 = stringUtil.stringToInt(string11);
                        if (string11.length() < 3) {
                            bl3 = true;
                        }
                        n11 += string11.length();
                        string11 = stringTokenizer2.nextToken();
                        n4 = stringUtil.stringToInt(string11) - 1;
                        n11 += string11.length();
                        string11 = stringTokenizer2.nextToken();
                        n5 = stringUtil.stringToInt(string11);
                        n11 += string11.length();
                        string10 = stringTokenizer2.nextToken();
                        n6 = stringUtil.stringToInt(string10);
                        n11 += string10.length();
                        string9 = stringTokenizer2.nextToken();
                        n7 = stringUtil.stringToInt(string9);
                        n11 += string9.length();
                        string8 = stringTokenizer2.nextToken();
                        n8 = stringUtil.stringToInt(string8);
                        n = n + (n11 += string8.length()) + 5;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'F': {
                    int n13;
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (bl) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        if (i2 + 1 > string2.length() || Character.isDigit(string2.charAt(i2 + 1))) continue block32;
                        if (n + 3 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        if (!string.substring(n, n + 1).equals(PERIOD)) {
                            throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        }
                        if (++n + 2 <= string.length()) {
                            n2 = n + 2;
                        } else {
                            if (n + 1 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                            n2 = n + 1;
                        }
                        stringTokenizer2 = new StringTokenizer(string.substring(n, n2), NONALPHANUMTOKS);
                        if (stringTokenizer2.countTokens() < 1) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + string + "\"", ifxConnection);
                        }
                        string7 = stringTokenizer2.nextToken();
                        n13 = string7.length();
                        if (!stringUtil.isANum(string7) || n13 > 2) {
                            throw IfxErrMsg.getSQLException(-79786, string, ifxConnection);
                        }
                        string7 = string7 + ZEROS.substring(0, 9 - n13);
                        n9 = stringUtil.stringToInt(string7);
                        n += n13;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': {
                    int n12;
                    int n13;
                    if (i2 >= 2 && string2.charAt(i2 - 1) == 'F' && string2.charAt(i2 - 2) == '%') {
                        int n14;
                        n13 = Character.getNumericValue(string2.charAt(i2));
                        if (n + n13 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        if (!string.substring(n, n + 1).equals(PERIOD)) {
                            throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        }
                        ++n;
                        n12 = 0;
                        for (n14 = n13; n14 >= 1; --n14) {
                            if (n + n14 > string.length()) continue;
                            n2 = n + n14;
                            n12 = 1;
                            break;
                        }
                        if (n12 == 0) {
                            throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        }
                        stringTokenizer2 = new StringTokenizer(string.substring(n, n2), NONALPHANUMTOKS);
                        if (stringTokenizer2.countTokens() < 1) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + string + "\"", ifxConnection);
                        }
                        string7 = stringTokenizer2.nextToken();
                        n14 = string7.length();
                        if (!stringUtil.isANum(string7) || n14 > n13) {
                            throw IfxErrMsg.getSQLException(-79786, string, ifxConnection);
                        }
                        string7 = string7 + ZEROS.substring(0, 9 - n14);
                        n9 = stringUtil.stringToInt(string7);
                        n += n14;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case '0': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (i2 >= 2 && string2.charAt(i2 - 1) == 'F' && string2.charAt(i2 - 2) == '%') {
                        throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                    }
                    ++n;
                    continue block32;
                }
                case 'H': 
                case 'I': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (bl) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        if (n + 2 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        string10 = string.substring(n, n + 2);
                        n6 = stringUtil.stringToInt(string10);
                        n += 2;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'B': {
                    int n12;
                    int n13;
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        n13 = 0;
                        n12 = 0;
                        stringArray2 = dateFormatSymbols.getMonths();
                        for (int i5 = 0; i5 < stringArray2.length - 1; ++i5) {
                            n12 = stringArray2[i5].length();
                            if (n + n12 > string.length() || (string12 = string.substring(n, n + n12).toLowerCase(locale)).indexOf(string14 = stringArray2[i5].toLowerCase(locale)) == -1) continue;
                            n4 = i5;
                            n13 = 1;
                            n += n12;
                            break;
                        }
                        if (n13 != 0) continue block32;
                        String[] stringArray6 = new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", ""};
                        dateFormatSymbols.setMonths(stringArray6);
                        stringArray3 = dateFormatSymbols.getMonths();
                        for (int i6 = 0; i6 < stringArray3.length - 1; ++i6) {
                            n12 = stringArray3[i6].length();
                            if (n + n12 > string.length() || (string12 = string.substring(n, n + n12).toLowerCase(locale)).indexOf(stringArray3[i6]) == -1) continue;
                            n4 = i6;
                            n += n12;
                            continue block32;
                        }
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'C': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        n += 2;
                        continue block32;
                    }
                    if (i2 >= 2 && string2.charAt(i2 - 1) == 'E' && string2.charAt(i2 - 2) == '%') {
                        if (n + 3 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        n2 = string.indexOf(32, n + 3);
                        if (n2 == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + string + "\"", ifxConnection);
                        n = n2 + 1;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'd': {
                    int n13;
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (n + 2 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        n13 = Character.isDigit(string.charAt(n + 1)) ? 2 : 1;
                        string6 = string.substring(n, n + n13);
                        n5 = stringUtil.stringToInt(string6);
                        n += n13;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'D': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (n + 8 <= string.length()) {
                            n2 = n + 8;
                        } else if (n + 7 <= string.length()) {
                            n2 = n + 7;
                        } else {
                            if (n + 6 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                            n2 = n + 6;
                        }
                        stringTokenizer2 = new StringTokenizer(string.substring(n, n2), NONALPHANUMTOKS);
                        if (stringTokenizer2.countTokens() < 3) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + string + "\"", ifxConnection);
                        }
                        n11 = 0;
                        string11 = stringTokenizer2.nextToken();
                        n4 = stringUtil.stringToInt(string11) - 1;
                        n11 += string11.length();
                        string11 = stringTokenizer2.nextToken();
                        n5 = stringUtil.stringToInt(string11);
                        n11 += string11.length();
                        string11 = stringTokenizer2.nextToken();
                        n3 = stringUtil.stringToInt(string11);
                        if (string11.length() < 3) {
                            bl3 = true;
                        }
                        n = n + (n11 += string11.length()) + 2;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'e': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (n != 0 && string.charAt(n - 1) == ' ') {
                            if (n + 1 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                            string6 = string.substring(n, n + 1);
                            ++n;
                        } else {
                            if (n + 2 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                            string6 = string.substring(n, n + 2);
                            n += 2;
                        }
                        n5 = stringUtil.stringToInt(string6);
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'i': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') continue block32;
                    ++n;
                    continue block32;
                }
                case 'E': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') continue block32;
                    ++n;
                    continue block32;
                }
                case 'y': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%' || i2 >= 2 && string2.charAt(i2 - 1) == 'i' && string2.charAt(i2 - 2) == '%') {
                        if (n + 2 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        string4 = string.substring(n, n + 2);
                        n3 = stringUtil.stringToInt(string4);
                        bl3 = true;
                        n += 2;
                        continue block32;
                    }
                    if (i2 >= 2 && string2.charAt(i2 - 1) == 'E' && string2.charAt(i2 - 2) == '%') {
                        if (n + 3 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        string4 = string.substring(n, n + 2);
                        n3 = stringUtil.stringToInt(string4);
                        bl3 = true;
                        n2 = string.indexOf(32, n + 3);
                        if (n2 == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + string + "\"", ifxConnection);
                        n = n2 + 1;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'Y': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%' || i2 >= 2 && string2.charAt(i2 - 1) == 'i' && string2.charAt(i2 - 2) == '%') {
                        if (n + 4 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        string4 = string.substring(n, n + 4);
                        n3 = stringUtil.stringToInt(string4);
                        n += 4;
                        continue block32;
                    }
                    if (i2 >= 2 && string2.charAt(i2 - 1) == 'E' && string2.charAt(i2 - 2) == '%') {
                        if (n + 5 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        string4 = string.substring(n, n + 4);
                        n3 = stringUtil.stringToInt(string4);
                        n2 = string.indexOf(32, n + 5);
                        if (n2 == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + string + "\"", ifxConnection);
                        n = n2 + 1;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'm': {
                    int n13;
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (n + 2 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        n13 = Character.isDigit(string.charAt(n + 1)) ? 2 : 1;
                        string5 = string.substring(n, n + n13);
                        n4 = stringUtil.stringToInt(string5) - 1;
                        n += n13;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'M': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (bl) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        if (n + 2 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        string9 = string.substring(n, n + 2);
                        n7 = stringUtil.stringToInt(string9);
                        n += 2;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'p': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (bl) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        if (n + 2 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        string15 = string.substring(n, n + 2);
                        n += 2;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'r': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (bl) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        if (n + 11 <= string.length()) {
                            n2 = n + 11;
                        } else if (n + 10 <= string.length()) {
                            n2 = n + 10;
                        } else if (n + 9 <= string.length()) {
                            n2 = n + 9;
                        } else {
                            if (n + 8 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                            n2 = n + 8;
                        }
                        stringTokenizer2 = new StringTokenizer(string.substring(n, n2), NONALPHANUMTOKS);
                        if (stringTokenizer2.countTokens() < 4) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + string + "\"", ifxConnection);
                        }
                        n11 = 0;
                        string10 = stringTokenizer2.nextToken();
                        n6 = stringUtil.stringToInt(string10);
                        n11 += string10.length();
                        string9 = stringTokenizer2.nextToken();
                        n7 = stringUtil.stringToInt(string9);
                        n11 += string9.length();
                        string8 = stringTokenizer2.nextToken();
                        n8 = stringUtil.stringToInt(string8);
                        n11 += string8.length();
                        string15 = stringTokenizer2.nextToken();
                        n = n + (n11 += string15.length()) + 3;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'R': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (bl) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        if (n + 5 <= string.length()) {
                            n2 = n + 5;
                        } else if (n + 4 <= string.length()) {
                            n2 = n + 4;
                        } else {
                            if (n + 3 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                            n2 = n + 3;
                        }
                        stringTokenizer2 = new StringTokenizer(string.substring(n, n2), NONALPHANUMTOKS);
                        if (stringTokenizer2.countTokens() < 2) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + string + "\"", ifxConnection);
                        }
                        n11 = 0;
                        string10 = stringTokenizer2.nextToken();
                        n6 = stringUtil.stringToInt(string10);
                        n11 += string10.length();
                        string9 = stringTokenizer2.nextToken();
                        n7 = stringUtil.stringToInt(string9);
                        n = n + (n11 += string9.length()) + 1;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'S': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (bl) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        if (n + 2 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        string8 = string.substring(n, n + 2);
                        n8 = stringUtil.stringToInt(string8);
                        n += 2;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'T': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (bl) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        if (n + 8 <= string.length()) {
                            n2 = n + 8;
                        } else if (n + 7 <= string.length()) {
                            n2 = n + 7;
                        } else if (n + 6 <= string.length()) {
                            n2 = n + 6;
                        } else {
                            if (n + 5 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                            n2 = n + 5;
                        }
                        stringTokenizer2 = new StringTokenizer(string.substring(n, n2), NONALPHANUMTOKS);
                        if (stringTokenizer2.countTokens() < 3) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + string + "\"", ifxConnection);
                        }
                        n11 = 0;
                        string10 = stringTokenizer2.nextToken();
                        n6 = stringUtil.stringToInt(string10);
                        n11 += string10.length();
                        string9 = stringTokenizer2.nextToken();
                        n7 = stringUtil.stringToInt(string9);
                        n11 += string9.length();
                        string8 = stringTokenizer2.nextToken();
                        n8 = stringUtil.stringToInt(string8);
                        n = n + (n11 += string8.length()) + 2;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'x': {
                    int n13;
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%' || i2 >= 2 && string2.charAt(i2 - 1) == 'E' && string2.charAt(i2 - 2) == '%') {
                        stringArray4 = dateUtil.getLocaleDateOrder(locale, false);
                        if (n + 10 <= string.length()) {
                            n2 = n + 10;
                        } else if (n + 9 <= string.length()) {
                            n2 = n + 9;
                        } else if (n + 8 <= string.length()) {
                            n2 = n + 8;
                        } else if (n + 7 <= string.length()) {
                            n2 = n + 7;
                        } else {
                            if (n + 6 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                            n2 = n + 6;
                        }
                        stringTokenizer = new StringTokenizer(string.substring(n, n2), NONALPHANUMTOKS);
                        if (stringTokenizer.countTokens() < 3) {
                            throw IfxErrMsg.getSQLException(-79809, "\"" + string + "\"", ifxConnection);
                        }
                        n11 = 0;
                        for (n13 = 0; n13 < stringArray4.length; ++n13) {
                            string11 = stringTokenizer.nextToken();
                            n11 += string11.length();
                            if (stringArray4[n13].indexOf("YEAR") != -1) {
                                n3 = stringUtil.stringToInt(string11);
                                if (string11.length() >= 3) continue;
                                bl3 = true;
                                continue;
                            }
                            if (stringArray4[n13].indexOf("MONTH") != -1) {
                                n4 = stringUtil.stringToInt(string11) - 1;
                                continue;
                            }
                            n5 = stringUtil.stringToInt(string11);
                        }
                        n11 += 2;
                        if (i2 >= 2 && string2.charAt(i2 - 1) == 'E' && string2.charAt(i2 - 2) == '%') {
                            if (n + n11 + 1 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                            n2 = string.indexOf(32, n + n11 + 1);
                            if (n2 == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + string + "\"", ifxConnection);
                            n = n2 + 1;
                            continue block32;
                        }
                        n += n11;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'X': {
                    if (i2 != 0 && string2.charAt(i2 - 1) == '%') {
                        if (bl) {
                            throw IfxErrMsg.getSQLException(-79829, "\"" + string2 + "\"", locale);
                        }
                        if (n + 8 <= string.length()) {
                            n2 = n + 8;
                        } else if (n + 7 <= string.length()) {
                            n2 = n + 7;
                        } else if (n + 6 <= string.length()) {
                            n2 = n + 6;
                        } else {
                            if (n + 5 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                            n2 = n + 5;
                        }
                        stringTokenizer2 = new StringTokenizer(string.substring(n, n2), NONALPHANUMTOKS);
                        if (stringTokenizer2.countTokens() < 3) {
                            throw IfxErrMsg.getSQLException(-79808, "\"" + string + "\"", ifxConnection);
                        }
                        n11 = 0;
                        string10 = stringTokenizer2.nextToken();
                        n6 = stringUtil.stringToInt(string10);
                        n11 += string10.length();
                        string9 = stringTokenizer2.nextToken();
                        n7 = stringUtil.stringToInt(string9);
                        n11 += string9.length();
                        string8 = stringTokenizer2.nextToken();
                        n8 = stringUtil.stringToInt(string8);
                        n = n + (n11 += string8.length()) + 2;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                case 'g': {
                    if (i2 >= 2 && string2.charAt(i2 - 1) == 'E' && string2.charAt(i2 - 2) == '%') {
                        if (n + 3 > string.length()) throw IfxErrMsg.getSQLException(-79803, "\"" + string + "\"", ifxConnection);
                        n2 = string.indexOf(32, n + 3);
                        if (n2 == -1) throw IfxErrMsg.getSQLException(-79805, "\"" + string + "\"", ifxConnection);
                        n = n2 + 1;
                        continue block32;
                    }
                    ++n;
                    continue block32;
                }
                default: {
                    ++n;
                }
            }
        }
        if (n < string.length()) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + string + "\"", ifxConnection);
        }
        if (!dateUtil.isValidDate(n3, n4 + 1, n5)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + string + "\"", ifxConnection);
        }
        try {
            void var28_31;
            if (!(bl || bl2 || n3 != -1 && n4 != -1 && n5 != -1 && n6 != -1 && n7 != -1 && n8 != -1)) {
                throw IfxErrMsg.getSQLException(-79830, "\"" + string + "\"", ifxConnection);
            }
            if (!bl && bl2 && (n6 == -1 || n7 == -1 || n8 == -1)) {
                throw IfxErrMsg.getSQLException(-79830, "\"" + string + "\"", ifxConnection);
            }
            if (bl3) {
                n3 += dateUtil.getCentury(ifxConnection, n3, n4 + 1, n5);
            }
            if (bl) {
                java.sql.Date date;
                GregorianCalendar gregorianCalendar2 = new GregorianCalendar(n3, n4, n5);
                java.sql.Date date2 = date = new java.sql.Date(gregorianCalendar2.getTime().getTime());
                return var28_31;
            } else {
                if (string15 != null) {
                    if (string15.toUpperCase().equals(AM)) {
                        if (n6 > 11) {
                            n6 -= 12;
                        }
                    } else if (string15.toUpperCase().equals(PM) && n6 > 0 && n6 < 12) {
                        n6 += 12;
                    }
                }
                GregorianCalendar gregorianCalendar3 = new GregorianCalendar(n3, n4, n5, n6, n7, n8);
                Timestamp timestamp = new Timestamp(gregorianCalendar3.getTime().getTime());
                if (n9 != 0) {
                    timestamp.setNanos(n9);
                }
                Timestamp timestamp2 = timestamp;
            }
            return var28_31;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79786, exception.toString(), ifxConnection);
        }
    }

    private static java.sql.Date getLocaleDateObj(String string, IfxConnection ifxConnection) throws SQLException {
        String string2 = ifxConnection.getclLocale();
        GregorianCalendar gregorianCalendar = null;
        gregorianCalendar = dateUtil.getCurrentDateGC(ifxConnection);
        int n = gregorianCalendar.get(1) / 100;
        int n2 = n * 100;
        int n3 = 0;
        int n4 = 1;
        java.sql.Date date = null;
        String string3 = null;
        boolean bl = false;
        Locale locale = dateUtil.getLocaleValue(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/-.");
        if (stringTokenizer.countTokens() != 3) {
            throw IfxErrMsg.getSQLException(-79802, "\"" + string + "\"", ifxConnection);
        }
        String[] stringArray = dateUtil.getLocaleDateOrder(locale, false);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            string3 = stringTokenizer.nextToken();
            if (stringArray[i2].indexOf("YEAR") != -1) {
                n2 = stringUtil.stringToInt(string3);
                if (string3.length() >= 3) continue;
                bl = true;
                continue;
            }
            if (stringArray[i2].indexOf("MONTH") != -1) {
                n3 = stringUtil.stringToInt(string3) - 1;
                continue;
            }
            n4 = stringUtil.stringToInt(string3);
        }
        if (!dateUtil.isValidDate(n2, n3 + 1, n4)) {
            throw IfxErrMsg.getSQLException(-79709, "\"" + string + "\"", ifxConnection);
        }
        try {
            if (bl) {
                n2 += dateUtil.getCentury(ifxConnection, n2, n3 + 1, n4);
            }
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar(n2, n3, n4);
            date = new java.sql.Date(gregorianCalendar2.getTime().getTime());
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79786, exception.toString(), ifxConnection);
        }
        return date;
    }

    private static Object getLocaleDateTimeObj(String string, IfxConnection ifxConnection, boolean bl) throws SQLException {
        Date date = null;
        boolean bl2 = false;
        StringTokenizer stringTokenizer = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        try {
            if (!bl) {
                Object object;
                stringTokenizer = new StringTokenizer(string, "-:. ");
                String string2 = stringTokenizer.nextToken();
                n = stringUtil.stringToInt(string2);
                if (string2.length() < 3) {
                    bl2 = true;
                }
                n2 = stringUtil.stringToInt(stringTokenizer.nextToken()) - 1;
                n3 = stringUtil.stringToInt(stringTokenizer.nextToken());
                n4 = stringUtil.stringToInt(stringTokenizer.nextToken());
                n5 = stringUtil.stringToInt(stringTokenizer.nextToken());
                n6 = stringUtil.stringToInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    if (stringUtil.isANum((String)object) && ((String)object).length() <= 9) {
                        if (((String)object).length() < 9) {
                            object = (String)object + ZEROS.substring(0, 9 - ((String)object).length());
                        }
                        n7 = stringUtil.stringToInt((String)object);
                    } else {
                        throw IfxErrMsg.getSQLException(-79786, string, ifxConnection);
                    }
                }
                if (bl2) {
                    n += dateUtil.getCentury(ifxConnection, n, n2 + 1, n3);
                }
                object = new GregorianCalendar(n, n2, n3, n4, n5, n6);
                Timestamp timestamp = new Timestamp(((Calendar)object).getTime().getTime());
                if (n7 != 0) {
                    timestamp.setNanos(n7);
                }
                date = timestamp;
            } else {
                Time time;
                stringTokenizer = new StringTokenizer(string, COLON);
                n4 = stringUtil.stringToInt(stringTokenizer.nextToken());
                n5 = stringUtil.stringToInt(stringTokenizer.nextToken());
                n6 = stringUtil.stringToInt(stringTokenizer.nextToken());
                date = time = new Time(n4, n5, n6);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79786, exception.toString(), ifxConnection);
        }
        return date;
    }

    private static String[] getLocaleDateOrder(Locale locale, boolean bl) {
        String string = null;
        String[] stringArray = !bl ? new String[3] : new String[5];
        GregorianCalendar gregorianCalendar = new GregorianCalendar(1964, 1, 7);
        java.sql.Date date = new java.sql.Date(gregorianCalendar.getTime().getTime());
        int n = 3;
        DateFormat dateFormat = DateFormat.getDateInstance(n, locale);
        String string2 = dateFormat.format(date);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/-.", bl);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            string = stringTokenizer.nextToken();
            if (string.indexOf("64") != -1) {
                if (string.length() > 2) {
                    stringArray[i2] = "YEAR4";
                    continue;
                }
                stringArray[i2] = "YEAR2";
                continue;
            }
            stringArray[i2] = string.equals("02") ? "MONTH2" : (string.equals("2") ? "MONTH1" : (string.equals("07") ? "DAY2" : (string.equals("7") ? "DAY1" : (string.equals(SLASH) ? SLASH : (string.equals(HYPHEN) ? HYPHEN : PERIOD)))));
        }
        return stringArray;
    }

    public static Locale getLocaleValue(String string) {
        Locale locale = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, UNDERSCORE);
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            locale = new Locale(string2, string3);
        } else {
            locale = new Locale(Locale.getDefault().getLanguage(), Locale.getDefault().getCountry());
        }
        return locale;
    }

    public static String convertNativeSQLDate(String string, IfxConnection ifxConnection) throws SQLException {
        String string2 = null;
        String string3 = "";
        if (ifxConnection.getdbDate() != null) {
            string3 = ifxConnection.getdbDate();
            string2 = dateUtil.convertdbDate(string, ifxConnection.getclLocale(), string3);
        } else if (ifxConnection.getglDate() != null) {
            string3 = ifxConnection.getglDate();
            string2 = dateUtil.convertglDate(string, ifxConnection.getclLocale(), string3);
        } else {
            string2 = dateUtil.convertcllDate(string, ifxConnection.getclLocale());
        }
        if (string2 == null) {
            throw IfxErrMsg.getSQLException(-79785, "\"" + string3 + "\"", ifxConnection);
        }
        return string2;
    }

    public static String convertNativeSQLDateTime(String string, IfxConnection ifxConnection, boolean bl) throws SQLException {
        String string2 = null;
        String string3 = "";
        if (!ifxConnection.getuseDtenv() || ifxConnection.getuseDtenv() && ifxConnection.getdbTime() == null && ifxConnection.getglDateTime() == null && !ifxConnection.getclLocaleProp() && !ifxConnection.getdbLocaleProp()) {
            if (!bl) {
                if (!dateUtil.isValidTimeStamp(string)) {
                    throw IfxErrMsg.getSQLException(-79712, "\"" + string + "\"", ifxConnection);
                }
                string2 = dateUtil.IfxTimeStamp(string);
            } else {
                if (!dateUtil.isValidTime(string)) {
                    throw IfxErrMsg.getSQLException(-79711, "\"" + string + "\"", ifxConnection);
                }
                string2 = string;
            }
        } else if (ifxConnection.getdbTime() != null) {
            string3 = ifxConnection.getdbTime();
            string2 = dateUtil.convertdbDateTime(string, ifxConnection, string3, bl);
        } else if (ifxConnection.getglDateTime() != null) {
            string3 = ifxConnection.getglDateTime();
            string2 = dateUtil.convertdbDateTime(string, ifxConnection, string3, bl);
        } else {
            string2 = dateUtil.convertcllDateTime(string, ifxConnection.getclLocale(), bl);
        }
        if (string2 == null) {
            throw IfxErrMsg.getSQLException(-79785, "\"" + string3 + "\"", ifxConnection);
        }
        return string2;
    }

    public static String convertDateStr(java.sql.Date date, IfxConnection ifxConnection) throws SQLException {
        String string = null;
        if (ifxConnection.getdbDate() != null) {
            string = dateUtil.getdbDateStr(date, ifxConnection.getclLocale(), ifxConnection.getdbDate());
        } else if (ifxConnection.getglDate() != null) {
            boolean bl = false;
            string = dateUtil.getglDateStr(date, ifxConnection.getclLocale(), ifxConnection.getglDate(), bl);
        } else {
            string = dateUtil.getLocaleDateStr(date, ifxConnection.getclLocale());
        }
        return string;
    }

    public static String convertDateTimeStr(Object object, IfxConnection ifxConnection, long l) throws SQLException {
        String string = null;
        boolean bl = false;
        if (object == null || !ifxConnection.getuseDtenv() || ifxConnection.getuseDtenv() && ifxConnection.getdbTime() == null && ifxConnection.getglDateTime() == null && !ifxConnection.getclLocaleProp() && !ifxConnection.getdbLocaleProp()) {
            string = object instanceof Timestamp ? dateUtil.IfxTimeStamp(object.toString()) : object.toString();
        } else if (ifxConnection.getdbTime() != null) {
            if (object instanceof Time) {
                Timestamp timestamp = new Timestamp(l);
                string = dateUtil.getglDateStr(timestamp, ifxConnection.getclLocale(), ifxConnection.getdbTime(), bl);
            } else {
                string = dateUtil.getglDateStr(object, ifxConnection.getclLocale(), ifxConnection.getdbTime(), bl);
            }
        } else if (ifxConnection.getglDateTime() != null) {
            if (object instanceof Time) {
                Timestamp timestamp = new Timestamp(l);
                string = dateUtil.getglDateStr(timestamp, ifxConnection.getclLocale(), ifxConnection.getglDateTime(), bl);
            } else {
                string = dateUtil.getglDateStr(object, ifxConnection.getclLocale(), ifxConnection.getglDateTime(), bl);
            }
        } else {
            string = dateUtil.getLocaleDateTimeStr(object, ifxConnection.getclLocale());
        }
        return string;
    }

    public static java.sql.Date convertDateObj(String string, IfxConnection ifxConnection) throws SQLException {
        Object object = null;
        boolean bl = true;
        boolean bl2 = false;
        object = ifxConnection.getdbDate() != null ? dateUtil.getdbDateObj(string, ifxConnection) : (ifxConnection.getglDate() != null ? dateUtil.getglDateObj(string, ifxConnection, bl, bl2) : dateUtil.getLocaleDateObj(string, ifxConnection));
        return object;
    }

    public static Object convertDateTimeObj(String string, IfxConnection ifxConnection, boolean bl) throws SQLException {
        Object object = null;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        StringTokenizer stringTokenizer = null;
        try {
            if (string != null) {
                if (!ifxConnection.getuseDtenv() || ifxConnection.getuseDtenv() && ifxConnection.getdbTime() == null && ifxConnection.getglDateTime() == null && !ifxConnection.getclLocaleProp() && !ifxConnection.getdbLocaleProp()) {
                    if (!bl) {
                        Object object2;
                        stringTokenizer = new StringTokenizer(string, "-:. ");
                        String string2 = stringTokenizer.nextToken();
                        n = stringUtil.stringToInt(string2);
                        if (string2.length() < 3) {
                            bl3 = true;
                        }
                        n2 = stringUtil.stringToInt(stringTokenizer.nextToken()) - 1;
                        n3 = stringUtil.stringToInt(stringTokenizer.nextToken());
                        n4 = stringUtil.stringToInt(stringTokenizer.nextToken());
                        n5 = stringUtil.stringToInt(stringTokenizer.nextToken());
                        n6 = stringUtil.stringToInt(stringTokenizer.nextToken());
                        if (stringTokenizer.hasMoreTokens()) {
                            object2 = stringTokenizer.nextToken();
                            if (stringUtil.isANum((String)object2) && ((String)object2).length() <= 9) {
                                if (((String)object2).length() < 9) {
                                    object2 = (String)object2 + ZEROS.substring(0, 9 - ((String)object2).length());
                                }
                                n7 = stringUtil.stringToInt((String)object2);
                            } else {
                                throw IfxErrMsg.getSQLException(-79786, string, ifxConnection);
                            }
                        }
                        if (bl3) {
                            n += dateUtil.getCentury(ifxConnection, n, n2 + 1, n3);
                        }
                        object2 = new GregorianCalendar(n, n2, n3, n4, n5, n6);
                        Timestamp timestamp = new Timestamp(((Calendar)object2).getTime().getTime());
                        if (n7 != 0) {
                            timestamp.setNanos(n7);
                        }
                        object = timestamp;
                    } else {
                        stringTokenizer = new StringTokenizer(string, COLON);
                        n4 = stringUtil.stringToInt(stringTokenizer.nextToken());
                        n5 = stringUtil.stringToInt(stringTokenizer.nextToken());
                        n6 = stringUtil.stringToInt(stringTokenizer.nextToken());
                        Time time = new Time(n4, n5, n6);
                        object = time;
                    }
                } else {
                    object = ifxConnection.getdbTime() != null || ifxConnection.getglDateTime() != null ? dateUtil.getglDateObj(string, ifxConnection, bl2, bl) : dateUtil.getLocaleDateTimeObj(string, ifxConnection, bl);
                }
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79786, exception.toString(), ifxConnection);
        }
        return object;
    }

    private static String getglDateXPattern(String[] stringArray) {
        String string = "";
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            string = stringArray[i2].equals("YEAR4") ? string + "yyyy" : (stringArray[i2].equals("YEAR2") ? string + "yy" : (stringArray[i2].equals("MONTH1") ? string + "M" : (stringArray[i2].equals("MONTH2") ? string + "MM" : (stringArray[i2].equals("DAY1") ? string + "d" : (stringArray[i2].equals("DAY2") ? string + "dd" : (stringArray[i2].equals(SLASH) ? string + SLASH : (stringArray[i2].equals(HYPHEN) ? string + HYPHEN : string + PERIOD)))))));
        }
        return string;
    }

    private static String getInfmxglPattern(Object object, char c2, Locale locale) {
        String string = "";
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        String[] stringArray = new String[8];
        String[] stringArray2 = new String[8];
        String[] stringArray3 = new String[13];
        String[] stringArray4 = new String[13];
        String string2 = null;
        block0 : switch (c2) {
            case 'b': 
            case 'h': {
                String[] stringArray5;
                string2 = dateUtil.formatDate(object, locale, "MMM");
                stringArray3 = dateFormatSymbols.getShortMonths();
                if (locale.toString().equals(Locale.JAPAN.toString())) {
                    stringArray5 = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", ""};
                    System.arraycopy(stringArray5, 0, stringArray4, 0, 13);
                } else {
                    stringArray5 = new String[]{"Jan", "F\u00e9v", "Mar", "Avr", "Mai", "Jun", "Jul", "Ao\u00fb", "Sep", "Oct", "Nov", "D\u00e9c", ""};
                    System.arraycopy(stringArray5, 0, stringArray4, 0, 13);
                }
                for (int i2 = 0; i2 < stringArray3.length - 1; ++i2) {
                    if (!string2.equals(stringArray3[i2])) continue;
                    string = stringArray4[i2];
                    break block0;
                }
                break;
            }
            case 'B': {
                string2 = dateUtil.formatDate(object, locale, "MMMMM");
                stringArray3 = dateFormatSymbols.getMonths();
                String[] stringArray6 = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", ""};
                System.arraycopy(stringArray6, 0, stringArray4, 0, 13);
                for (int i3 = 0; i3 < stringArray3.length - 1; ++i3) {
                    if (!string2.equals(stringArray3[i3])) continue;
                    string = stringArray4[i3];
                    break block0;
                }
                break;
            }
            case 'a': {
                String[] stringArray7;
                string2 = dateUtil.formatDate(object, locale, "E");
                stringArray = dateFormatSymbols.getShortWeekdays();
                Locale locale2 = new Locale("tr", "TR", "");
                if (locale.toString().equals(locale2.toString())) {
                    stringArray7 = new String[]{"", "Pzr", "Pzt", "Sal", "\u00e7ar", "Per", "Cum", "Cts"};
                    System.arraycopy(stringArray7, 0, stringArray2, 0, 8);
                } else {
                    stringArray7 = new String[]{"", "Dim", "Lun", "Mar", "Mer", "Jeu", "Ven", "Sam"};
                    System.arraycopy(stringArray7, 0, stringArray2, 0, 8);
                }
                for (int i4 = 0; i4 < stringArray.length - 1; ++i4) {
                    if (!string2.equals(stringArray[i4 + 1])) continue;
                    string = stringArray2[i4 + 1];
                    break block0;
                }
                break;
            }
        }
        return string;
    }

    private static int getCentury(IfxConnection ifxConnection, int n, int n2, int n3) throws SQLException {
        if (ifxConnection == null) {
            throw IfxErrMsg.getSQLException(-79716, "getCentury: conn is null.", (Locale)null);
        }
        Trace trace = ifxConnection.getTrace();
        if (n > 99) {
            return 0;
        }
        GregorianCalendar gregorianCalendar = null;
        int n4 = 0;
        int n5 = 0;
        gregorianCalendar = dateUtil.getCurrentDateGC(ifxConnection);
        n4 = gregorianCalendar.get(1) / 100;
        if (ifxConnection.getdbCentury() == null || ifxConnection.getdbCentury().equalsIgnoreCase("R")) {
            n5 = n4;
        } else {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            GregorianCalendar gregorianCalendar2 = null;
            l = gregorianCalendar.getTime().getTime();
            int n6 = gregorianCalendar.get(2);
            int n7 = gregorianCalendar.get(5);
            int n8 = n2;
            int n9 = n3;
            int n10 = n4 * 100 + n;
            if (n8 == 29 && n9 == 2 && dateUtil.isLeapYear(n10)) {
                n8 = 3;
                n9 = 1;
            }
            gregorianCalendar2 = new GregorianCalendar(n10, n8 - 1, n9);
            l2 = gregorianCalendar2.getTime().getTime();
            n8 = n2;
            n9 = n3;
            n10 = (n4 - 1) * 100 + n;
            if (n8 == 29 && n9 == 2 && dateUtil.isLeapYear(n10)) {
                n8 = 3;
                n9 = 1;
            }
            gregorianCalendar2 = new GregorianCalendar(n10, n8 - 1, n9);
            l4 = gregorianCalendar2.getTime().getTime();
            n8 = n2;
            n9 = n3;
            n10 = (n4 + 1) * 100 + n;
            if (n8 == 29 && n9 == 2 && dateUtil.isLeapYear(n10)) {
                n8 = 3;
                n9 = 1;
            }
            gregorianCalendar2 = new GregorianCalendar(n10, n8 - 1, n9);
            l3 = gregorianCalendar2.getTime().getTime();
            long l5 = 0L;
            long l6 = 0L;
            long l7 = 0L;
            char c2 = ifxConnection.getdbCentury().toUpperCase().charAt(0);
            switch (c2) {
                case 'C': {
                    l5 = Math.abs(l2 - l);
                    l6 = Math.abs(l4 - l);
                    l7 = Math.abs(l3 - l);
                    if (l5 < l6) {
                        if (l5 < l7) {
                            n5 = n4;
                            break;
                        }
                        n5 = n4 + 1;
                        break;
                    }
                    if (l6 < l7) {
                        n5 = n4 - 1;
                        break;
                    }
                    n5 = n4 + 1;
                    break;
                }
                case 'P': {
                    l5 = l2 - l;
                    l6 = l4 - l;
                    if (l5 < 0L) {
                        n5 = n4;
                        break;
                    }
                    n5 = n4 - 1;
                    break;
                }
                case 'F': {
                    l5 = l2 - l;
                    l7 = l3 - l;
                    if (l5 > 0L) {
                        n5 = n4;
                        break;
                    }
                    n5 = n4 + 1;
                    break;
                }
                default: {
                    n5 = n4;
                }
            }
        }
        return n5 * 100;
    }

    public static GregorianCalendar getCurrentDateGC(IfxConnection ifxConnection) throws SQLException {
        if (ifxConnection == null) {
            throw IfxErrMsg.getSQLException(-79716, "getCurrentDateGC: conn is null.", (Locale)null);
        }
        Trace trace = ifxConnection.getTrace();
        Locale locale = dateUtil.getLocaleValue(ifxConnection.getclLocale());
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        long l = ifxConnection.getdbTodayStart();
        long l2 = ifxConnection.getdbTodayDate();
        if (l2 != -1L && l != -1L) {
            long l3 = gregorianCalendar.getTime().getTime();
            long l4 = l3 - l;
            long l5 = l2 + l4;
            Date date = new Date(l5);
            gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
        }
        return gregorianCalendar;
    }

    public static boolean isValidDate(int n, int n2, int n3) {
        if (n2 < 1 || n2 > 12) {
            return false;
        }
        switch (n2) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                if (n3 >= 1 && n3 <= 31) break;
                return false;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                if (n3 >= 1 && n3 <= 30) break;
                return false;
            }
            case 2: {
                int n4 = 28;
                if (n % 4 == 0 && n % 100 != 0 || n % 400 == 0) {
                    n4 = 29;
                }
                if (n3 >= 1 && n3 <= n4) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

