/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbcx.IfxConnectionEventListener;
import com.informix.jdbcx.IfxConnectionPoolDataSource;
import com.informix.jdbcx.IfxPooledConnection;
import com.informix.jdbcx.IfxSqliConnReUsableConnection;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.naming.InitialContext;

public class IfxConnectionPoolManager {
    private IfxConnectionPoolDataSource cpds;
    private IfxConnectionEventListener connectionListener = null;
    private String ClientLocale;
    private Trace cpmTrace = null;
    private String cpdsName = null;
    private Pool pool;
    private Pool prim_pool = new Pool(this);
    private Pool sec_pool = new Pool(this);
    private PoolServiceThread poolService = null;
    private long serviceInterval = 100L;
    private long ageLimit = -1L;
    private long minAgeLimit = -1L;
    private int initialPoolSize = 0;
    private int maxConnections = -1;
    private int maxPoolSize = 50;
    private int minPoolSize = 0;
    private String DSuser;
    private String DSpassword;
    private boolean isDirectConnect = false;

    public IfxConnectionPoolManager(String string) throws SQLException {
        this.cpdsName = string;
        InitialContext initialContext = null;
        this.cpds = null;
        this.prim_pool.isPrimaryPool = true;
        this.sec_pool.isPrimaryPool = false;
        this.pool = this.prim_pool;
        try {
            initialContext = new InitialContext();
            this.cpds = (IfxConnectionPoolDataSource)initialContext.lookup(this.cpdsName);
            this.ClientLocale = this.cpds.getIfxCLIENT_LOCALE();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getLocSQLException((int)-79716, (String)exception.toString(), (String)this.ClientLocale);
        }
        this.getNcheckProperties();
        this.connectionListener = new IfxConnectionEventListener();
        this.connectionListener.setParent(this);
        Method method = null;
        this.isDirectConnect = this.cpds.checkIsDirect();
        if (this.isDirectConnect) {
            // empty if block
        }
        try {
            Class<?> clazz = Class.forName("java.lang.Runtime");
            Class[] classArray = new Class[]{Class.forName("java.lang.Thread")};
            method = clazz.getMethod("addShutdownHook", classArray);
            Object[] objectArray = new Object[]{new PoolShutdownThread(this)};
            method.invoke((Object)Runtime.getRuntime(), objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (this.cpmTrace != null) {
                this.cpmTrace.writeTrace(1, "IfxConnectionPoolManager: NO shutdownThread() registered");
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getLocSQLException((int)-79716, (String)exception.toString(), (String)this.ClientLocale);
        }
        if (this.minPoolSize > 0 || this.ageLimit > 0L) {
            this.poolService = new PoolServiceThread(this, this.ageLimit);
        }
    }

    private void getNcheckProperties() throws SQLException {
        this.DSuser = this.cpds.getUser();
        this.DSpassword = this.cpds.getPassword();
        this.maxConnections = this.cpds.getIfxCPMMaxConnections();
        this.initialPoolSize = this.cpds.getIfxCPMInitPoolSize();
        this.maxPoolSize = this.cpds.getIfxCPMMaxPoolSize();
        this.minPoolSize = this.cpds.getIfxCPMMinPoolSize();
        this.minAgeLimit = this.cpds.getIfxCPMMinAgeLimit();
        this.ageLimit = this.cpds.getIfxCPMAgeLimit();
        this.serviceInterval = this.cpds.getIfxCPMServiceInterval();
        if (this.ageLimit > 0L) {
            this.ageLimit *= 1000L;
        }
        if (this.minAgeLimit > 0L) {
            this.minAgeLimit *= 1000L;
        }
        if (this.maxConnections < -1 || this.maxPoolSize < -1 || this.minPoolSize < 0 || this.initialPoolSize < 0 || this.ageLimit < -1L || this.minAgeLimit < -1L || this.serviceInterval < 0L || this.maxPoolSize != -1 && this.maxPoolSize < this.minPoolSize || this.maxConnections != -1 && this.maxConnections < this.initialPoolSize) {
            throw IfxErrMsg.getLocSQLException((int)-79841, (String)this.ClientLocale);
        }
    }

    private Trace getCPMTrace() {
        try {
            String string = this.cpds.getIfxTRACEFILE();
            int n = this.cpds.getIfxTRACE();
            if (string != null && n > 0) {
                return new Trace(n, string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Connection getConnection() throws SQLException {
        if (this.DSuser == null || this.DSpassword == null) {
            throw IfxErrMsg.getLocSQLException((int)-79811, (String)this.ClientLocale);
        }
        return this.getConnection(this.DSuser, this.DSpassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String string, String string2) throws SQLException {
        Object object;
        IfxPooledConnection ifxPooledConnection;
        block30: {
            boolean bl;
            block29: {
                ifxPooledConnection = this.pool.remove(string, string2);
                bl = false;
                boolean bl2 = false;
                object = this.cpds;
                synchronized (object) {
                    if (this.cpds.getIfxCPMSwitchHDRPool()) {
                        try {
                            bl2 = this.isPrimaryServerRunning(string, string2);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                }
                if (ifxPooledConnection == null || bl2) {
                    try {
                        ifxPooledConnection = (IfxPooledConnection)this.cpds.getPooledConnection(string, string2, this.connectionListener);
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getErrorCode() == -79831) {
                            try {
                                Thread.currentThread();
                                Thread.sleep(this.serviceInterval * 20L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ifxPooledConnection = this.pool.remove(string, string2);
                        }
                        if (sQLException.getErrorCode() != -27002 && sQLException.getErrorCode() != -908 && sQLException.getErrorCode() != -79716 && ifxPooledConnection != null) break block29;
                        bl = true;
                    }
                }
            }
            if (bl) {
                try {
                    ifxPooledConnection = (IfxPooledConnection)this.cpds.getPooledConnection(string, string2, this.connectionListener);
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == -79831) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(this.serviceInterval * 20L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ifxPooledConnection = this.pool.remove(string, string2);
                    }
                    if (ifxPooledConnection != null) break block30;
                    throw sQLException;
                }
            }
        }
        if (this.poolService != null) {
            this.notifyPoolService();
        }
        object = ifxPooledConnection.getConnection();
        if (this.cpds.getIfxENABLE_HDRSWITCH()) {
            try {
                boolean bl = this.checkConnection((Connection)object);
                if (bl) {
                    this.pool = this.sec_pool;
                    if (this.cpds.getIfxCPMSwitchHDRPool()) {
                        IfxConnectionPoolDataSource.isPrimaryUp = false;
                    }
                } else {
                    this.pool = this.prim_pool;
                    if (this.cpds.getIfxCPMSwitchHDRPool()) {
                        IfxConnectionPoolDataSource.isPrimaryUp = true;
                    }
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == -79716 || sQLException.getErrorCode() == -27002) {
                    if (this.pool.isPrimaryPool) {
                        this.pool.remove(string, string2);
                        this.pool = this.sec_pool;
                        object = this.getConnection(string, string2);
                    } else {
                        this.pool.remove(string, string2);
                        this.pool = this.prim_pool;
                        object = this.getConnection(string, string2);
                    }
                }
                throw sQLException;
            }
        }
        return object;
    }

    private boolean isPrimaryServerRunning(String string, String string2) throws SQLException {
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (IfxConnectionPoolDataSource.isPrimaryUp) {
            return true;
        }
        Properties properties = this.cpds.DSProperties;
        boolean bl = this.cpds.getIfxENABLE_HDRSWITCH();
        string5 = properties.getProperty("IFXHOST");
        string6 = properties.getProperty("PORTNO");
        if (string5 != null && string6 != null) {
            string3 = string5 + ":" + string6;
        }
        if ((string4 = properties.getProperty("DATABASE")) != null) {
            IfxSqliConnect ifxSqliConnect = null;
            properties.remove("DATABASE");
            properties.remove("ENABLE_HDRSWITCH");
            try {
                ifxSqliConnect = new IfxSqliConnect(string, string2, string3, properties);
                IfxConnectionPoolDataSource.isPrimaryUp = true;
            }
            catch (SQLException sQLException) {
                IfxConnectionPoolDataSource.isPrimaryUp = false;
                ifxSqliConnect = null;
            }
            catch (Exception exception) {
                IfxConnectionPoolDataSource.isPrimaryUp = false;
                ifxSqliConnect = null;
            }
            properties.setProperty("DATABASE", string4);
            properties.setProperty("ENABLE_HDRSWITCH", new Boolean(bl).toString());
            if (ifxSqliConnect != null) {
                ifxSqliConnect.close();
            }
        } else {
            throw IfxErrMsg.getLocSQLException((int)-79716, (String)"Missing DATABASE Property", (String)this.cpds.getIfxCLIENT_LOCALE());
        }
        return IfxConnectionPoolDataSource.isPrimaryUp;
    }

    private boolean checkConnection(Connection connection) throws SQLException {
        String string = null;
        Statement statement = connection.createStatement();
        String string2 = "select type from sysmaster:sysdri";
        ResultSet resultSet = statement.executeQuery(string2);
        if (resultSet.next()) {
            string = resultSet.getString(1);
        }
        resultSet.close();
        statement.close();
        return string != null && string.trim().equalsIgnoreCase("Secondary");
    }

    void recycleConnection(IfxPooledConnection ifxPooledConnection, int n) {
        if (n > 0 || this.pool.add(ifxPooledConnection)) {
            try {
                ifxPooledConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.poolService != null) {
            this.notifyPoolService();
        }
    }

    void startPoolService() throws SQLException {
        if (this.initialPoolSize > 0) {
            this.pool.fillThePool(this.initialPoolSize, 0L);
        }
        if (this.poolService != null) {
            this.poolService.start();
        }
    }

    void switchActivePool(String string) throws SQLException {
        System.out.println("Called switchActivePool");
        if (string.compareTo("PRIMARY") == 0) {
            this.pool = this.prim_pool;
        }
        if (string.compareTo("SECONDARY") == 0) {
            this.pool = this.sec_pool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPoolService() {
        if (this.pool.roughCount() < this.minPoolSize) {
            if (this.poolService.isAlive()) {
                if (!this.pool.fillingInProgress) {
                    this.poolService.interrupt();
                }
            } else {
                IfxConnectionPoolManager ifxConnectionPoolManager = this;
                synchronized (ifxConnectionPoolManager) {
                    if (!this.poolService.isAlive()) {
                        this.poolService = new PoolServiceThread(this, this.ageLimit);
                        this.poolService.start();
                        this.pool.fillingInProgress = false;
                    }
                    this.poolService.interrupt();
                }
            }
        }
    }

    protected int getFreeCount() {
        return this.pool.roughCount();
    }

    protected IfxConnectionPoolDataSource getCPDS() {
        return this.cpds;
    }

    private class PoolShutdownThread
    extends Thread {
        private IfxConnectionPoolManager cpm;

        PoolShutdownThread(IfxConnectionPoolManager ifxConnectionPoolManager2) {
            this.cpm = ifxConnectionPoolManager2;
        }

        public void run() {
            this.cpm.pool.flushThePool();
        }
    }

    private class Pool {
        private IfxConnectionPoolManager cpm;
        private LinkedList poolList;
        private boolean fillingInProgress = false;
        private boolean shutdownFlag = false;
        private boolean isPrimaryPool;

        Pool(IfxConnectionPoolManager ifxConnectionPoolManager2) {
            this.cpm = ifxConnectionPoolManager2;
            this.poolList = new LinkedList();
        }

        synchronized boolean add(IfxPooledConnection ifxPooledConnection) {
            if (IfxConnectionPoolManager.this.maxPoolSize > -1 && this.poolList.size() >= IfxConnectionPoolManager.this.maxPoolSize || this.shutdownFlag) {
                return true;
            }
            ifxPooledConnection.setTimeInPool();
            this.poolList.addLast(ifxPooledConnection);
            return false;
        }

        synchronized IfxPooledConnection remove(String string, String string2) throws SQLException {
            IfxPooledConnection ifxPooledConnection = null;
            if (this.shutdownFlag) {
                throw IfxErrMsg.getLocSQLException((int)-79716, (String)"shutdown in progress", (String)IfxConnectionPoolManager.this.ClientLocale);
            }
            try {
                int n = this.poolList.size();
                ListIterator listIterator = this.poolList.listIterator(n);
                while ((ifxPooledConnection = (IfxPooledConnection)listIterator.previous()) != null) {
                    String string3 = null;
                    String string4 = null;
                    IfxSqliConnReUsableConnection ifxSqliConnReUsableConnection = (IfxSqliConnReUsableConnection)((Object)ifxPooledConnection.getConnection());
                    if (ifxSqliConnReUsableConnection == null || (string3 = ifxSqliConnReUsableConnection.getConnUser()) == null || !string3.equals(string) || (string4 = ifxSqliConnReUsableConnection.getConnPasswd()) == null || !string4.equals(string2)) continue;
                    listIterator.remove();
                    break;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                ifxPooledConnection = null;
            }
            return ifxPooledConnection;
        }

        public int roughCount() {
            return this.poolList.size();
        }

        private void fillThePool(int n, long l) throws SQLException {
            this.fillingInProgress = true;
            int n2 = 0;
            while (this.roughCount() < n) {
                try {
                    IfxPooledConnection ifxPooledConnection = (IfxPooledConnection)IfxConnectionPoolManager.this.cpds.getPooledConnection(IfxConnectionPoolManager.this.DSuser, IfxConnectionPoolManager.this.DSpassword, IfxConnectionPoolManager.this.connectionListener);
                    if (this.add(ifxPooledConnection)) {
                        ifxPooledConnection.close();
                        break;
                    }
                    ++n2;
                    if (l <= 0L) continue;
                    Thread.currentThread();
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (SQLException sQLException) {
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
            this.fillingInProgress = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void skimThePool(long l) {
            if (IfxConnectionPoolManager.this.ageLimit < 0L) {
                return;
            }
            int n = Integer.MAX_VALUE;
            while (n-- > 0 && !this.shutdownFlag) {
                IfxPooledConnection ifxPooledConnection;
                try {
                    LinkedList linkedList = this.poolList;
                    synchronized (linkedList) {
                        ifxPooledConnection = (IfxPooledConnection)this.poolList.removeFirst();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
                long l2 = l - ifxPooledConnection.timeInPool;
                if (!(l2 >= IfxConnectionPoolManager.this.ageLimit && (IfxConnectionPoolManager.this.minAgeLimit != -1L && l2 >= IfxConnectionPoolManager.this.minAgeLimit + IfxConnectionPoolManager.this.ageLimit || this.poolList.size() >= IfxConnectionPoolManager.this.minPoolSize) || this.shutdownFlag)) {
                    LinkedList linkedList = this.poolList;
                    synchronized (linkedList) {
                        this.poolList.addFirst(ifxPooledConnection);
                        break;
                    }
                }
                try {
                    ifxPooledConnection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Thread.currentThread();
                Thread.yield();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void flushThePool() {
            this.shutdownFlag = true;
            LinkedList linkedList = this.poolList;
            synchronized (linkedList) {
                while (true) {
                    try {
                        while (true) {
                            IfxPooledConnection ifxPooledConnection = (IfxPooledConnection)this.poolList.removeFirst();
                            ifxPooledConnection.close();
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private class PoolServiceThread
    extends Thread {
        private IfxConnectionPoolManager cpm;
        private long sleepTime;

        PoolServiceThread(IfxConnectionPoolManager ifxConnectionPoolManager2, long l) {
            this.cpm = ifxConnectionPoolManager2;
            this.sleepTime = l > 0L ? l : Long.MAX_VALUE;
            this.setName("CPMservice");
            if (ifxConnectionPoolManager2.isDirectConnect) {
                return;
            }
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    do {
                        PoolServiceThread.sleep(this.sleepTime);
                        IfxConnectionPoolManager.this.pool.skimThePool(System.currentTimeMillis());
                    } while (!this.cpm.isDirectConnect || IfxConnectionPoolManager.this.pool.roughCount() != 0);
                    IfxConnectionPoolDataSource ifxConnectionPoolDataSource = IfxConnectionPoolManager.this.cpds;
                    synchronized (ifxConnectionPoolDataSource) {
                        if (IfxConnectionPoolManager.this.cpds.getConnectionCount() == 0) {
                            if (this.cpm.cpmTrace != null) {
                                this.cpm.cpmTrace.writeTrace(1, "IfxConnectionPoolManager: PoolServiceThread exits");
                            }
                            return;
                        }
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    try {
                        IfxConnectionPoolManager.this.pool.fillThePool(IfxConnectionPoolManager.this.minPoolSize, IfxConnectionPoolManager.this.serviceInterval);
                    }
                    catch (SQLException sQLException) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

