/*
 * Decompiled with CFR 0.152.
 */
package ins.framework;

import ins.framework.VersionFrame;
import ins.framework.utils.SwingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public final class Version {
    private static ResourceBundle versionResourceBundle;
    private static String version;
    private static String date;
    private static String buildNumber;

    static {
        version = "";
        date = "";
        buildNumber = "";
        try {
            InputStream is = Version.class.getResourceAsStream("Version.properties");
            if (is != null) {
                versionResourceBundle = new PropertyResourceBundle(is);
                String rc = versionResourceBundle.getString("version.number.rc");
                rc = rc != null ? (rc.equals("0") || rc.equals("") ? "" : (rc.equals("999") ? " Final" : "-RC" + rc)) : "";
                buildNumber = versionResourceBundle.getString("version.build");
                version = String.valueOf(versionResourceBundle.getString("version.number.1")) + "." + versionResourceBundle.getString("version.number.2") + "." + versionResourceBundle.getString("version.number.3") + rc;
            }
            date = versionResourceBundle.getString("version.date");
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            version = "{File Version.properties not available.}";
        }
    }

    private Version() {
    }

    public static String getVersion() {
        return version;
    }

    public static String getHomepage() {
        return "http://zhouxianli.blogdriver.com/";
    }

    public static String getVendor() {
        return "zhouxianli1978@msn.com";
    }

    public static String getAbout() {
        return String.valueOf(Version.getDescription()) + "(" + Version.getVersion() + ") Vendor:" + Version.getVendor();
    }

    public static String getDescription() {
        return "sinosoft-arch4";
    }

    public static String getCopyright() {
        return "<html>CopyRights<hr> " + Version.getDescription() + "(" + Version.getVersion() + ") build " + buildNumber + "<hr>build at " + date + " <br>Vendor:" + Version.getVendor() + "</html>";
    }

    public static void main(String[] args) {
        try {
            VersionFrame frame = new VersionFrame();
            frame.setDefaultCloseOperation(3);
            SwingUtils.center(frame);
            frame.setVisible(true);
        }
        catch (Exception e) {
            System.out.println(Version.getAbout());
        }
    }
}

