/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.common;

import ins.framework.utils.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class HqlQueryRule {
    private StringBuilder hql = new StringBuilder();
    private List<Object> values = new ArrayList<Object>();
    private static final String AND = " and ";

    public String getHql() {
        String hqlString = this.hql.toString();
        if (hqlString != null && !hqlString.equals("")) {
            hqlString = hqlString.substring(4);
        }
        return hqlString;
    }

    public Object[] getValues() {
        return this.values.toArray();
    }

    public HqlQueryRule addEqual(String name, Integer value) {
        this.hql.append(AND).append(name).append("=?");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addEqual(String name, Long value) {
        this.hql.append(AND).append(name).append("=?");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addEqual(String name, String value) {
        this.hql.append(AND).append(name).append("=?");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addEqual(String name, Double value) {
        this.hql.append(AND).append(name).append("=?");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addEqual(String name, Float value) {
        this.hql.append(AND).append(name).append("=?");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addEqual(String name, Date value, Integer dateRange) {
        if (dateRange == null) {
            dateRange = 16;
        }
        if (name != null && value != null) {
            if (dateRange == 16) {
                this.values.add(value);
                this.hql.append(" And ");
                this.hql.append(name);
                this.hql.append(" = ? ");
            } else if (dateRange == 13) {
                value.setHours(0);
                value.setMinutes(0);
                value.setSeconds(0);
                this.values.add(value);
                this.hql.append(" And ");
                this.hql.append(name);
                this.hql.append(" = ? ");
            }
        }
        return this;
    }

    public HqlQueryRule addBetween(String name, Long begin, Long end) {
        this.hql.append(" And (").append(name).append(" between ? And ?)");
        this.values.add(begin);
        this.values.add(end);
        return this;
    }

    public HqlQueryRule addBetween(String name, Integer begin, Integer end) {
        this.hql.append(" And (").append(name).append(" between ? And ?)");
        this.values.add(begin);
        this.values.add(end);
        return this;
    }

    public HqlQueryRule addBetween(String name, Double begin, Double end) {
        this.hql.append(" And (").append(name).append(" between ? And ?)");
        this.values.add(begin);
        this.values.add(end);
        return this;
    }

    public HqlQueryRule addBetween(String name, Float begin, Float end) {
        this.hql.append(" And (").append(name).append(" between ? And ?)");
        this.values.add(begin);
        this.values.add(end);
        return this;
    }

    public HqlQueryRule addGreaterEqual(String name, Integer value) {
        this.hql.append(AND).append(name).append(" >= ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addGreaterEqual(String name, Long value) {
        this.hql.append(AND).append(name).append(" >= ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addGreaterEqual(String name, Double value) {
        this.hql.append(AND).append(name).append(" >= ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addGreaterEqual(String name, Float value) {
        this.hql.append(AND).append(name).append(" >= ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addGreaterThen(String name, Integer value) {
        this.hql.append(AND).append(name).append(" > ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addGreaterThen(String name, Long value) {
        this.hql.append(AND).append(name).append(" > ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addGreaterThen(String name, Double value) {
        this.hql.append(AND).append(name).append(" > ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addGreaterThen(String name, Float value) {
        this.hql.append(AND).append(name).append(" > ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addLessEqual(String name, Integer value) {
        this.hql.append(AND).append(name).append(" <= ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addLessEqual(String name, Long value) {
        this.hql.append(AND).append(name).append(" <= ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addLessEqual(String name, Double value) {
        this.hql.append(AND).append(name).append(" <= ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addLessEqual(String name, Float value) {
        this.hql.append(AND).append(name).append(" <= ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addLessThan(String name, Integer value) {
        this.hql.append(AND).append(name).append(" < ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addLessThan(String name, Long value) {
        this.hql.append(AND).append(name).append(" < ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addLessThan(String name, Double value) {
        this.hql.append(AND).append(name).append(" < ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addLessThan(String name, Float value) {
        this.hql.append(AND).append(name).append(" < ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addNotEqual(String name, String value) {
        this.hql.append(AND).append(name).append(" != ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addNotEqual(String name, Integer value) {
        this.hql.append(AND).append(name).append(" != ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addNotEqual(String name, Long value) {
        this.hql.append(AND).append(name).append(" != ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addNotEqual(String name, Double value) {
        this.hql.append(AND).append(name).append(" != ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addNotEqual(String name, Float value) {
        this.hql.append(AND).append(name).append(" != ? ");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addBetween(String name, Date begin, Date end, Integer dateRange) {
        if (dateRange != null) {
            dateRange = 16;
        }
        if (name != null && begin != null && end != null) {
            if (dateRange == 16) {
                this.values.add(begin);
                this.values.add(end);
                this.hql.append(" And ");
                this.hql.append(name);
                this.hql.append(" between ? And ?");
            } else if (dateRange == 13) {
                begin.setHours(0);
                begin.setMinutes(0);
                begin.setSeconds(0);
                end.setHours(59);
                end.setMinutes(59);
                end.setSeconds(59);
                this.values.add(begin);
                this.values.add(end);
                this.hql.append(" And ");
                this.hql.append(name);
                this.hql.append(" between ? And ? ");
            }
        }
        return this;
    }

    public HqlQueryRule addGreaterEqual(String name, Date value, Integer dateRange) {
        if (dateRange != null) {
            dateRange = 16;
        }
        if (name != null && value != null) {
            if (dateRange == 16) {
                this.values.add(value);
                this.hql.append(" And ");
                this.hql.append(name);
                this.hql.append(" >=? ");
            } else if (dateRange == 13) {
                value.setHours(0);
                value.setMinutes(0);
                value.setSeconds(0);
                this.values.add(value);
                this.hql.append(" And ");
                this.hql.append(name);
                this.hql.append(" >=? ");
            }
        }
        return this;
    }

    public HqlQueryRule addGreaterThan(String name, Date value, Integer dateRange) {
        if (dateRange != null) {
            dateRange = 16;
        }
        if (name != null && value != null) {
            if (dateRange == 16) {
                this.values.add(value);
                this.hql.append(" And ");
                this.hql.append(name);
                this.hql.append(" >? ");
            } else if (dateRange == 13) {
                value.setHours(0);
                value.setMinutes(0);
                value.setSeconds(0);
                this.values.add(value);
                this.hql.append(" And ");
                this.hql.append(name);
                this.hql.append(" >? ");
            }
        }
        return this;
    }

    public HqlQueryRule addLessEqual(String name, Date value, Integer dateRange) {
        if (dateRange != null) {
            dateRange = 16;
        }
        if (name != null && value != null) {
            if (dateRange == 16) {
                this.values.add(value);
                this.hql.append(" And ");
                this.hql.append(name);
                this.hql.append(" <=? ");
            } else if (dateRange == 13) {
                value.setHours(0);
                value.setMinutes(0);
                value.setSeconds(0);
                this.values.add(value);
                this.hql.append(" And ");
                this.hql.append(name);
                this.hql.append(" <=? ");
            }
        }
        return this;
    }

    public HqlQueryRule addLessThan(String name, Date value, Integer dateRange) {
        if (dateRange != null) {
            dateRange = 16;
        }
        if (name != null && value != null) {
            if (dateRange == 16) {
                this.values.add(value);
                this.hql.append(" And ");
                this.hql.append(name);
                this.hql.append(" <? ");
            } else if (dateRange == 13) {
                value.setHours(0);
                value.setMinutes(0);
                value.setSeconds(0);
                this.values.add(value);
                this.hql.append(" And ");
                this.hql.append(name);
                this.hql.append(" <? ");
            }
        }
        return this;
    }

    public HqlQueryRule addLike(String name, String value) {
        if (value != null) {
            value = StringUtils.replace(value, "*", "%");
        }
        this.hql.append(AND).append(name).append(" like ?");
        this.values.add(value);
        return this;
    }

    public HqlQueryRule addIn(String name, String[] value) {
        StringBuffer inCondition = new StringBuffer("");
        int i = 0;
        while (i < value.length) {
            if (i != value.length - 1) {
                inCondition.append("?,");
            } else {
                inCondition.append("?");
            }
            ++i;
        }
        this.hql.append(AND).append(name).append(" in (").append(inCondition).append(")");
        i = 0;
        while (i < value.length) {
            this.values.add(value[i]);
            ++i;
        }
        return this;
    }

    public HqlQueryRule addHql(String hql) {
        this.hql.append(hql);
        return this;
    }

    public HqlQueryRule addSql(String sql) {
        this.hql.append(sql);
        return this;
    }
}

