/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.compass;

import ins.framework.compass.AdvancedSearchCommand;
import org.compass.core.Compass;
import org.compass.core.CompassCallback;
import org.compass.core.CompassDetachedHits;
import org.compass.core.CompassHits;
import org.compass.core.CompassQuery;
import org.compass.core.CompassSession;
import org.compass.core.CompassTemplate;
import org.compass.core.CompassTransaction;
import org.compass.spring.web.mvc.CompassSearchCommand;
import org.compass.spring.web.mvc.CompassSearchResults;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CompassSearchService
implements InitializingBean {
    private static final int DEFAULT_PAGE_SIZE = 15;
    private Integer pageSize = 15;
    private Compass compass;
    private CompassTemplate compassTemplate;

    public CompassSearchResults search(final CompassSearchCommand command) {
        return (CompassSearchResults)this.getCompassTemplate().execute(CompassTransaction.TransactionIsolation.READ_ONLY_READ_COMMITTED, new CompassCallback(){

            public Object doInCompass(CompassSession session) {
                return CompassSearchService.this.performSearch(command, session);
            }
        });
    }

    protected CompassSearchResults performSearch(CompassSearchCommand searchCommand, CompassSession session) {
        CompassDetachedHits detachedHits;
        long time = System.currentTimeMillis();
        CompassQuery query = this.buildQuery(searchCommand, session);
        CompassHits hits = query.hits();
        CompassSearchResults.Page[] pages = null;
        if (this.pageSize == null) {
            this.doProcessBeforeDetach(searchCommand, session, hits, -1, -1);
            detachedHits = hits.detach();
        } else {
            CompassSearchResults.Page lastPage;
            int from;
            int iPageSize = this.pageSize;
            int page = 0;
            int hitsLength = hits.getLength();
            if (searchCommand.getPage() != null) {
                page = searchCommand.getPage();
            }
            if ((from = page * iPageSize) > hits.getLength()) {
                from = hits.getLength() - iPageSize;
                this.doProcessBeforeDetach(searchCommand, session, hits, from, hitsLength);
                detachedHits = hits.detach(from, hitsLength);
            } else if (from + iPageSize > hitsLength) {
                this.doProcessBeforeDetach(searchCommand, session, hits, from, hitsLength);
                detachedHits = hits.detach(from, hitsLength);
            } else {
                this.doProcessBeforeDetach(searchCommand, session, hits, from, iPageSize);
                detachedHits = hits.detach(from, iPageSize);
            }
            this.doProcessAfterDetach(searchCommand, session, detachedHits);
            int numberOfPages = (int)Math.ceil((float)hitsLength / (float)iPageSize);
            pages = new CompassSearchResults.Page[numberOfPages];
            int i = 0;
            while (i < pages.length) {
                pages[i] = new CompassSearchResults.Page();
                pages[i].setFrom(i * iPageSize + 1);
                pages[i].setSize(iPageSize);
                pages[i].setTo((i + 1) * iPageSize);
                if (from >= pages[i].getFrom() - 1 && from < pages[i].getTo()) {
                    pages[i].setSelected(true);
                } else {
                    pages[i].setSelected(false);
                }
                ++i;
            }
            if (numberOfPages > 0 && (lastPage = pages[numberOfPages - 1]).getTo() > hitsLength) {
                lastPage.setSize(hitsLength - lastPage.getFrom());
                lastPage.setTo(hitsLength);
            }
        }
        time = System.currentTimeMillis() - time;
        CompassSearchResults searchResults = new CompassSearchResults(detachedHits.getHits(), time);
        searchResults.setPages(pages);
        return searchResults;
    }

    protected CompassQuery buildQuery(CompassSearchCommand searchCommand, CompassSession session) {
        CompassQuery query = session.queryBuilder().queryString(searchCommand.getQuery().trim()).toQuery();
        if (AdvancedSearchCommand.class.isAssignableFrom(searchCommand.getClass())) {
            AdvancedSearchCommand advancedSearchCommand = (AdvancedSearchCommand)searchCommand;
            for (AdvancedSearchCommand.CompassSort sort : advancedSearchCommand.getSortMap()) {
                query.addSort(sort.getName(), sort.getType(), sort.getDirection());
            }
        }
        return query;
    }

    protected void doProcessBeforeDetach(CompassSearchCommand searchCommand, CompassSession session, CompassHits hits, int from, int size) {
        if (AdvancedSearchCommand.class.isAssignableFrom(searchCommand.getClass())) {
            String[] highlightFields;
            if (from < 0) {
                from = 0;
                size = hits.getLength();
            }
            if ((highlightFields = ((AdvancedSearchCommand)searchCommand).getHighlightFields()) == null) {
                return;
            }
            int i = from;
            while (i < size) {
                String[] stringArray = highlightFields;
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String highlightField = stringArray[n];
                    hits.highlighter(i).fragment(highlightField);
                    ++n;
                }
                ++i;
            }
        }
    }

    protected void doProcessAfterDetach(CompassSearchCommand searchCommand, CompassSession session, CompassDetachedHits hits) {
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.compass, (String)"Must set compass property");
        this.compassTemplate = new CompassTemplate(this.compass);
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setCompass(Compass compass) {
        this.compass = compass;
    }

    protected CompassTemplate getCompassTemplate() {
        return this.compassTemplate;
    }
}

