/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.dao;

import ins.framework.common.Page;
import ins.framework.common.QueryRule;
import ins.framework.dao.support.QueryRuleUtils;
import ins.framework.utils.BeanUtils;
import ins.framework.utils.DataUtils;
import ins.framework.utils.StringUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.impl.CriteriaImpl;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityDaoHibernate
extends HibernateDaoSupport
implements ApplicationContextAware {
    protected ApplicationContext applicationContext;

    public <T> T get(Class<T> entityClass, Serializable id) {
        return (T)this.getHibernateTemplate().get(entityClass, id);
    }

    public <T> List<T> getAll(Class<T> entityClass) {
        return this.getHibernateTemplate().loadAll(entityClass);
    }

    public void save(Object obj) {
        this.getHibernateTemplate().saveOrUpdate(obj);
    }

    public void update(Object obj) {
        this.getHibernateTemplate().update(obj);
    }

    public void saveAll(List list) {
        this.getHibernateTemplate().saveOrUpdateAll((Collection)list);
    }

    public void delete(Object obj) {
        this.getHibernateTemplate().delete(obj);
    }

    public <T> void deleteAll(List entityList) {
        this.getHibernateTemplate().deleteAll((Collection)entityList);
    }

    public <T> void deleteByPK(Class<T> entityClass, Serializable id) {
        T obj = this.get(entityClass, id);
        if (obj != null) {
            this.delete(obj);
        }
    }

    public void flush() {
        this.getHibernateTemplate().flush();
    }

    public void evict(Object obj) {
        this.getHibernateTemplate().evict(obj);
    }

    public void clear() {
        this.getHibernateTemplate().clear();
    }

    public List findByHql(String hql, final Object ... values) {
        Assert.hasText((String)hql);
        String newHql = hql;
        int pos = 0;
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                if ((pos = newHql.indexOf(63, pos)) == -1) break;
                if (values[i] instanceof Collection && pos > -1) {
                    newHql = String.valueOf(newHql.substring(0, pos)) + ":queryParam" + i + newHql.substring(pos + 1);
                }
                ++pos;
                ++i;
            }
        }
        final String fnHql = newHql;
        List list = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                Query query = session.createQuery(fnHql);
                if (values != null) {
                    int i = 0;
                    while (i < values.length) {
                        if (values[i] instanceof Collection) {
                            query.setParameterList("queryParam" + i, (Collection)values[i]);
                        } else {
                            query.setParameter(i, values[i]);
                        }
                        ++i;
                    }
                }
                return query.list();
            }
        });
        return list;
    }

    public List findTopByHql(String hql, final int top, final Object ... values) {
        String newHql = hql;
        int pos = 0;
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                if ((pos = newHql.indexOf(63, pos)) == -1) break;
                if (values[i] instanceof Collection && pos > -1) {
                    newHql = String.valueOf(newHql.substring(0, pos)) + ":queryParam" + i + newHql.substring(pos + 1);
                }
                ++pos;
                ++i;
            }
        }
        final String fnHql = newHql;
        List list = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                Query query = session.createQuery(fnHql);
                if (values != null) {
                    int i = 0;
                    while (i < values.length) {
                        if (values[i] instanceof Collection) {
                            query.setParameterList("queryParam" + i, (Collection)values[i]);
                        } else {
                            query.setParameter(i, values[i]);
                        }
                        ++i;
                    }
                }
                query.setFirstResult(0);
                query.setMaxResults(top);
                return query.list();
            }
        });
        return list;
    }

    public Page findByHql(String hql, int pageNo, final int pageSize, final Object ... values) {
        Assert.hasText((String)hql);
        Assert.isTrue((pageNo >= 1 ? 1 : 0) != 0, (String)"pageNo should start from 1");
        String newHql = hql;
        int pos = 0;
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                if ((pos = newHql.indexOf(63, pos)) == -1) break;
                if (values[i] instanceof Collection && pos > -1) {
                    newHql = String.valueOf(newHql.substring(0, pos)) + ":queryParam" + i + newHql.substring(pos + 1);
                }
                ++pos;
                ++i;
            }
        }
        final String fnHql = newHql;
        final String countQueryString = " select count (*) " + EntityDaoHibernate.removeSelect(EntityDaoHibernate.removeOrders(fnHql));
        List countlist = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                Query query = session.createQuery(countQueryString);
                if (values != null) {
                    int i = 0;
                    while (i < values.length) {
                        if (values[i] instanceof Collection) {
                            query.setParameterList("queryParam" + i, (Collection)values[i]);
                        } else {
                            query.setParameter(i, values[i]);
                        }
                        ++i;
                    }
                }
                return query.list();
            }
        });
        long totalCount = (Long)countlist.get(0);
        if (totalCount < 1L) {
            return new Page();
        }
        final int startIndex = Page.getStartOfPage(pageNo, pageSize);
        List list = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                Query query = session.createQuery(fnHql);
                if (values != null) {
                    int i = 0;
                    while (i < values.length) {
                        if (values[i] instanceof Collection) {
                            query.setParameterList("queryParam" + i, (Collection)values[i]);
                        } else {
                            query.setParameter(i, values[i]);
                        }
                        ++i;
                    }
                }
                query.setFirstResult(startIndex);
                query.setMaxResults(pageSize);
                return query.list();
            }
        });
        return new Page(startIndex, totalCount, pageSize, list);
    }

    public <T> T findUnique(Class<T> entityClass, String propertyName, Object value) {
        QueryRule queryRule = QueryRule.getInstance();
        queryRule.addEqual(propertyName, value);
        List list = this.find(entityClass, queryRule);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return (T)list.get(0);
        }
        throw new IllegalStateException("findUnique return " + list.size() + " record(s).");
    }

    public <T> boolean exists(Class<T> entityClass, Serializable id) {
        Object entity = super.getHibernateTemplate().get(entityClass, id);
        return entity != null;
    }

    public long getCount(String hql, Object ... values) {
        Assert.hasText((String)hql);
        String countQueryString = " select count (*) " + EntityDaoHibernate.removeSelect(EntityDaoHibernate.removeOrders(hql));
        List countlist = this.getHibernateTemplate().find(countQueryString, values);
        long totalCount = (Long)countlist.get(0);
        return totalCount;
    }

    protected static String removeSelect(String hql) {
        Assert.hasText((String)hql);
        int beginPos = hql.toLowerCase().indexOf("from");
        Assert.isTrue((beginPos != -1 ? 1 : 0) != 0, (String)(" hql : " + hql + " must has a keyword 'from'"));
        return hql.substring(beginPos);
    }

    protected static String removeOrders(String hql) {
        Assert.hasText((String)hql);
        Pattern p = Pattern.compile("order\\s*by[\\w|\\W|\\s|\\S]*", 2);
        Matcher m = p.matcher(hql);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public <T> List find(final Class<T> entityClass, final QueryRule queryRule) {
        List list = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                Criteria criteria = session.createCriteria(entityClass);
                QueryRuleUtils.createCriteriaWithQueryRule(criteria, queryRule);
                List<Order> orders = EntityDaoHibernate.this.getOrderFromQueryRule(queryRule);
                for (Order o : orders) {
                    criteria.addOrder(o);
                }
                return criteria.setFirstResult(0).list();
            }
        });
        return list;
    }

    public <T> Page find(final Class<T> entityClass, final QueryRule queryRule, final int pageNo, final int pageSize) {
        Page page = (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                List orderEntries;
                Criteria criteria = session.createCriteria(entityClass);
                QueryRuleUtils.createCriteriaWithQueryRule(criteria, queryRule);
                CriteriaImpl impl = (CriteriaImpl)criteria;
                Projection projection = impl.getProjection();
                try {
                    orderEntries = (List)BeanUtils.forceGetProperty(impl, "orderEntries");
                    BeanUtils.forceSetProperty(impl, "orderEntries", new ArrayList());
                }
                catch (Exception e) {
                    throw new InternalError(" Runtime Exception impossibility throw ");
                }
                long totalCount = ((Integer)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
                criteria.setProjection(projection);
                if (projection == null) {
                    criteria.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
                }
                try {
                    BeanUtils.forceSetProperty(impl, "orderEntries", orderEntries);
                }
                catch (Exception e) {
                    throw new InternalError(" Runtime Exception impossibility throw ");
                }
                if (totalCount < 1L) {
                    return new Page();
                }
                List<Order> orders = EntityDaoHibernate.this.getOrderFromQueryRule(queryRule);
                for (Order o : orders) {
                    criteria.addOrder(o);
                }
                int startIndex = Page.getStartOfPage(pageNo, pageSize);
                List list = criteria.setFirstResult(startIndex).setMaxResults(pageSize).list();
                return new Page(startIndex, totalCount, pageSize, list);
            }
        });
        return page;
    }

    protected List<Order> getOrderFromQueryRule(QueryRule queryRule) {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (QueryRule.Rule rule : queryRule.getRuleList()) {
            switch (rule.getType()) {
                case 101: {
                    if (!StringUtils.isNotEmpty((String)rule.getPropertyName())) break;
                    orders.add(Order.asc((String)rule.getPropertyName()));
                    break;
                }
                case 102: {
                    if (!StringUtils.isNotEmpty((String)rule.getPropertyName())) break;
                    orders.add(Order.desc((String)rule.getPropertyName()));
                    break;
                }
            }
        }
        return orders;
    }

    public <T> T findUnique(Class<T> entityClass, Map<String, Object> properties) {
        QueryRule queryRule = QueryRule.getInstance();
        for (String key : properties.keySet()) {
            queryRule.addEqual(key, properties.get(key));
        }
        return this.findUnique(entityClass, queryRule);
    }

    public <T> T findUnique(Class<T> entityClass, QueryRule queryRule) {
        List list = this.find(entityClass, queryRule);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return (T)list.get(0);
        }
        throw new IllegalStateException("findUnique return " + list.size() + " record(s).");
    }

    public <T> Page pagination(List<T> objList, int pageNo, int pageSize) {
        ArrayList<T> objectArray = new ArrayList<T>(0);
        int startIndex = (pageNo - 1) * pageSize;
        int endIndex = pageNo * pageSize;
        int i = startIndex;
        while (i < endIndex) {
            objectArray.add(objList.get(i));
            ++i;
        }
        return new Page(startIndex, objList.size(), pageSize, objectArray);
    }

    public void mergeList(List pojoList, List poList, String idName) {
        this.mergeList(pojoList, poList, idName, false);
    }

    public void mergeList(List pojoList, List poList, String idName, boolean isCopyNull) {
        Object key;
        HashMap map = new HashMap();
        String methodName = "get" + StringUtils.upperCaseFirstChar(idName);
        for (Object element : pojoList) {
            try {
                key = BeanUtils.invoke(element, methodName, new Class[0], new Object[0]);
                map.put(key, element);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        Iterator it = poList.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            try {
                key = BeanUtils.invoke(element, methodName, new Class[0], new Object[0]);
                if (!map.containsKey(key)) {
                    this.delete(element);
                    it.remove();
                    continue;
                }
                DataUtils.copySimpleObject(map.get(key), element, isCopyNull);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        Object[] pojoArray = pojoList.toArray();
        int i = 0;
        while (i < pojoArray.length) {
            Object element = pojoArray[i];
            try {
                Object key2 = BeanUtils.invoke(element, methodName, new Class[0], new Object[0]);
                if (key2 == null) {
                    poList.add(element);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            ++i;
        }
    }

    public Long getSequence(final String sequenceName) {
        Long seq = (Long)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                SQLQuery sqlQuery = session.createSQLQuery("select " + sequenceName + ".nextval from systables where tabid=1");
                List list = sqlQuery.list();
                Long seqValue = new Long("" + list.get(0));
                return seqValue;
            }
        });
        return seq;
    }

    public List findUnionBySql(final String sql, final Object ... values) {
        Assert.hasText((String)sql);
        Assert.isTrue((sql.toLowerCase().indexOf("union") != -1 ? 1 : 0) != 0);
        List list = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                SQLQuery query = session.createSQLQuery(sql);
                if (values != null) {
                    int i = 0;
                    while (i < values.length) {
                        query.setParameter(i, values[i]);
                        ++i;
                    }
                }
                return query.list();
            }
        });
        return list;
    }

    public Page findUnionByHqls(List<String> hqls, List<List<Object>> valuess, int pageNo, int pageSize) {
        Long[] counts = new Long[hqls.size()];
        long totalCount = 0L;
        int k = 0;
        while (k < hqls.size()) {
            String newHql = hqls.get(k);
            final Object[] values = valuess.get(k).toArray();
            int pos = 0;
            if (values != null) {
                int i = 0;
                while (i < values.length) {
                    if ((pos = newHql.indexOf(63, pos)) == -1) break;
                    if (values[i] instanceof Collection && pos > -1) {
                        newHql = String.valueOf(newHql.substring(0, pos)) + ":queryParam" + i + newHql.substring(pos + 1);
                    }
                    ++pos;
                    ++i;
                }
            }
            String fnHql = newHql;
            final String countQueryString = " select count (*) " + EntityDaoHibernate.removeSelect(EntityDaoHibernate.removeOrders(fnHql));
            List countlist = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws SQLException {
                    Query query = session.createQuery(countQueryString);
                    if (values != null) {
                        int i = 0;
                        while (i < values.length) {
                            if (values[i] instanceof Collection) {
                                query.setParameterList("queryParam" + i, (Collection)values[i]);
                            } else {
                                query.setParameter(i, values[i]);
                            }
                            ++i;
                        }
                    }
                    return query.list();
                }
            });
            counts[k] = (Long)countlist.get(0);
            totalCount += counts[k].longValue();
            ++k;
        }
        ArrayList<List> datas = new ArrayList<List>();
        int startIndex = Page.getStartOfPage(pageNo, pageSize);
        long gindex = 0L;
        long selectCount = 0L;
        int k2 = 0;
        while (k2 < hqls.size()) {
            final String fnHql = hqls.get(k2);
            final Object[] values = valuess.get(k2).toArray();
            long realIndex = (long)startIndex - gindex;
            long realSize = (long)pageSize - selectCount;
            if (realIndex < 0L) {
                realIndex = 0L;
            }
            if (counts[k2] - realIndex < realSize) {
                realSize = counts[k2] - realIndex;
            }
            final long fnRealIndex = realIndex;
            final long fnRealSize = realSize;
            if (realIndex >= 0L && realSize > 0L) {
                List list = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                    public Object doInHibernate(Session session) throws SQLException {
                        Query query = session.createQuery(fnHql);
                        if (values != null) {
                            int i = 0;
                            while (i < values.length) {
                                if (values[i] instanceof Collection) {
                                    query.setParameterList("queryParam" + i, (Collection)values[i]);
                                } else {
                                    query.setParameter(i, values[i]);
                                }
                                ++i;
                            }
                        }
                        query.setFirstResult((int)fnRealIndex);
                        query.setMaxResults((int)fnRealSize);
                        return query.list();
                    }
                });
                datas.add(list);
                selectCount += fnRealSize;
            }
            if (selectCount == (long)pageSize) break;
            gindex += counts[k2].longValue();
            ++k2;
        }
        ArrayList resultList = new ArrayList();
        int i = 0;
        while (i < datas.size()) {
            resultList.addAll((Collection)datas.get(i));
            ++i;
        }
        return new Page(startIndex, totalCount, pageSize, resultList);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

