/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.log;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunTimeLogAdvice
implements MethodInterceptor {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public Object invoke(MethodInvocation invocation) throws Throwable {
        long start = System.currentTimeMillis();
        Object obj = invocation.proceed();
        StringBuilder builder = new StringBuilder();
        builder.append(this.methodToString(invocation.getMethod()));
        builder.append("|").append(System.currentTimeMillis() - start);
        this.logger.info((Object)builder.toString());
        return obj;
    }

    static String getTypeName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                int i = 0;
                while (i < dimensions) {
                    sb.append("[]");
                    ++i;
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    public String methodToString(Method method) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(String.valueOf(RunTimeLogAdvice.getTypeName(method.getDeclaringClass())) + ".");
            sb.append(String.valueOf(method.getName()) + "(");
            Class<?>[] params = method.getParameterTypes();
            int j = 0;
            while (j < params.length) {
                sb.append(RunTimeLogAdvice.getTypeName(params[j]));
                if (j < params.length - 1) {
                    sb.append(",");
                }
                ++j;
            }
            sb.append(")");
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }
}

