/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.security;

import ins.framework.utils.XMLUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionListBean
extends ArrayList<String> {
    private static final long serialVersionUID = 1L;
    protected final Log logger = LogFactory.getLog(this.getClass());

    public ActionListBean(String actionXml) {
        ArrayList<String> actionXmls = new ArrayList<String>();
        actionXmls.add(actionXml);
        this.execute(actionXmls);
    }

    public ActionListBean(List<String> actionXmls) {
        this.execute(actionXmls);
    }

    protected void execute(List<String> actionXmls) {
        if (actionXmls == null || actionXmls.size() == 0) {
            this.logger.warn((Object)"not set ActionListBean constructor-arg.");
            return;
        }
        for (String actionXml : actionXmls) {
            Node[] nodes;
            Document document = null;
            ClassPathResource res = new ClassPathResource(actionXml);
            try {
                document = XMLUtils.parse(res.getInputStream());
            }
            catch (Exception ex) {
                this.logger.error((Object)("parse " + actionXml + " fail."));
                ex.printStackTrace();
            }
            if (document == null) {
                return;
            }
            Node root = XMLUtils.getSingleNodeByTag(document, "beans");
            Node[] nodeArray = nodes = XMLUtils.getChildNodesByTagName(root, "bean");
            int n = 0;
            int n2 = nodeArray.length;
            while (n < n2) {
                Node node = nodeArray[n];
                String id = XMLUtils.getNodeAttribute(node, "id");
                if (id != null) {
                    this.addToList(id);
                }
                ++n;
            }
        }
    }

    private void addToList(String actionBeanId) {
        this.add(actionBeanId);
    }
}

