/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.test;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;
import junit.framework.TestCase;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public abstract class FunctionalTestCase
extends TestCase {
    protected static final String DEFAULT_EXPLORER = "*iexplore";
    protected static final String DEFAULT_BASEURL = "http://localhost:8080";
    protected static final String DEFAULT_TIME = "30000";
    private static PropertiesConfiguration config = new PropertiesConfiguration();
    protected Selenium user;

    static {
        try {
            config.load("selenium.properties");
        }
        catch (ConfigurationException e) {
            System.out.println("Can't found selenium.properties.");
        }
    }

    public void setUp() {
        this.user = new DefaultSelenium("localhost", 4444, FunctionalTestCase.getExplorer(), FunctionalTestCase.getBaseURL());
        this.user.start();
    }

    public void tearDown() {
        this.user.stop();
    }

    public static String getExplorer() {
        return config.getString("selenium.explorer", DEFAULT_EXPLORER);
    }

    public static String getBaseURL() {
        return config.getString("selenium.baseurl", DEFAULT_BASEURL);
    }
}

