/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;

public class FileUtils {
    private static final File POOL_FILE = FileUtils.getUniqueFile(FileUtils.class, ".deletefiles");
    private static ArrayList<File> deleteFilesPool;

    static {
        try {
            FileUtils.initPool();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initPool() {
        if (POOL_FILE.exists() && POOL_FILE.canRead()) {
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(POOL_FILE));
                deleteFilesPool = (ArrayList)in.readObject();
                in.close();
            }
            catch (Exception e) {
                deleteFilesPool = new ArrayList();
            }
        } else {
            deleteFilesPool = new ArrayList();
        }
    }

    private FileUtils() {
    }

    public static void copyFile(String fromFile, String toFile) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(fromFile);
        FileOutputStream out = new FileOutputStream(toFile);
        byte[] b = new byte[1024];
        while ((len = in.read(b)) != -1) {
            out.write(b, 0, len);
        }
        out.close();
        in.close();
    }

    public static String getShortFileName(String fileName) {
        String shortFileName = "";
        int pos = fileName.lastIndexOf(92);
        if (pos == -1) {
            pos = fileName.lastIndexOf(47);
        }
        shortFileName = pos > -1 ? fileName.substring(pos + 1) : fileName;
        return shortFileName;
    }

    public static String getShortFileNameWithoutExt(String fileName) {
        String shortFileName = FileUtils.getShortFileName(fileName);
        shortFileName = FileUtils.getFileNameWithoutExt(shortFileName);
        return shortFileName;
    }

    public static String read(String fileName) throws Exception {
        String fileContent = "";
        fileContent = FileUtils.read(new FileInputStream(fileName));
        return fileContent;
    }

    public static String read(File file) throws Exception {
        String fileContent = "";
        fileContent = FileUtils.read(new FileInputStream(file));
        return fileContent;
    }

    public static String read(InputStream is) throws Exception {
        byte[] result = FileUtils.readBytes(is);
        return new String(result);
    }

    public static byte[] readBytes(String fileName) throws Exception {
        return FileUtils.readBytes(new FileInputStream(fileName));
    }

    public static byte[] readBytes(File file) throws Exception {
        return FileUtils.readBytes(new FileInputStream(file));
    }

    public static byte[] readBytes(InputStream is) throws Exception {
        int nch;
        if (is == null || is.available() < 1) {
            return new byte[0];
        }
        byte[] buff = new byte[8192];
        byte[] result = new byte[is.available()];
        BufferedInputStream in = new BufferedInputStream(is);
        int pos = 0;
        while ((nch = in.read(buff, 0, buff.length)) != -1) {
            System.arraycopy(buff, 0, result, pos, nch);
            pos += nch;
        }
        in.close();
        return result;
    }

    public static void write(String content, File file) throws IOException {
        FileUtils.write(content.getBytes(), file);
    }

    public static void write(String content, String file) throws IOException {
        FileUtils.write(content, new File(file));
    }

    public static void write(byte[] bytes, String file) throws IOException {
        FileUtils.write(bytes, new File(file));
    }

    public static void write(byte[] bytes, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        out.write(bytes);
        out.flush();
        out.close();
    }

    public static String getFileNameWithoutExt(String fileName) {
        String shortFileName = fileName;
        if (fileName.indexOf(46) > -1) {
            shortFileName = fileName.substring(0, fileName.lastIndexOf(46));
        }
        return shortFileName;
    }

    public static String getFileNameExt(String fileName) {
        String fileExt = "";
        if (fileName.indexOf(46) > -1) {
            fileExt = fileName.substring(fileName.lastIndexOf(46));
        }
        return fileExt;
    }

    public static synchronized File getUniqueFile(File repository, String fileName) {
        String shortFileName = FileUtils.getShortFileName(fileName);
        String tempFileName = FileUtils.getFileNameWithoutExt(shortFileName);
        File file = new File(repository, shortFileName);
        String fileExt = FileUtils.getFileNameExt(shortFileName);
        while (file.exists()) {
            file = new File(repository, String.valueOf(tempFileName) + "-" + Math.abs(Math.random() * 1000000.0) + fileExt);
        }
        return file;
    }

    public static void deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            FileUtils.deleteFile(file);
        }
    }

    public static void deleteFile(File file) {
        file.delete();
        if (file.exists()) {
            deleteFilesPool.add(file);
        }
        FileUtils.checkDeletePool();
    }

    private static void checkDeletePool() {
        int i = deleteFilesPool.size() - 1;
        while (i >= 0) {
            File file = deleteFilesPool.get(i);
            file.delete();
            if (!file.exists()) {
                deleteFilesPool.remove(i);
            }
            --i;
        }
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(POOL_FILE));
            out.writeObject(deleteFilesPool);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File getUniqueFile(Class cl, String extension) {
        int key = 0;
        URL url = cl.getResource(String.valueOf(FileUtils.getClassNameWithoutPackage(cl)) + ".class");
        if (url != null) {
            key = url.getPath().hashCode();
        }
        File propFile = new File(System.getProperty("java.io.tmpdir"), String.valueOf(FileUtils.getClassNameWithoutPackage(cl)) + key + extension);
        return propFile;
    }

    private static String getClassNameWithoutPackage(Class cl) {
        String className = cl.getName();
        int pos = className.lastIndexOf(46) + 1;
        if (pos == -1) {
            pos = 0;
        }
        String name = className.substring(pos);
        return name;
    }

    public static boolean deleteFolder(File delFolder) {
        boolean hasDeleted = true;
        File[] allFiles = delFolder.listFiles();
        int i = 0;
        while (i < allFiles.length) {
            if (!hasDeleted) break;
            if (allFiles[i].isDirectory()) {
                hasDeleted = FileUtils.deleteFolder(allFiles[i]);
            } else if (allFiles[i].isFile()) {
                try {
                    if (!allFiles[i].delete()) {
                        hasDeleted = false;
                    }
                }
                catch (Exception e) {
                    hasDeleted = false;
                }
            }
            ++i;
        }
        if (hasDeleted) {
            delFolder.delete();
        }
        return hasDeleted;
    }

    public static String getRealPathName(Class cl) {
        URL url = cl.getResource(String.valueOf(FileUtils.getClassNameWithoutPackage(cl)) + ".class");
        if (url != null) {
            return url.getPath();
        }
        return null;
    }
}

