/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.web;

import com.opensymphony.xwork2.ActionSupport;
import ins.framework.common.Page;
import ins.framework.utils.StringUtils;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.util.Assert;

public class Struts2Action
extends ActionSupport {
    private static final long serialVersionUID = 1L;
    protected static final Log logger = LogFactory.getLog(Struts2Action.class);
    protected int pageNo;
    protected int pageSize;

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    protected void render(String text, String contentType) {
        try {
            HttpServletResponse response = this.getResponse();
            response.setContentType(contentType);
            response.getWriter().write(text);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    protected void renderText(String text) {
        this.render(text, "text/plain;charset=UTF-8");
    }

    protected void renderHtml(String text) {
        this.render(text, "text/html;charset=UTF-8");
    }

    protected void renderXML(String text) {
        this.render(text, "text/xml;charset=UTF-8");
    }

    protected void saveMessage(String msg) {
        ArrayList<String> messages = (ArrayList<String>)this.getRequest().getSession().getAttribute("messages");
        if (messages == null) {
            messages = new ArrayList<String>();
        }
        messages.add(msg);
        this.getSession().setAttribute("messages", messages);
    }

    protected HttpServletRequest getRequest() {
        return ServletActionContext.getRequest();
    }

    protected ServletContext getServletContext() {
        return ServletActionContext.getServletContext();
    }

    protected HttpServletResponse getResponse() {
        return ServletActionContext.getResponse();
    }

    protected HttpSession getSession() {
        return this.getRequest().getSession();
    }

    protected HttpSession getSession(boolean flag) {
        return this.getRequest().getSession(flag);
    }

    public void writeJSONData(Page page, String ... args) {
        try {
            Assert.notEmpty((Object[])args);
            Vector dataList = new Vector();
            List list = page.getResult();
            int size = args.length;
            for (Object element : list) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>(size);
                int i = 0;
                while (i < size) {
                    Object value = null;
                    if (args[i].indexOf(46) > -1) {
                        String[] arrArg = StringUtils.split((String)args[i], (char)'.');
                        value = element;
                        int j = 0;
                        while (j < arrArg.length - 1) {
                            value = PropertyUtils.getProperty((Object)value, (String)arrArg[j]);
                            value = PropertyUtils.getProperty((Object)value, (String)arrArg[j + 1]);
                            ++j;
                        }
                    } else {
                        value = PropertyUtils.getProperty(element, (String)args[i]);
                    }
                    dataMap.put(args[i], this.fixValueForJSON(value));
                    ++i;
                }
                dataList.add(dataMap);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("totalRecords", page.getTotalCount());
            jsonObject.put("data", (Object)JSONArray.fromObject(dataList));
            this.renderHtml(jsonObject.toString());
        }
        catch (Exception e) {
            this.writeJSONMsg(e.getMessage());
        }
    }

    public void writeJSONData(List list, String ... args) {
        try {
            Assert.notEmpty((Object[])args);
            Vector dataList = new Vector();
            int size = args.length;
            for (Object element : list) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>(size);
                int i = 0;
                while (i < size) {
                    Object value = null;
                    if (args[i].indexOf(46) > -1) {
                        String[] arrArg = StringUtils.split((String)args[i], (char)'.');
                        value = element;
                        int j = 0;
                        while (j < arrArg.length - 1) {
                            value = PropertyUtils.getProperty((Object)value, (String)arrArg[j]);
                            value = PropertyUtils.getProperty((Object)value, (String)arrArg[j + 1]);
                            ++j;
                        }
                    } else {
                        value = PropertyUtils.getProperty(element, (String)args[i]);
                    }
                    dataMap.put(args[i], this.fixValueForJSON(value));
                    ++i;
                }
                dataList.add(dataMap);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("totalRecords", list.size());
            jsonObject.put("data", (Object)JSONArray.fromObject(dataList));
            this.renderHtml(jsonObject.toString());
        }
        catch (Exception e) {
            this.writeJSONMsg(e.getMessage());
        }
    }

    private Object fixValueForJSON(Object value) {
        Object retObject = value;
        if (value instanceof Date) {
            retObject = new Timestamp(((Date)value).getTime());
        }
        return retObject;
    }

    public void writeJSONMsg(String msg) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msg", (Object)msg);
        jsonObject.put("totalRecords", 0);
        jsonObject.put("data", (Object)JSONArray.fromObject((Object)new String[0]));
        this.renderHtml(jsonObject.toString());
    }
}

