/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.bc.asn1;

import com.lowagie2.bc.asn1.ASN1OctetString;
import com.lowagie2.bc.asn1.ASN1TaggedObject;
import com.lowagie2.bc.asn1.DERObject;
import com.lowagie2.bc.asn1.DEROutputStream;
import com.lowagie2.bc.asn1.DERString;
import java.io.IOException;

public class DERBMPString
extends DERObject
implements DERString {
    String string;

    public DERBMPString(String string) {
        this.string = string;
    }

    public DERBMPString(byte[] string) {
        char[] cs = new char[string.length / 2];
        int i = 0;
        while (i != cs.length) {
            cs[i] = (char)(string[2 * i] << 8 | string[2 * i + 1] & 0xFF);
            ++i;
        }
        this.string = new String(cs);
    }

    void encode(DEROutputStream out) throws IOException {
        char[] c = this.string.toCharArray();
        byte[] b = new byte[c.length * 2];
        int i = 0;
        while (i != c.length) {
            b[2 * i] = (byte)(c[i] >> 8);
            b[2 * i + 1] = (byte)c[i];
            ++i;
        }
        out.writeEncoded(30, b);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DERBMPString)) {
            return false;
        }
        DERBMPString s = (DERBMPString)o;
        return this.getString().equals(s.getString());
    }

    public static DERBMPString getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERBMPString.getInstance(obj.getObject());
    }

    public static DERBMPString getInstance(Object obj) {
        if (obj == null || obj instanceof DERBMPString) {
            return (DERBMPString)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERBMPString(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERBMPString.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public String getString() {
        return this.string;
    }

    public int hashCode() {
        return this.getString().hashCode();
    }
}

