/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.bc.asn1;

import com.lowagie2.bc.asn1.ASN1OctetString;
import com.lowagie2.bc.asn1.ASN1OutputStream;
import com.lowagie2.bc.asn1.ASN1TaggedObject;
import com.lowagie2.bc.asn1.DEREncodable;
import com.lowagie2.bc.asn1.DERObject;
import com.lowagie2.bc.asn1.DEROutputStream;
import com.lowagie2.bc.asn1.DERString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERBitString
extends DERObject
implements DERString {
    protected byte[] data;
    protected int padBits;
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public DERBitString(DEREncodable obj) {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(obj);
            dOut.close();
            this.data = bOut.toByteArray();
            this.padBits = 0;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error processing object : " + e.toString());
        }
    }

    public DERBitString(byte[] data) {
        this(data, 0);
    }

    public DERBitString(byte[] data, int padBits) {
        this.data = data;
        this.padBits = padBits;
    }

    protected DERBitString(byte data, int padBits) {
        this.data = new byte[1];
        this.data[0] = data;
        this.padBits = padBits;
    }

    void encode(DEROutputStream out) throws IOException {
        byte[] bytes = new byte[this.getBytes().length + 1];
        bytes[0] = (byte)this.getPadBits();
        System.arraycopy(this.getBytes(), 0, bytes, 1, bytes.length - 1);
        out.writeEncoded(3, bytes);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERBitString)) {
            return false;
        }
        DERBitString other = (DERBitString)o;
        if (this.data.length != other.data.length) {
            return false;
        }
        int i = 0;
        while (i != this.data.length) {
            if (this.data[i] != other.data[i]) {
                return false;
            }
            ++i;
        }
        return this.padBits == other.padBits;
    }

    public byte[] getBytes() {
        return this.data;
    }

    protected static byte[] getBytes(int bitString) {
        int bytes = 4;
        int i = 3;
        while (i >= 1) {
            if ((bitString & 255 << i * 8) != 0) break;
            --bytes;
            --i;
        }
        byte[] result = new byte[bytes];
        int i2 = 0;
        while (i2 < bytes) {
            result[i2] = (byte)(bitString >> i2 * 8 & 0xFF);
            ++i2;
        }
        return result;
    }

    public static DERBitString getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERBitString.getInstance(obj.getObject());
    }

    public static DERBitString getInstance(Object obj) {
        if (obj == null || obj instanceof DERBitString) {
            return (DERBitString)obj;
        }
        if (obj instanceof ASN1OctetString) {
            byte[] bytes = ((ASN1OctetString)obj).getOctets();
            byte padBits = bytes[0];
            byte[] data = new byte[bytes.length - 1];
            System.arraycopy(bytes, 1, data, 0, bytes.length - 1);
            return new DERBitString(data, (int)padBits);
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERBitString.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public int getPadBits() {
        return this.padBits;
    }

    protected static int getPadBits(int bitString) {
        int val = 0;
        int i = 3;
        while (i >= 0) {
            if (i != 0) {
                if (bitString >> i * 8 != 0) {
                    val = bitString >> i * 8 & 0xFF;
                    break;
                }
            } else if (bitString != 0) {
                val = bitString & 0xFF;
                break;
            }
            --i;
        }
        if (val == 0) {
            return 7;
        }
        int bits = 1;
        while (((val <<= 1) & 0xFF) != 0) {
            ++bits;
        }
        return 8 - bits;
    }

    public String getString() {
        StringBuffer buf = new StringBuffer("#");
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            aOut.writeObject(this);
        }
        catch (IOException e) {
            throw new RuntimeException("internal error encoding BitString");
        }
        byte[] string = bOut.toByteArray();
        int i = 0;
        while (i != string.length) {
            buf.append(table[(string[i] >>> 4) % 15]);
            buf.append(table[string[i] & 0xF]);
            ++i;
        }
        return buf.toString();
    }

    public int hashCode() {
        int value = 0;
        int i = 0;
        while (i != this.data.length) {
            value ^= (this.data[i] & 0xFF) << i % 4;
            ++i;
        }
        return value;
    }
}

