/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.bc.asn1;

import com.lowagie2.bc.asn1.ASN1OctetString;
import com.lowagie2.bc.asn1.ASN1TaggedObject;
import com.lowagie2.bc.asn1.DERObject;
import com.lowagie2.bc.asn1.DEROutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class DERInteger
extends DERObject {
    byte[] bytes;

    public DERInteger(byte[] bytes) {
        this.bytes = bytes;
    }

    public DERInteger(BigInteger value) {
        this.bytes = value.toByteArray();
    }

    public DERInteger(int value) {
        this.bytes = BigInteger.valueOf(value).toByteArray();
    }

    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(2, this.bytes);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERInteger)) {
            return false;
        }
        DERInteger other = (DERInteger)o;
        if (this.bytes.length != other.bytes.length) {
            return false;
        }
        int i = 0;
        while (i != this.bytes.length) {
            if (this.bytes[i] != other.bytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static DERInteger getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERInteger.getInstance(obj.getObject());
    }

    public static DERInteger getInstance(Object obj) {
        if (obj == null || obj instanceof DERInteger) {
            return (DERInteger)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERInteger(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERInteger.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.bytes);
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    public int hashCode() {
        int value = 0;
        int i = 0;
        while (i != this.bytes.length) {
            value ^= (this.bytes[i] & 0xFF) << i % 4;
            ++i;
        }
        return value;
    }
}

