/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text;

import com.lowagie2.text.Chunk;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Element;
import com.lowagie2.text.ElementListener;
import com.lowagie2.text.ElementTags;
import com.lowagie2.text.MarkupAttributes;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;

public class Annotation
implements Element,
MarkupAttributes {
    public static String APPLICATION;
    public static String CONTENT;
    public static String DEFAULTDIR;
    public static String DESTINATION;
    public static String FILE;
    public static final int FILE_DEST = 3;
    public static final int FILE_PAGE = 4;
    public static final int LAUNCH = 6;
    public static String LLX;
    public static String LLY;
    public static String MIMETYPE;
    public static String NAMED;
    public static final int NAMED_DEST = 5;
    public static String OPERATION;
    public static String PAGE;
    public static String PARAMETERS;
    public static final int SCREEN = 7;
    public static final int TEXT = 0;
    public static String TITLE;
    public static String URL;
    public static final int URL_AS_STRING = 2;
    public static final int URL_NET = 1;
    public static String URX;
    public static String URY;
    protected HashMap annotationAttributes = new HashMap();
    protected int annotationtype;
    protected float llx = Float.NaN;
    protected float lly = Float.NaN;
    protected Properties markupAttributes = null;
    protected float urx = Float.NaN;
    protected float ury = Float.NaN;

    static {
        TITLE = "title";
        CONTENT = "content";
        URL = "url";
        FILE = "file";
        DESTINATION = "destination";
        PAGE = "page";
        NAMED = "named";
        APPLICATION = "application";
        PARAMETERS = "parameters";
        OPERATION = "operation";
        DEFAULTDIR = "defaultdir";
        LLX = "llx";
        LLY = "lly";
        URX = "urx";
        URY = "ury";
        MIMETYPE = "mime";
    }

    public Annotation(Properties attributes) {
        String value = (String)attributes.remove(ElementTags.LLX);
        if (value != null) {
            this.llx = Float.valueOf(value + "f").floatValue();
        }
        if ((value = (String)attributes.remove(ElementTags.LLY)) != null) {
            this.lly = Float.valueOf(value + "f").floatValue();
        }
        if ((value = (String)attributes.remove(ElementTags.URX)) != null) {
            this.urx = Float.valueOf(value + "f").floatValue();
        }
        if ((value = (String)attributes.remove(ElementTags.URY)) != null) {
            this.ury = Float.valueOf(value + "f").floatValue();
        }
        String title = (String)attributes.remove("title");
        String text = (String)attributes.remove("content");
        if (title != null || text != null) {
            this.annotationtype = 0;
        } else {
            value = (String)attributes.remove("url");
            if (value != null) {
                this.annotationtype = 2;
                this.annotationAttributes.put(FILE, value);
            } else {
                value = (String)attributes.remove(ElementTags.NAMED);
                if (value != null) {
                    this.annotationtype = 5;
                    this.annotationAttributes.put(NAMED, Integer.valueOf(value));
                } else {
                    String file = (String)attributes.remove(ElementTags.FILE);
                    String destination = (String)attributes.remove(ElementTags.DESTINATION);
                    String page = (String)attributes.remove(ElementTags.PAGE);
                    if (file != null) {
                        this.annotationAttributes.put(FILE, file);
                        if (destination != null) {
                            this.annotationtype = 3;
                            this.annotationAttributes.put(DESTINATION, destination);
                        } else if (page != null) {
                            this.annotationtype = 4;
                            this.annotationAttributes.put(FILE, file);
                            this.annotationAttributes.put(PAGE, Integer.valueOf(page));
                        }
                    } else {
                        value = (String)attributes.remove(ElementTags.NAMED);
                        if (value != null) {
                            this.annotationtype = 6;
                            this.annotationAttributes.put(APPLICATION, value);
                            this.annotationAttributes.put(PARAMETERS, attributes.remove(ElementTags.PARAMETERS));
                            this.annotationAttributes.put(OPERATION, attributes.remove(ElementTags.OPERATION));
                            this.annotationAttributes.put(DEFAULTDIR, attributes.remove(ElementTags.DEFAULTDIR));
                        }
                    }
                }
            }
        }
        if (this.annotationtype == 0) {
            if (title == null) {
                title = "";
            }
            if (text == null) {
                text = "";
            }
            this.annotationAttributes.put(TITLE, title);
            this.annotationAttributes.put(CONTENT, text);
        }
        if (attributes.size() > 0) {
            this.setMarkupAttributes(attributes);
        }
    }

    public Annotation(float llx, float lly, float urx, float ury, String application, String parameters, String operation, String defaultdir) {
        this(llx, lly, urx, ury);
        this.annotationtype = 6;
        this.annotationAttributes.put(APPLICATION, application);
        this.annotationAttributes.put(PARAMETERS, parameters);
        this.annotationAttributes.put(OPERATION, operation);
        this.annotationAttributes.put(DEFAULTDIR, defaultdir);
    }

    public Annotation(float llx, float lly, float urx, float ury, int named) {
        this(llx, lly, urx, ury);
        this.annotationtype = 5;
        this.annotationAttributes.put(NAMED, new Integer(named));
    }

    public Annotation(float llx, float lly, float urx, float ury, String file, int page) {
        this(llx, lly, urx, ury);
        this.annotationtype = 4;
        this.annotationAttributes.put(FILE, file);
        this.annotationAttributes.put(PAGE, new Integer(page));
    }

    public Annotation(float llx, float lly, float urx, float ury, String moviePath, String mimeType, boolean showOnDisplay) {
        this(llx, lly, urx, ury);
        this.annotationtype = 7;
        this.annotationAttributes.put(FILE, moviePath);
        this.annotationAttributes.put(MIMETYPE, mimeType);
        this.annotationAttributes.put(PARAMETERS, new boolean[]{false, showOnDisplay});
    }

    public Annotation(float llx, float lly, float urx, float ury, String file, String dest) {
        this(llx, lly, urx, ury);
        this.annotationtype = 3;
        this.annotationAttributes.put(FILE, file);
        this.annotationAttributes.put(DESTINATION, dest);
    }

    public Annotation(float llx, float lly, float urx, float ury, String url) {
        this(llx, lly, urx, ury);
        this.annotationtype = 2;
        this.annotationAttributes.put(FILE, url);
    }

    public Annotation(float llx, float lly, float urx, float ury, URL url) {
        this(llx, lly, urx, ury);
        this.annotationtype = 1;
        this.annotationAttributes.put(URL, url);
    }

    public Annotation(String title, String text, float llx, float lly, float urx, float ury) {
        this(llx, lly, urx, ury);
        this.annotationtype = 0;
        this.annotationAttributes.put(TITLE, title);
        this.annotationAttributes.put(CONTENT, text);
    }

    public Annotation(String title, String text) {
        this.annotationtype = 0;
        this.annotationAttributes.put(TITLE, title);
        this.annotationAttributes.put(CONTENT, text);
    }

    public Annotation(Annotation an) {
        this.annotationtype = an.annotationtype;
        this.annotationAttributes = an.annotationAttributes;
        this.markupAttributes = an.markupAttributes;
        this.llx = an.llx;
        this.lly = an.lly;
        this.urx = an.urx;
        this.ury = an.ury;
    }

    private Annotation(float llx, float lly, float urx, float ury) {
        this.llx = llx;
        this.lly = lly;
        this.urx = urx;
        this.ury = ury;
    }

    public int annotationType() {
        return this.annotationtype;
    }

    public HashMap attributes() {
        return this.annotationAttributes;
    }

    public String content() {
        String s = (String)this.annotationAttributes.get(CONTENT);
        if (s == null) {
            s = "";
        }
        return s;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public String getMarkupAttribute(String name) {
        return this.markupAttributes == null ? null : String.valueOf(this.markupAttributes.get(name));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }

    public static boolean isTag(String tag) {
        return "annotation".equals(tag);
    }

    public float llx(float def) {
        if (Float.isNaN(this.llx)) {
            return def;
        }
        return this.llx;
    }

    public float llx() {
        return this.llx;
    }

    public float lly(float def) {
        if (Float.isNaN(this.lly)) {
            return def;
        }
        return this.lly;
    }

    public float lly() {
        return this.lly;
    }

    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    public void setDimensions(float llx, float lly, float urx, float ury) {
        this.llx = llx;
        this.lly = lly;
        this.urx = urx;
        this.ury = ury;
    }

    public void setMarkupAttribute(String name, String value) {
        if (this.markupAttributes == null) {
            this.markupAttributes = new Properties();
        }
        this.markupAttributes.put(name, value);
    }

    public void setMarkupAttributes(Properties markupAttributes) {
        this.markupAttributes = markupAttributes;
    }

    public String title() {
        String s = (String)this.annotationAttributes.get(TITLE);
        if (s == null) {
            s = "";
        }
        return s;
    }

    public int type() {
        return 29;
    }

    public float urx(float def) {
        if (Float.isNaN(this.urx)) {
            return def;
        }
        return this.urx;
    }

    public float urx() {
        return this.urx;
    }

    public float ury(float def) {
        if (Float.isNaN(this.ury)) {
            return def;
        }
        return this.ury;
    }

    public float ury() {
        return this.ury;
    }
}

