/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text;

import com.lowagie2.text.BadElementException;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Element;
import com.lowagie2.text.Image;
import com.lowagie2.text.PageSize;
import com.lowagie2.text.pdf.PdfTemplate;
import com.lowagie2.text.pdf.codec.postscript.MetaDoPS;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class ImgPostscript
extends Image
implements Element {
    public ImgPostscript(byte[] img) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = img;
        this.originalData = img;
        this.processParameters();
    }

    public ImgPostscript(String filename) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(filename));
    }

    public ImgPostscript(URL url) throws BadElementException, IOException {
        super(url);
        this.processParameters();
    }

    public ImgPostscript(byte[] content, float width, float height) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = content;
        this.originalData = content;
        this.processParameters();
        this.urx = width;
        this.ury = height;
    }

    ImgPostscript(Image image) {
        super(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void processParameters() throws BadElementException, IOException {
        this.type = 35;
        this.originalType = 7;
        InputStream is = null;
        try {
            is = this.rawData == null ? this.url.openStream() : new ByteArrayInputStream(this.rawData);
            String boundingbox = null;
            String templatebox = null;
            BufferedReader r = new BufferedReader(new InputStreamReader(is));
            while (((Reader)r).ready()) {
                char c;
                StringBuffer sb = new StringBuffer();
                while ((c = (char)((Reader)r).read()) != '\n' && c != '\r') {
                    void var5_5;
                    sb.append((char)var5_5);
                }
                if (sb.toString().startsWith("%%BoundingBox:")) {
                    boundingbox = sb.toString();
                }
                if (sb.toString().startsWith("%%TemplateBox:")) {
                    templatebox = sb.toString();
                }
                if (sb.toString().startsWith("%%EndComments") || !sb.toString().startsWith("%%") && !sb.toString().startsWith("%!")) break;
            }
            if (boundingbox == null) {
                this.scaledHeight = PageSize.A4.height();
                this.setTop(this.scaledHeight);
                this.scaledWidth = PageSize.A4.width();
                this.setRight(this.scaledWidth);
                return;
            }
            StringTokenizer st = new StringTokenizer(boundingbox, ": \r\n");
            st.nextElement();
            String xx1 = st.nextToken();
            String yy1 = st.nextToken();
            String xx2 = st.nextToken();
            String yy2 = st.nextToken();
            int left = Integer.parseInt(xx1);
            int bottom = Integer.parseInt(yy1);
            int right = Integer.parseInt(xx2);
            int top = Integer.parseInt(yy2);
            boolean inch = true;
            this.dpiX = 72;
            this.dpiY = 72;
            this.scaledHeight = (float)(top - bottom) / (float)inch * 1.0f;
            this.setTop(top);
            this.scaledWidth = (float)(right - left) / (float)inch * 1.0f;
            this.setRight(right);
        }
        finally {
            if (is != null) {
                is.close();
            }
            this.plainWidth = this.width();
            this.plainHeight = this.height();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readPostscript(PdfTemplate template) throws IOException, DocumentException {
        this.setTemplateData(template);
        template.setWidth(this.width());
        template.setHeight(this.height());
        InputStream is = null;
        try {
            is = this.rawData == null ? this.url.openStream() : new ByteArrayInputStream(this.rawData);
            MetaDoPS meta = new MetaDoPS(is, template);
            meta.readAll();
            Object var5_4 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (is == null) throw throwable;
            is.close();
            throw throwable;
        }
        is.close();
    }
}

