/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text;

import com.lowagie2.text.Chunk;
import com.lowagie2.text.Font;
import com.lowagie2.text.FontFactory;
import com.lowagie2.text.MarkupAttributes;
import com.lowagie2.text.Paragraph;
import com.lowagie2.text.Phrase;
import com.lowagie2.text.TextElementArray;
import com.lowagie2.text.markup.MarkupParser;
import java.util.Properties;

public class ListItem
extends Paragraph
implements TextElementArray,
MarkupAttributes {
    private Chunk symbol;

    public ListItem(Properties attributes) {
        super("", FontFactory.getFont(attributes));
        String value = (String)attributes.remove("itext");
        if (value != null) {
            this.add(new Chunk(value));
        }
        if ((value = (String)attributes.remove("leading")) != null) {
            this.setLeading(Float.valueOf(value + "f").floatValue());
        } else {
            value = (String)attributes.remove("line-height");
            if (value != null) {
                this.setLeading(MarkupParser.parseLength(value));
            }
        }
        value = (String)attributes.remove("indentationleft");
        if (value != null) {
            this.setIndentationLeft(Float.valueOf(value + "f").floatValue());
        }
        if ((value = (String)attributes.remove("indentationright")) != null) {
            this.setIndentationRight(Float.valueOf(value + "f").floatValue());
        }
        if ((value = (String)attributes.remove("align")) != null) {
            this.setAlignment(value);
        }
        if (attributes.size() > 0) {
            this.setMarkupAttributes(attributes);
        }
    }

    public ListItem(Phrase phrase) {
        super(phrase);
    }

    public ListItem(float leading, String string, Font font) {
        super(leading, string, font);
    }

    public ListItem(float leading, String string) {
        super(leading, string);
    }

    public ListItem(float leading, Chunk chunk) {
        super(leading, chunk);
    }

    public ListItem(String string, Font font) {
        super(string, font);
    }

    public ListItem(String string) {
        super(string);
    }

    public ListItem(Chunk chunk) {
        super(chunk);
    }

    public ListItem(float leading) {
        super(leading);
    }

    public ListItem() {
    }

    public static boolean isTag(String tag) {
        return "listitem".equals(tag);
    }

    public Chunk listSymbol() {
        return this.symbol;
    }

    public void setListSymbol(Chunk symbol) {
        if (this.symbol == null) {
            this.symbol = symbol;
            if (this.symbol.font().isStandardFont()) {
                this.symbol.setFont(this.font);
            }
        }
    }

    public int type() {
        return 15;
    }
}

