/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text;

import com.lowagie2.text.Chunk;
import com.lowagie2.text.ElementTags;
import com.lowagie2.text.Font;
import com.lowagie2.text.FontFactory;
import com.lowagie2.text.Image;
import com.lowagie2.text.List;
import com.lowagie2.text.MarkupAttributes;
import com.lowagie2.text.Phrase;
import com.lowagie2.text.TextElementArray;
import com.lowagie2.text.markup.MarkupParser;
import java.util.Properties;

public class Paragraph
extends Phrase
implements TextElementArray,
MarkupAttributes {
    protected int alignment = -1;
    private float extraParagraphSpace = 0.0f;
    private float firstLineIndent = 0.0f;
    protected float indentationLeft;
    protected float indentationRight;
    protected boolean keeptogether = false;
    protected float multipliedLeading = 0.0f;
    protected float spacingAfter;
    protected float spacingBefore;

    public Paragraph(Properties attributes) {
        this("", FontFactory.getFont(attributes));
        String value = (String)attributes.remove("itext");
        if (value != null) {
            Chunk chunk = new Chunk(value);
            value = (String)attributes.remove(ElementTags.GENERICTAG);
            if (value != null) {
                chunk.setGenericTag(value);
            }
            this.add(chunk);
        }
        if ((value = (String)attributes.remove("align")) != null) {
            this.setAlignment(value);
        }
        if ((value = (String)attributes.remove("leading")) != null) {
            this.setLeading(Float.valueOf(value + "f").floatValue());
        } else {
            value = (String)attributes.remove("line-height");
            if (value != null) {
                this.setLeading(MarkupParser.parseLength(value));
            } else {
                this.setLeading(16.0f);
            }
        }
        value = (String)attributes.remove("indentationleft");
        if (value != null) {
            this.setIndentationLeft(Float.valueOf(value + "f").floatValue());
        }
        if ((value = (String)attributes.remove("indentationright")) != null) {
            this.setIndentationRight(Float.valueOf(value + "f").floatValue());
        }
        if ((value = (String)attributes.remove("keeptogether")) != null) {
            this.keeptogether = new Boolean(value);
        }
        if (attributes.size() > 0) {
            this.setMarkupAttributes(attributes);
        }
    }

    public Paragraph(Phrase phrase) {
        super(phrase.leading, "", phrase.font());
        super.add(phrase);
    }

    public Paragraph(float leading, String string, Font font) {
        super(leading, string, font);
    }

    public Paragraph(float leading, String string) {
        super(leading, string);
    }

    public Paragraph(String string, Font font) {
        super(string, font);
    }

    public Paragraph(String string) {
        super(string);
    }

    public Paragraph(float leading, Chunk chunk) {
        super(leading, chunk);
    }

    public Paragraph(Chunk chunk) {
        super(chunk);
    }

    public Paragraph(float leading) {
        super(leading);
    }

    public Paragraph() {
    }

    public boolean add(Object o) {
        if (o instanceof List) {
            List list = (List)o;
            list.setIndentationLeft(list.indentationLeft() + this.indentationLeft);
            list.setIndentationRight(this.indentationRight);
            return super.add(list);
        }
        if (o instanceof Image) {
            super.addSpecial((Image)o);
            return true;
        }
        if (o instanceof Paragraph) {
            super.add(o);
            super.add(Chunk.NEWLINE);
            return true;
        }
        return super.add(o);
    }

    public int alignment() {
        return this.alignment;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public float getFirstLineIndent() {
        return this.firstLineIndent;
    }

    public boolean getKeepTogether() {
        return this.keeptogether;
    }

    public float getMultipliedLeading() {
        return this.multipliedLeading;
    }

    public float indentationLeft() {
        return this.indentationLeft;
    }

    public float indentationRight() {
        return this.indentationRight;
    }

    public static boolean isTag(String tag) {
        return "paragraph".equals(tag);
    }

    public void setAlignment(String alignment) {
        if ("Center".equalsIgnoreCase(alignment)) {
            this.alignment = 1;
            return;
        }
        if ("Right".equalsIgnoreCase(alignment)) {
            this.alignment = 2;
            return;
        }
        if ("Justify".equalsIgnoreCase(alignment)) {
            this.alignment = 3;
            return;
        }
        if ("JustifyAll".equalsIgnoreCase(alignment)) {
            this.alignment = 8;
            return;
        }
        this.alignment = 0;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setExtraParagraphSpace(float extraParagraphSpace) {
        this.extraParagraphSpace = extraParagraphSpace;
    }

    public void setFirstLineIndent(float firstLineIndent) {
        this.firstLineIndent = firstLineIndent;
    }

    public void setIndentationLeft(float indentation) {
        this.indentationLeft = indentation;
    }

    public void setIndentationRight(float indentation) {
        this.indentationRight = indentation;
    }

    public void setKeepTogether(boolean keeptogether) {
        this.keeptogether = keeptogether;
    }

    public void setLeading(float fixedLeading) {
        this.leading = fixedLeading;
        this.multipliedLeading = 0.0f;
    }

    public void setLeading(float fixedLeading, float multipliedLeading) {
        this.leading = fixedLeading;
        this.multipliedLeading = multipliedLeading;
    }

    public void setSpacingAfter(float spacing) {
        this.spacingAfter = spacing;
    }

    public void setSpacingBefore(float spacing) {
        this.spacingBefore = spacing;
    }

    public float spacingAfter() {
        return this.spacingAfter;
    }

    public float spacingBefore() {
        return this.spacingBefore;
    }

    public int type() {
        return 12;
    }
}

