/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text;

import com.lowagie2.text.Cell;
import com.lowagie2.text.Chunk;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Element;
import com.lowagie2.text.ElementListener;
import com.lowagie2.text.MarkupAttributes;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;

public class Row
implements Element,
MarkupAttributes {
    public static final int CELL = 1;
    public static final int NULL = 0;
    public static final int TABLE = 2;
    protected Object[] cells;
    static /* synthetic */ Class class$com$lowagie2$text$Cell;
    static /* synthetic */ Class class$com$lowagie2$text$Table;
    protected int columns;
    protected int currentColumn;
    protected int height = 0;
    protected int horizontalAlignment;
    protected Properties markupAttributes;
    protected boolean[] reserved;
    protected int verticalAlignment;

    protected Row(int columns) {
        this.columns = columns;
        this.reserved = new boolean[columns];
        this.cells = new Object[columns];
        this.currentColumn = 0;
    }

    int addElement(Object element, int column) {
        int lColspan;
        if (element == null) {
            throw new NullPointerException("addCell - null argument");
        }
        if (column < 0 || column > this.columns) {
            throw new IndexOutOfBoundsException("addCell - illegal column argument");
        }
        if (this.getObjectID(element) != 1 && this.getObjectID(element) != 2) {
            throw new IllegalArgumentException("addCell - only Cells or Tables allowed");
        }
        int n = lColspan = (class$com$lowagie2$text$Cell == null ? (class$com$lowagie2$text$Cell = Row.class$("com.lowagie2.text.Cell")) : class$com$lowagie2$text$Cell).isInstance(element) ? ((Cell)element).colspan() : 1;
        if (!this.reserve(column, lColspan)) {
            return -1;
        }
        this.cells[column] = element;
        this.currentColumn += lColspan - 1;
        return column;
    }

    int addElement(Object element) {
        return this.addElement(element, this.currentColumn);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public int columns() {
        return this.columns;
    }

    void deleteColumn(int column) {
        if (column >= this.columns || column < 0) {
            throw new IndexOutOfBoundsException("getCell at illegal index : " + column);
        }
        --this.columns;
        boolean[] newReserved = new boolean[this.columns];
        Cell[] newCells = new Cell[this.columns];
        int i = 0;
        while (i < column) {
            newReserved[i] = this.reserved[i];
            newCells[i] = this.cells[i];
            if (newCells[i] != null && i + newCells[i].colspan() > column) {
                newCells[i].setColspan(((Cell)this.cells[i]).colspan() - 1);
            }
            ++i;
        }
        int i2 = column;
        while (i2 < this.columns) {
            newReserved[i2] = this.reserved[i2 + 1];
            newCells[i2] = this.cells[i2 + 1];
            ++i2;
        }
        if (this.cells[column] != null && ((Cell)this.cells[column]).colspan() > 1) {
            newCells[column] = this.cells[column];
            newCells[column].setColspan(newCells[column].colspan() - 1);
        }
        this.reserved = newReserved;
        this.cells = newCells;
    }

    public Object getCell(int column) {
        if (column < 0 || column > this.columns) {
            throw new IndexOutOfBoundsException("getCell at illegal index :" + column + " max is " + this.columns);
        }
        return this.cells[column];
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    int getElementID(int column) {
        if (this.cells[column] == null) {
            return 0;
        }
        if ((class$com$lowagie2$text$Cell == null ? (class$com$lowagie2$text$Cell = Row.class$("com.lowagie2.text.Cell")) : class$com$lowagie2$text$Cell).isInstance(this.cells[column])) {
            return 1;
        }
        if ((class$com$lowagie2$text$Table == null ? (class$com$lowagie2$text$Table = Row.class$("com.lowagie2.text.Table")) : class$com$lowagie2$text$Table).isInstance(this.cells[column])) {
            return 2;
        }
        return -1;
    }

    public int getHeight() {
        return this.height;
    }

    public String getMarkupAttribute(String name) {
        return this.markupAttributes == null ? null : String.valueOf(this.markupAttributes.get(name));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }

    int getObjectID(Object element) {
        if (element == null) {
            return 0;
        }
        if ((class$com$lowagie2$text$Cell == null ? (class$com$lowagie2$text$Cell = Row.class$("com.lowagie2.text.Cell")) : class$com$lowagie2$text$Cell).isInstance(element)) {
            return 1;
        }
        if ((class$com$lowagie2$text$Table == null ? (class$com$lowagie2$text$Table = Row.class$("com.lowagie2.text.Table")) : class$com$lowagie2$text$Table).isInstance(element)) {
            return 2;
        }
        return -1;
    }

    public int horizontalAlignment() {
        return this.horizontalAlignment;
    }

    public boolean isEmpty() {
        int i = 0;
        while (i < this.columns) {
            if (this.cells[i] != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean isReserved(int column) {
        return this.reserved[column];
    }

    public static boolean isTag(String tag) {
        return "row".equals(tag);
    }

    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    boolean reserve(int column, int size) {
        if (column < 0 || column + size > this.columns) {
            throw new IndexOutOfBoundsException("reserve - incorrect column/size");
        }
        int i = column;
        while (i < column + size) {
            if (this.reserved[i]) {
                int j = i;
                while (j >= column) {
                    this.reserved[j] = false;
                    --j;
                }
                return false;
            }
            this.reserved[i] = true;
            ++i;
        }
        return true;
    }

    boolean reserve(int column) {
        return this.reserve(column, 1);
    }

    void setElement(Object aElement, int column) {
        if (this.reserved[column]) {
            throw new IllegalArgumentException("setElement - position already taken");
        }
        this.cells[column] = aElement;
        if (aElement != null) {
            this.reserved[column] = true;
        }
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setHorizontalAlignment(int value) {
        this.horizontalAlignment = value;
    }

    public void setMarkupAttribute(String name, String value) {
        if (this.markupAttributes == null) {
            this.markupAttributes = new Properties();
        }
        this.markupAttributes.put(name, value);
    }

    public void setMarkupAttributes(Properties markupAttributes) {
        this.markupAttributes = markupAttributes;
    }

    public void setVerticalAlignment(int value) {
        this.verticalAlignment = value;
    }

    public int type() {
        return 21;
    }

    int validPosition() {
        return this.currentColumn;
    }

    public int verticalAlignment() {
        return this.verticalAlignment;
    }
}

