/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.ExceptionConverter;
import com.lowagie2.text.Image;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.pdf.BaseFont;
import com.lowagie2.text.pdf.PdfContentByte;
import com.lowagie2.text.pdf.PdfTemplate;
import java.awt.Color;

public abstract class Barcode {
    public static final int CODABAR = 12;
    public static final int CODE128 = 9;
    public static final int CODE128_RAW = 11;
    public static final int CODE128_UCC = 10;
    public static final int EAN13 = 1;
    public static final int EAN8 = 2;
    public static final int PLANET = 8;
    public static final int POSTNET = 7;
    public static final int SUPP2 = 5;
    public static final int SUPP5 = 6;
    public static final int UPCA = 3;
    public static final int UPCE = 4;
    protected String altText;
    protected float barHeight;
    protected float baseline;
    protected boolean checksumText;
    protected String code = "";
    protected int codeType;
    protected boolean extended;
    protected BaseFont font;
    protected boolean generateChecksum;
    protected boolean guardBars;
    protected float inkSpreading = 0.0f;
    protected float n;
    protected float size;
    protected boolean startStopText;
    protected int textAlignment;
    protected float x;

    public abstract java.awt.Image createAwtImage(Color var1, Color var2);

    public Image createImageWithBarcode(PdfContentByte cb, Color barColor, Color textColor) {
        try {
            return Image.getInstance(this.createTemplateWithBarcode(cb, barColor, textColor));
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public PdfTemplate createTemplateWithBarcode(PdfContentByte cb, Color barColor, Color textColor) {
        PdfTemplate tp = cb.createTemplate(0.0f, 0.0f);
        Rectangle rect = this.placeBarcode(tp, barColor, textColor);
        tp.setBoundingBox(rect);
        return tp;
    }

    public String getAltText() {
        return this.altText;
    }

    public float getBarHeight() {
        return this.barHeight;
    }

    public abstract Rectangle getBarcodeSize();

    public float getBaseline() {
        return this.baseline;
    }

    public String getCode() {
        return this.code;
    }

    public int getCodeType() {
        return this.codeType;
    }

    public BaseFont getFont() {
        return this.font;
    }

    public float getInkSpreading() {
        return this.inkSpreading;
    }

    public float getN() {
        return this.n;
    }

    public float getSize() {
        return this.size;
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    public float getX() {
        return this.x;
    }

    public boolean isChecksumText() {
        return this.checksumText;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean isGenerateChecksum() {
        return this.generateChecksum;
    }

    public boolean isGuardBars() {
        return this.guardBars;
    }

    public boolean isStartStopText() {
        return this.startStopText;
    }

    public abstract Rectangle placeBarcode(PdfContentByte var1, Color var2, Color var3);

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public void setBarHeight(float barHeight) {
        this.barHeight = barHeight;
    }

    public void setBaseline(float baseline) {
        this.baseline = baseline;
    }

    public void setChecksumText(boolean checksumText) {
        this.checksumText = checksumText;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setCodeType(int codeType) {
        this.codeType = codeType;
    }

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public void setFont(BaseFont font) {
        this.font = font;
    }

    public void setGenerateChecksum(boolean generateChecksum) {
        this.generateChecksum = generateChecksum;
    }

    public void setGuardBars(boolean guardBars) {
        this.guardBars = guardBars;
    }

    public void setInkSpreading(float inkSpreading) {
    }

    public void setN(float n) {
        this.n = n;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public void setStartStopText(boolean startStopText) {
        this.startStopText = startStopText;
    }

    public void setTextAlignment(int textAlignment) {
        this.textAlignment = textAlignment;
    }

    public void setX(float x) {
        this.x = x;
    }
}

