/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.ExceptionConverter;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.pdf.Barcode;
import com.lowagie2.text.pdf.BaseFont;
import com.lowagie2.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;

public class BarcodeEAN
extends Barcode {
    static byte[][] BARS;
    static final int EVEN = 1;
    static int[] GUARD_EAN13;
    static int[] GUARD_EAN8;
    static int[] GUARD_EMPTY;
    static int[] GUARD_UPCA;
    static int[] GUARD_UPCE;
    static final int ODD = 0;
    static byte[][] PARITY13;
    static byte[][] PARITY2;
    static byte[][] PARITY5;
    static byte[][] PARITYE;
    static float[] TEXTPOS_EAN13;
    static float[] TEXTPOS_EAN8;
    static final int TOTALBARS_EAN13 = 59;
    static final int TOTALBARS_EAN8 = 43;
    static final int TOTALBARS_SUPP2 = 13;
    static final int TOTALBARS_SUPP5 = 31;
    static final int TOTALBARS_UPCE = 33;

    static {
        GUARD_EMPTY = new int[0];
        GUARD_UPCA = new int[]{0, 2, 4, 6, 28, 30, 52, 54, 56, 58};
        GUARD_EAN13 = new int[]{0, 2, 28, 30, 56, 58};
        GUARD_EAN8 = new int[]{0, 2, 20, 22, 40, 42};
        GUARD_UPCE = new int[]{0, 2, 28, 30, 32};
        TEXTPOS_EAN13 = new float[]{6.5f, 13.5f, 20.5f, 27.5f, 34.5f, 41.5f, 53.5f, 60.5f, 67.5f, 74.5f, 81.5f, 88.5f};
        TEXTPOS_EAN8 = new float[]{6.5f, 13.5f, 20.5f, 27.5f, 39.5f, 46.5f, 53.5f, 60.5f};
        BARS = new byte[][]{{3, 2, 1, 1}, {2, 2, 2, 1}, {2, 1, 2, 2}, {1, 4, 1, 1}, {1, 1, 3, 2}, {1, 2, 3, 1}, {1, 1, 1, 4}, {1, 3, 1, 2}, {1, 2, 1, 3}, {3, 1, 1, 2}};
        PARITY13 = new byte[][]{{0, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 1, 1}, {0, 0, 1, 1, 0, 1}, {0, 0, 1, 1, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 1, 0, 0, 1}, {0, 1, 1, 1, 0, 0}, {0, 1, 0, 1, 0, 1}, {0, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 0}};
        PARITY2 = new byte[][]{{0, 0}, {0, 1}, {1, 0}, {1, 1}};
        PARITY5 = new byte[][]{{1, 1, 0, 0, 0}, {1, 0, 1, 0, 0}, {1, 0, 0, 1, 0}, {1, 0, 0, 0, 1}, {0, 1, 1, 0, 0}, {0, 0, 1, 1, 0}, {0, 0, 0, 1, 1}, {0, 1, 0, 1, 0}, {0, 1, 0, 0, 1}, {0, 0, 1, 0, 1}};
        PARITYE = new byte[][]{{1, 1, 1, 0, 0, 0}, {1, 1, 0, 1, 0, 0}, {1, 1, 0, 0, 1, 0}, {1, 1, 0, 0, 0, 1}, {1, 0, 1, 1, 0, 0}, {1, 0, 0, 1, 1, 0}, {1, 0, 0, 0, 1, 1}, {1, 0, 1, 0, 1, 0}, {1, 0, 1, 0, 0, 1}, {1, 0, 0, 1, 0, 1}};
    }

    public BarcodeEAN() {
        try {
            this.x = 0.8f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.guardBars = true;
            this.codeType = 1;
            this.code = "";
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static int calculateEANParity(String code) {
        int mul = 3;
        int total = 0;
        int k = code.length() - 1;
        while (k >= 0) {
            int n = code.charAt(k) - 48;
            total += mul * n;
            mul ^= 2;
            --k;
        }
        return (10 - total % 10) % 10;
    }

    public static String convertUPCAtoUPCE(String text) {
        if (text.length() != 12 || !text.startsWith("0") && !text.startsWith("1")) {
            return null;
        }
        if (text.substring(3, 6).equals("000") || text.substring(3, 6).equals("100") || text.substring(3, 6).equals("200")) {
            if (text.substring(6, 8).equals("00")) {
                return text.substring(0, 1) + text.substring(1, 3) + text.substring(8, 11) + text.substring(3, 4) + text.substring(11);
            }
        } else if (text.substring(4, 6).equals("00")) {
            if (text.substring(6, 9).equals("000")) {
                return text.substring(0, 1) + text.substring(1, 4) + text.substring(9, 11) + "3" + text.substring(11);
            }
        } else if (text.substring(5, 6).equals("0")) {
            if (text.substring(6, 10).equals("0000")) {
                return text.substring(0, 1) + text.substring(1, 5) + text.substring(10, 11) + "4" + text.substring(11);
            }
        } else if (text.charAt(10) >= '5' && text.substring(6, 10).equals("0000")) {
            return text.substring(0, 1) + text.substring(1, 6) + text.substring(10, 11) + text.substring(11);
        }
        return null;
    }

    public Image createAwtImage(Color foreground, Color background) {
        int f = foreground.getRGB();
        int g = background.getRGB();
        Canvas canvas = new Canvas();
        int width = 0;
        byte[] bars = null;
        switch (this.codeType) {
            case 1: {
                bars = BarcodeEAN.getBarsEAN13(this.code);
                width = 95;
                break;
            }
            case 2: {
                bars = BarcodeEAN.getBarsEAN8(this.code);
                width = 67;
                break;
            }
            case 3: {
                bars = BarcodeEAN.getBarsEAN13("0" + this.code);
                width = 95;
                break;
            }
            case 4: {
                bars = BarcodeEAN.getBarsUPCE(this.code);
                width = 51;
                break;
            }
            case 5: {
                bars = BarcodeEAN.getBarsSupplemental2(this.code);
                width = 20;
                break;
            }
            case 6: {
                bars = BarcodeEAN.getBarsSupplemental5(this.code);
                width = 47;
                break;
            }
            default: {
                throw new RuntimeException("Invalid code type.");
            }
        }
        boolean print = true;
        int ptr = 0;
        int height = (int)this.barHeight;
        int[] pix = new int[width * height];
        int k = 0;
        while (k < bars.length) {
            int w = bars[k];
            int c = g;
            if (print) {
                c = f;
            }
            print = !print;
            int j = 0;
            while (j < w) {
                pix[ptr++] = c;
                ++j;
            }
            ++k;
        }
        int k2 = width;
        while (k2 < pix.length) {
            System.arraycopy(pix, 0, pix, k2, width);
            k2 += width;
        }
        Image img = canvas.createImage(new MemoryImageSource(width, height, pix, 0, width));
        return img;
    }

    public Rectangle getBarcodeSize() {
        float width = 0.0f;
        float height = this.barHeight;
        if (this.font != null) {
            height = this.baseline <= 0.0f ? (height += -this.baseline + this.size) : (height += this.baseline - this.font.getFontDescriptor(3, this.size));
        }
        switch (this.codeType) {
            case 1: {
                width = this.x * 95.0f;
                if (this.font == null) break;
                width += this.font.getWidthPoint(this.code.charAt(0), this.size);
                break;
            }
            case 2: {
                width = this.x * 67.0f;
                break;
            }
            case 3: {
                width = this.x * 95.0f;
                if (this.font == null) break;
                width += this.font.getWidthPoint(this.code.charAt(0), this.size) + this.font.getWidthPoint(this.code.charAt(11), this.size);
                break;
            }
            case 4: {
                width = this.x * 51.0f;
                if (this.font == null) break;
                width += this.font.getWidthPoint(this.code.charAt(0), this.size) + this.font.getWidthPoint(this.code.charAt(7), this.size);
                break;
            }
            case 5: {
                width = this.x * 20.0f;
                break;
            }
            case 6: {
                width = this.x * 47.0f;
                break;
            }
            default: {
                throw new RuntimeException("Invalid code type.");
            }
        }
        return new Rectangle(width, height);
    }

    public static byte[] getBarsEAN13(String _code) {
        int[] code = new int[_code.length()];
        int k = 0;
        while (k < code.length) {
            code[k] = _code.charAt(k) - 48;
            ++k;
        }
        byte[] bars = new byte[59];
        int pb = 0;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        byte[] sequence = PARITY13[code[0]];
        int k2 = 0;
        while (k2 < sequence.length) {
            int c = code[k2 + 1];
            byte[] stripes = BARS[c];
            if (sequence[k2] == 0) {
                bars[pb++] = stripes[0];
                bars[pb++] = stripes[1];
                bars[pb++] = stripes[2];
                bars[pb++] = stripes[3];
            } else {
                bars[pb++] = stripes[3];
                bars[pb++] = stripes[2];
                bars[pb++] = stripes[1];
                bars[pb++] = stripes[0];
            }
            ++k2;
        }
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        int k3 = 7;
        while (k3 < 13) {
            int c = code[k3];
            byte[] stripes = BARS[c];
            bars[pb++] = stripes[0];
            bars[pb++] = stripes[1];
            bars[pb++] = stripes[2];
            bars[pb++] = stripes[3];
            ++k3;
        }
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        return bars;
    }

    public static byte[] getBarsEAN8(String _code) {
        int[] code = new int[_code.length()];
        int k = 0;
        while (k < code.length) {
            code[k] = _code.charAt(k) - 48;
            ++k;
        }
        byte[] bars = new byte[43];
        int pb = 0;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        int k2 = 0;
        while (k2 < 4) {
            int c = code[k2];
            byte[] stripes = BARS[c];
            bars[pb++] = stripes[0];
            bars[pb++] = stripes[1];
            bars[pb++] = stripes[2];
            bars[pb++] = stripes[3];
            ++k2;
        }
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        int k3 = 4;
        while (k3 < 8) {
            int c = code[k3];
            byte[] stripes = BARS[c];
            bars[pb++] = stripes[0];
            bars[pb++] = stripes[1];
            bars[pb++] = stripes[2];
            bars[pb++] = stripes[3];
            ++k3;
        }
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        return bars;
    }

    public static byte[] getBarsSupplemental2(String _code) {
        int[] code = new int[2];
        int k = 0;
        while (k < code.length) {
            code[k] = _code.charAt(k) - 48;
            ++k;
        }
        byte[] bars = new byte[13];
        int pb = 0;
        int parity = (code[0] * 10 + code[1]) % 4;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 2;
        byte[] sequence = PARITY2[parity];
        int k2 = 0;
        while (k2 < sequence.length) {
            if (k2 == 1) {
                bars[pb++] = 1;
                bars[pb++] = 1;
            }
            int c = code[k2];
            byte[] stripes = BARS[c];
            if (sequence[k2] == 0) {
                bars[pb++] = stripes[0];
                bars[pb++] = stripes[1];
                bars[pb++] = stripes[2];
                bars[pb++] = stripes[3];
            } else {
                bars[pb++] = stripes[3];
                bars[pb++] = stripes[2];
                bars[pb++] = stripes[1];
                bars[pb++] = stripes[0];
            }
            ++k2;
        }
        return bars;
    }

    public static byte[] getBarsSupplemental5(String _code) {
        int[] code = new int[5];
        int k = 0;
        while (k < code.length) {
            code[k] = _code.charAt(k) - 48;
            ++k;
        }
        byte[] bars = new byte[31];
        int pb = 0;
        int parity = ((code[0] + code[2] + code[4]) * 3 + (code[1] + code[3]) * 9) % 10;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 2;
        byte[] sequence = PARITY5[parity];
        int k2 = 0;
        while (k2 < sequence.length) {
            if (k2 != 0) {
                bars[pb++] = 1;
                bars[pb++] = 1;
            }
            int c = code[k2];
            byte[] stripes = BARS[c];
            if (sequence[k2] == 0) {
                bars[pb++] = stripes[0];
                bars[pb++] = stripes[1];
                bars[pb++] = stripes[2];
                bars[pb++] = stripes[3];
            } else {
                bars[pb++] = stripes[3];
                bars[pb++] = stripes[2];
                bars[pb++] = stripes[1];
                bars[pb++] = stripes[0];
            }
            ++k2;
        }
        return bars;
    }

    public static byte[] getBarsUPCE(String _code) {
        int[] code = new int[_code.length()];
        int k = 0;
        while (k < code.length) {
            code[k] = _code.charAt(k) - 48;
            ++k;
        }
        byte[] bars = new byte[33];
        boolean flip = code[0] != 0;
        int pb = 0;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        byte[] sequence = PARITYE[code[code.length - 1]];
        int k2 = 1;
        while (k2 < code.length - 1) {
            int c = code[k2];
            byte[] stripes = BARS[c];
            if (sequence[k2 - 1] == (flip ? (byte)1 : 0)) {
                bars[pb++] = stripes[0];
                bars[pb++] = stripes[1];
                bars[pb++] = stripes[2];
                bars[pb++] = stripes[3];
            } else {
                bars[pb++] = stripes[3];
                bars[pb++] = stripes[2];
                bars[pb++] = stripes[1];
                bars[pb++] = stripes[0];
            }
            ++k2;
        }
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        return bars;
    }

    public Rectangle placeBarcode(PdfContentByte cb, Color barColor, Color textColor) {
        Rectangle rect = this.getBarcodeSize();
        float barStartX = 0.0f;
        float barStartY = 0.0f;
        float textStartY = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                textStartY = this.barHeight - this.baseline;
            } else {
                textStartY = -this.font.getFontDescriptor(3, this.size);
                barStartY = textStartY + this.baseline;
            }
        }
        switch (this.codeType) {
            case 1: 
            case 3: 
            case 4: {
                if (this.font == null) break;
                barStartX += this.font.getWidthPoint(this.code.charAt(0), this.size);
            }
        }
        byte[] bars = null;
        int[] guard = GUARD_EMPTY;
        switch (this.codeType) {
            case 1: {
                bars = BarcodeEAN.getBarsEAN13(this.code);
                guard = GUARD_EAN13;
                break;
            }
            case 2: {
                bars = BarcodeEAN.getBarsEAN8(this.code);
                guard = GUARD_EAN8;
                break;
            }
            case 3: {
                bars = BarcodeEAN.getBarsEAN13("0" + this.code);
                guard = GUARD_UPCA;
                break;
            }
            case 4: {
                bars = BarcodeEAN.getBarsUPCE(this.code);
                guard = GUARD_UPCE;
                break;
            }
            case 5: {
                bars = BarcodeEAN.getBarsSupplemental2(this.code);
                break;
            }
            case 6: {
                bars = BarcodeEAN.getBarsSupplemental5(this.code);
            }
        }
        float keepBarX = barStartX;
        boolean print = true;
        float gd = 0.0f;
        if (this.font != null && this.baseline > 0.0f && this.guardBars) {
            gd = this.baseline / 2.0f;
        }
        if (barColor != null) {
            cb.setColorFill(barColor);
        }
        int k = 0;
        while (k < bars.length) {
            float w = (float)bars[k] * this.x;
            if (print) {
                if (Arrays.binarySearch(guard, k) >= 0) {
                    cb.rectangle(barStartX, barStartY - gd, w - this.inkSpreading, this.barHeight + gd);
                } else {
                    cb.rectangle(barStartX, barStartY, w - this.inkSpreading, this.barHeight);
                }
            }
            print = !print;
            barStartX += w;
            ++k;
        }
        cb.fill();
        if (this.font != null) {
            if (textColor != null) {
                cb.setColorFill(textColor);
            }
            cb.beginText();
            cb.setFontAndSize(this.font, this.size);
            switch (this.codeType) {
                case 1: {
                    cb.setTextMatrix(0.0f, textStartY);
                    cb.showText(this.code.substring(0, 1));
                    int k2 = 1;
                    while (k2 < 13) {
                        String c = this.code.substring(k2, k2 + 1);
                        float len = this.font.getWidthPoint(c, this.size);
                        float pX = keepBarX + TEXTPOS_EAN13[k2 - 1] * this.x - len / 2.0f;
                        cb.setTextMatrix(pX, textStartY);
                        cb.showText(c);
                        ++k2;
                    }
                    break;
                }
                case 2: {
                    int k3 = 0;
                    while (k3 < 8) {
                        String c = this.code.substring(k3, k3 + 1);
                        float len = this.font.getWidthPoint(c, this.size);
                        float pX = TEXTPOS_EAN8[k3] * this.x - len / 2.0f;
                        cb.setTextMatrix(pX, textStartY);
                        cb.showText(c);
                        ++k3;
                    }
                    break;
                }
                case 3: {
                    cb.setTextMatrix(0.0f, textStartY);
                    cb.showText(this.code.substring(0, 1));
                    int k4 = 1;
                    while (k4 < 11) {
                        String c = this.code.substring(k4, k4 + 1);
                        float len = this.font.getWidthPoint(c, this.size);
                        float pX = keepBarX + TEXTPOS_EAN13[k4] * this.x - len / 2.0f;
                        cb.setTextMatrix(pX, textStartY);
                        cb.showText(c);
                        ++k4;
                    }
                    cb.setTextMatrix(keepBarX + this.x * 95.0f, textStartY);
                    cb.showText(this.code.substring(11, 12));
                    break;
                }
                case 4: {
                    cb.setTextMatrix(0.0f, textStartY);
                    cb.showText(this.code.substring(0, 1));
                    int k5 = 1;
                    while (k5 < 7) {
                        String c = this.code.substring(k5, k5 + 1);
                        float len = this.font.getWidthPoint(c, this.size);
                        float pX = keepBarX + TEXTPOS_EAN13[k5 - 1] * this.x - len / 2.0f;
                        cb.setTextMatrix(pX, textStartY);
                        cb.showText(c);
                        ++k5;
                    }
                    cb.setTextMatrix(keepBarX + this.x * 51.0f, textStartY);
                    cb.showText(this.code.substring(7, 8));
                    break;
                }
                case 5: 
                case 6: {
                    int k6 = 0;
                    while (k6 < this.code.length()) {
                        String c = this.code.substring(k6, k6 + 1);
                        float len = this.font.getWidthPoint(c, this.size);
                        float pX = (7.5f + (float)(9 * k6)) * this.x - len / 2.0f;
                        cb.setTextMatrix(pX, textStartY);
                        cb.showText(c);
                        ++k6;
                    }
                    break;
                }
            }
            cb.endText();
        }
        return rect;
    }
}

