/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.pdf.PdfArray;
import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfObject;
import com.lowagie2.text.pdf.PdfReader;
import com.lowagie2.text.pdf.PdfString;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class FdfReader
extends PdfReader {
    PdfName encoding;
    HashMap fields;
    String fileSpec;

    public FdfReader(InputStream is) throws IOException {
        super(is);
    }

    public FdfReader(URL url) throws IOException {
        super(url);
    }

    public FdfReader(byte[] pdfIn) throws IOException {
        super(pdfIn);
    }

    public FdfReader(String filename) throws IOException {
        super(filename);
    }

    public PdfDictionary getField(String name) {
        return (PdfDictionary)this.fields.get(name);
    }

    public String getFieldValue(String name) {
        PdfDictionary field = (PdfDictionary)this.fields.get(name);
        if (field == null) {
            return null;
        }
        PdfObject v = PdfReader.getPdfObject(field.get(PdfName.V));
        if (v == null) {
            return null;
        }
        if (v.isName()) {
            return PdfName.decodeName(((PdfName)v).toString());
        }
        if (v.isString()) {
            PdfString vs = (PdfString)v;
            if (this.encoding == null || vs.getEncoding() != null) {
                return vs.toUnicodeString();
            }
            byte[] b = vs.getBytes();
            if (b.length >= 2 && b[0] == -2 && b[1] == -1) {
                return vs.toUnicodeString();
            }
            try {
                if (this.encoding.equals(PdfName.SHIFT_JIS)) {
                    return new String(b, "SJIS");
                }
                if (this.encoding.equals(PdfName.UHC)) {
                    return new String(b, "MS949");
                }
                if (this.encoding.equals(PdfName.GBK)) {
                    return new String(b, "GBK");
                }
                if (this.encoding.equals(PdfName.BIGFIVE)) {
                    return new String(b, "Big5");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return vs.toUnicodeString();
        }
        return null;
    }

    public HashMap getFields() {
        return this.fields;
    }

    public String getFileSpec() {
        return this.fileSpec;
    }

    protected void kidNode(PdfDictionary merged, String name) {
        PdfArray kids = (PdfArray)PdfReader.getPdfObject(merged.get(PdfName.KIDS));
        if (kids == null || kids.getArrayList().size() == 0) {
            if (name.length() > 0) {
                name = name.substring(1);
            }
            this.fields.put(name, merged);
        } else {
            merged.remove(PdfName.KIDS);
            ArrayList ar = kids.getArrayList();
            int k = 0;
            while (k < ar.size()) {
                PdfDictionary dic = new PdfDictionary();
                dic.merge(merged);
                PdfDictionary newDic = (PdfDictionary)PdfReader.getPdfObject((PdfObject)ar.get(k));
                PdfString t = (PdfString)PdfReader.getPdfObject(newDic.get(PdfName.T));
                String newName = name;
                if (t != null) {
                    newName = newName + "." + t.toUnicodeString();
                }
                dic.merge(newDic);
                dic.remove(PdfName.T);
                this.kidNode(dic, newName);
                ++k;
            }
        }
    }

    protected void readFields() throws IOException {
        PdfArray fld;
        this.catalog = (PdfDictionary)PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        PdfDictionary fdf = (PdfDictionary)PdfReader.getPdfObject(this.catalog.get(PdfName.FDF));
        PdfString fs = (PdfString)PdfReader.getPdfObject(fdf.get(PdfName.F));
        if (fs != null) {
            this.fileSpec = fs.toUnicodeString();
        }
        if ((fld = (PdfArray)PdfReader.getPdfObject(fdf.get(PdfName.FIELDS))) == null) {
            return;
        }
        this.encoding = (PdfName)PdfReader.getPdfObject(fdf.get(PdfName.ENCODING));
        PdfDictionary merged = new PdfDictionary();
        merged.put(PdfName.KIDS, fld);
        this.kidNode(merged, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPdf() throws IOException {
        this.fields = new HashMap();
        try {
            this.tokens.checkFdfHeader();
            this.rebuildXref();
            this.readDocObj();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                this.tokens.close();
            }
            catch (Exception e) {
            }
            throw throwable;
        }
        try {
            this.tokens.close();
        }
        catch (Exception e) {
        }
        this.readFields();
    }
}

