/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfIndirectReference;
import com.lowagie2.text.pdf.PdfLiteral;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfObject;
import com.lowagie2.text.pdf.PdfReader;
import com.lowagie2.text.pdf.PdfResources;
import java.util.HashMap;
import java.util.Iterator;

class PageResources {
    protected PdfDictionary colorDictionary;
    protected PdfDictionary extGStateDictionary;
    protected PdfDictionary fontDictionary = new PdfDictionary();
    protected HashMap forbiddenNames;
    protected int[] namePtr;
    protected PdfDictionary originalResources;
    protected PdfDictionary patternDictionary;
    protected PdfDictionary propertyDictionary;
    protected PdfDictionary shadingDictionary;
    protected HashMap usedNames;
    protected PdfDictionary xObjectDictionary = new PdfDictionary();

    PageResources() {
        this.colorDictionary = new PdfDictionary();
        this.patternDictionary = new PdfDictionary();
        this.shadingDictionary = new PdfDictionary();
        this.extGStateDictionary = new PdfDictionary();
        this.propertyDictionary = new PdfDictionary();
        this.namePtr = new int[]{0};
    }

    PdfName addColor(PdfName name, PdfIndirectReference reference) {
        name = this.translateName(name);
        this.colorDictionary.put(name, reference);
        return name;
    }

    void addDefaultColor(PdfDictionary dic) {
        this.colorDictionary.merge(dic);
    }

    void addDefaultColor(PdfName name, PdfObject obj) {
        if (obj == null || obj.isNull()) {
            this.colorDictionary.remove(name);
        } else {
            this.colorDictionary.put(name, obj);
        }
    }

    void addDefaultColorDiff(PdfDictionary dic) {
        this.colorDictionary.mergeDifferent(dic);
    }

    PdfName addExtGState(PdfName name, PdfIndirectReference reference) {
        name = this.translateName(name);
        this.extGStateDictionary.put(name, reference);
        return name;
    }

    PdfName addFont(PdfName name, PdfIndirectReference reference) {
        name = this.translateName(name);
        this.fontDictionary.put(name, reference);
        return name;
    }

    PdfName addPattern(PdfName name, PdfIndirectReference reference) {
        name = this.translateName(name);
        this.patternDictionary.put(name, reference);
        return name;
    }

    PdfName addProperty(PdfName name, PdfIndirectReference reference) {
        name = this.translateName(name);
        this.propertyDictionary.put(name, reference);
        return name;
    }

    PdfName addShading(PdfName name, PdfIndirectReference reference) {
        name = this.translateName(name);
        this.shadingDictionary.put(name, reference);
        return name;
    }

    PdfName addXObject(PdfName name, PdfIndirectReference reference) {
        name = this.translateName(name);
        this.xObjectDictionary.put(name, reference);
        return name;
    }

    PdfDictionary getResources() {
        PdfResources resources = new PdfResources();
        if (this.originalResources != null) {
            resources.putAll(this.originalResources);
        }
        resources.put(PdfName.PROCSET, new PdfLiteral("[/PDF /Text /ImageB /ImageC /ImageI]"));
        resources.add(PdfName.FONT, this.fontDictionary);
        resources.add(PdfName.XOBJECT, this.xObjectDictionary);
        resources.add(PdfName.COLORSPACE, this.colorDictionary);
        resources.add(PdfName.PATTERN, this.patternDictionary);
        resources.add(PdfName.SHADING, this.shadingDictionary);
        resources.add(PdfName.EXTGSTATE, this.extGStateDictionary);
        resources.add(PdfName.PROPERTIES, this.propertyDictionary);
        return resources;
    }

    boolean hasResources() {
        return this.fontDictionary.size() > 0 || this.xObjectDictionary.size() > 0 || this.colorDictionary.size() > 0 || this.patternDictionary.size() > 0 || this.shadingDictionary.size() > 0 || this.extGStateDictionary.size() > 0 || this.propertyDictionary.size() > 0;
    }

    void setOriginalResources(PdfDictionary resources, int[] newNamePtr) {
        if (newNamePtr != null) {
            this.namePtr = newNamePtr;
        }
        this.originalResources = resources;
        this.forbiddenNames = new HashMap();
        this.usedNames = new HashMap();
        if (resources == null) {
            return;
        }
        Iterator i = resources.getKeys().iterator();
        while (i.hasNext()) {
            PdfObject sub = PdfReader.getPdfObject(resources.get((PdfName)i.next()));
            if (!sub.isDictionary()) continue;
            PdfDictionary dic = (PdfDictionary)sub;
            Iterator j = dic.getKeys().iterator();
            while (j.hasNext()) {
                this.forbiddenNames.put(j.next(), null);
            }
        }
    }

    PdfName translateName(PdfName name) {
        PdfName translated = name;
        if (this.forbiddenNames != null && (translated = (PdfName)this.usedNames.get(name)) == null) {
            int n;
            do {
                n = this.namePtr[0];
                this.namePtr[0] = n + 1;
            } while (this.forbiddenNames.containsKey(translated = new PdfName("Xi" + n)));
            this.usedNames.put(name, translated);
        }
        return translated;
    }
}

