/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.Chunk;
import com.lowagie2.text.ListItem;
import com.lowagie2.text.pdf.PdfChunk;
import com.lowagie2.text.pdf.PdfFont;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfLine {
    protected int alignment;
    protected float height;
    protected boolean isRTL = false;
    protected float left;
    protected ArrayList line;
    protected Chunk listSymbol = null;
    protected boolean newlineSplit = false;
    protected float originalWidth;
    protected float symbolIndent;
    protected float width;

    PdfLine(float left, float remainingWidth, int alignment, boolean newlineSplit, ArrayList line, boolean isRTL) {
        this.left = left;
        this.width = remainingWidth;
        this.alignment = alignment;
        this.line = line;
        this.newlineSplit = newlineSplit;
        this.isRTL = isRTL;
    }

    PdfLine(float left, float right, int alignment, float height) {
        this.left = left;
        this.originalWidth = this.width = right - left;
        this.alignment = alignment;
        this.height = height;
        this.line = new ArrayList();
    }

    PdfChunk add(PdfChunk chunk) {
        if (chunk == null || chunk.toString().equals("")) {
            return null;
        }
        PdfChunk overflow = chunk.split(this.width);
        boolean bl = this.newlineSplit = chunk.isNewlineSplit() || overflow == null;
        if (chunk.length() > 0) {
            if (overflow != null) {
                chunk.trimLastSpace();
            }
            this.width -= chunk.width();
            this.line.add(chunk);
        } else {
            if (this.line.size() < 1) {
                chunk = overflow;
                overflow = chunk.truncate(this.width);
                this.width -= chunk.width();
                if (chunk.length() > 0) {
                    this.line.add(chunk);
                    return overflow;
                }
                if (overflow != null) {
                    this.line.add(overflow);
                }
                return null;
            }
            this.width += ((PdfChunk)this.line.get(this.line.size() - 1)).trimLastSpace();
        }
        return overflow;
    }

    public float getAscender() {
        float ascender = 0.0f;
        int k = 0;
        while (k < this.line.size()) {
            PdfChunk ck = (PdfChunk)this.line.get(k);
            if (ck.isImage()) {
                ascender = Math.max(ascender, ck.getImage().scaledHeight() + ck.getImageOffsetY());
            } else {
                PdfFont font = ck.font();
                ascender = Math.max(ascender, font.getFont().getFontDescriptor(1, font.size()));
            }
            ++k;
        }
        return ascender;
    }

    public PdfChunk getChunk(int idx) {
        if (idx < 0 || idx >= this.line.size()) {
            return null;
        }
        return (PdfChunk)this.line.get(idx);
    }

    public float getDescender() {
        float descender = 0.0f;
        int k = 0;
        while (k < this.line.size()) {
            PdfChunk ck = (PdfChunk)this.line.get(k);
            if (ck.isImage()) {
                descender = Math.min(descender, ck.getImageOffsetY());
            } else {
                PdfFont font = ck.font();
                descender = Math.min(descender, font.getFont().getFontDescriptor(3, font.size()));
            }
            ++k;
        }
        return descender;
    }

    public int getLastStrokeChunk() {
        int lastIdx = this.line.size() - 1;
        while (lastIdx >= 0) {
            PdfChunk chunk = (PdfChunk)this.line.get(lastIdx);
            if (chunk.isStroked()) break;
            --lastIdx;
        }
        return lastIdx;
    }

    float getMaxSize() {
        float maxSize = 0.0f;
        int k = 0;
        while (k < this.line.size()) {
            PdfChunk chunk = (PdfChunk)this.line.get(k);
            maxSize = !chunk.isImage() || !chunk.changeLeading() ? Math.max(chunk.font().size(), maxSize) : Math.max(chunk.getImage().scaledHeight() + chunk.getImageOffsetY(), maxSize);
            ++k;
        }
        return maxSize;
    }

    float getMaxSizeSimple() {
        float maxSize = 0.0f;
        int k = 0;
        while (k < this.line.size()) {
            PdfChunk chunk = (PdfChunk)this.line.get(k);
            maxSize = !chunk.isImage() ? Math.max(chunk.font().size(), maxSize) : Math.max(chunk.getImage().scaledHeight() + chunk.getImageOffsetY(), maxSize);
            ++k;
        }
        return maxSize;
    }

    public float getOriginalWidth() {
        return this.originalWidth;
    }

    public float getWidthCorrected(float charSpacing, float wordSpacing) {
        float total = 0.0f;
        int k = 0;
        while (k < this.line.size()) {
            PdfChunk ck = (PdfChunk)this.line.get(k);
            total += ck.getWidthCorrected(charSpacing, wordSpacing);
            ++k;
        }
        return total;
    }

    public boolean hasToBeJustified() {
        return (this.alignment == 3 || this.alignment == 8) && this.width != 0.0f;
    }

    float height() {
        return this.height;
    }

    float indentLeft() {
        if (this.isRTL) {
            switch (this.alignment) {
                case 0: {
                    return this.left + this.width;
                }
                case 1: {
                    return this.left + this.width / 2.0f;
                }
            }
            return this.left;
        }
        switch (this.alignment) {
            case 2: {
                return this.left + this.width;
            }
            case 1: {
                return this.left + this.width / 2.0f;
            }
        }
        return this.left;
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit && this.alignment != 8;
    }

    boolean isRTL() {
        return this.isRTL;
    }

    public Iterator iterator() {
        return this.line.iterator();
    }

    public float listIndent() {
        return this.symbolIndent;
    }

    public Chunk listSymbol() {
        return this.listSymbol;
    }

    int numberOfSpaces() {
        String string = this.toString();
        int length = string.length();
        int numberOfSpaces = 0;
        int i = 0;
        while (i < length) {
            if (string.charAt(i) == ' ') {
                ++numberOfSpaces;
            }
            ++i;
        }
        return numberOfSpaces;
    }

    public void resetAlignment() {
        if (this.alignment == 3) {
            this.alignment = 0;
        }
    }

    public void setListItem(ListItem listItem) {
        this.listSymbol = listItem.listSymbol();
        this.symbolIndent = listItem.indentationLeft();
    }

    public int size() {
        return this.line.size();
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        Iterator i = this.line.iterator();
        while (i.hasNext()) {
            tmp.append(((PdfChunk)i.next()).toString());
        }
        return tmp.toString();
    }

    float widthLeft() {
        return this.width;
    }
}

