/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.pdf.ByteBuffer;
import com.lowagie2.text.pdf.PRTokeniser;
import com.lowagie2.text.pdf.PdfObject;

public class PdfName
extends PdfObject
implements Comparable {
    public static final PdfName A = new PdfName("A");
    public static final PdfName AA = new PdfName("AA");
    public static final PdfName ABSOLUTECALORIMETRIC = new PdfName("AbsoluteColorimetric");
    public static final PdfName AC = new PdfName("AC");
    public static final PdfName ACROFORM = new PdfName("AcroForm");
    public static final PdfName ACTION = new PdfName("Action");
    public static final PdfName ADBE_PKCS7_DETACHED = new PdfName("adbe.pkcs7.detached");
    public static final PdfName ADBE_PKCS7_SHA1 = new PdfName("adbe.pkcs7.sha1");
    public static final PdfName ADBE_X509_RSA_SHA1 = new PdfName("adbe.x509.rsa_sha1");
    public static final PdfName ADOBE_PPKLITE = new PdfName("Adobe.PPKLite");
    public static final PdfName ADOBE_PPKMS = new PdfName("Adobe.PPKMS");
    public static final PdfName AIS = new PdfName("AIS");
    public static final PdfName ALLPAGES = new PdfName("AllPages");
    public static final PdfName ALTERNATE = new PdfName("Alternate");
    public static final PdfName ANNOT = new PdfName("Annot");
    public static final PdfName ANNOTS;
    public static final PdfName ANTIALIAS;
    public static final PdfName AP;
    public static final PdfName ARTBOX;
    public static final PdfName AS;
    public static final PdfName ASCENT;
    public static final PdfName ASCII85DECODE;
    public static final PdfName ASCIIHEXDECODE;
    public static final PdfName AUTHOR;
    public static final PdfName B;
    public static final PdfName BASEENCODING;
    public static final PdfName BASEFONT;
    public static final PdfName BBOX;
    public static final PdfName BC;
    public static final PdfName BG;
    public static final PdfName BIGFIVE;
    public static final PdfName BITSPERCOMPONENT;
    public static final PdfName BITSPERSAMPLE;
    public static final PdfName BL;
    public static final PdfName BLACKIS1;
    public static final PdfName BLACKPOINT;
    public static final PdfName BLEEDBOX;
    public static final PdfName BLINDS;
    public static final PdfName BM;
    public static final PdfName BORDER;
    public static final PdfName BOUNDS;
    public static final PdfName BOX;
    public static final PdfName BS;
    public static final PdfName BTN;
    public static final PdfName BYTERANGE;
    public static final PdfName C;
    public static final PdfName C0;
    public static final PdfName C1;
    public static final PdfName CA;
    public static final PdfName CALGRAY;
    public static final PdfName CALRGB;
    public static final PdfName CAPHEIGHT;
    public static final PdfName CATALOG;
    public static final PdfName CATEGORY;
    public static final PdfName CCITTFAXDECODE;
    public static final PdfName CENTERWINDOW;
    public static final PdfName CERT;
    public static final PdfName CH;
    public static final PdfName CHARPROCS;
    public static final PdfName CIDFONTTYPE0;
    public static final PdfName CIDFONTTYPE2;
    public static final PdfName CIDSYSTEMINFO;
    public static final PdfName CIDTOGIDMAP;
    public static final PdfName CIRCLE;
    public static final PdfName CO;
    public static final PdfName COLORS;
    public static final PdfName COLORSPACE;
    public static final PdfName COLUMNS;
    public static final PdfName CONTACTINFO;
    public static final PdfName CONTENT;
    public static final PdfName CONTENTS;
    public static final PdfName COORDS;
    public static final PdfName COUNT;
    public static final PdfName COURIER;
    public static final PdfName COURIER_BOLD;
    public static final PdfName COURIER_BOLDOBLIQUE;
    public static final PdfName COURIER_OBLIQUE;
    public static final PdfName CREATIONDATE;
    public static final PdfName CREATOR;
    public static final PdfName CREATORINFO;
    public static final PdfName CROPBOX;
    public static final PdfName CS;
    public static final PdfName D;
    public static final PdfName DA;
    public static final PdfName DC;
    public static final PdfName DCTDECODE;
    public static final PdfName DECODE;
    public static final PdfName DECODEPARMS;
    public static final PdfName DEFAULTCMYK;
    public static final PdfName DEFAULTGRAY;
    public static final PdfName DEFAULTRGB;
    public static final PdfName DESC;
    public static final PdfName DESCENDANTFONTS;
    public static final PdfName DESCENT;
    public static final PdfName DEST;
    public static final PdfName DESTOUTPUTPROFILE;
    public static final PdfName DESTS;
    public static final PdfName DEVICECMYK;
    public static final PdfName DEVICEGRAY;
    public static final PdfName DEVICERGB;
    public static final PdfName DI;
    public static final PdfName DIFFERENCES;
    public static final PdfName DIRECTION;
    public static final PdfName DISPLAYDOCTITLE;
    public static final PdfName DISSOLVE;
    public static final PdfName DM;
    public static final PdfName DOMAIN;
    public static final PdfName DP;
    public static final PdfName DR;
    public static final PdfName DS;
    public static final PdfName DUR;
    public static final PdfName DV;
    public static final PdfName DW;
    public static final PdfName E;
    public static final PdfName EARLYCHANGE;
    public static final PdfName EF;
    public static final PdfName EMBEDDEDFILE;
    public static final PdfName EMBEDDEDFILES;
    public static final PdfName ENCODE;
    public static final PdfName ENCODEDBYTEALIGN;
    public static final PdfName ENCODING;
    public static final PdfName ENCRYPT;
    public static final PdfName ENDOFBLOCK;
    public static final PdfName ENDOFLINE;
    public static final PdfName EVENT;
    public static final PdfName EXPORT;
    public static final PdfName EXPORTSTATE;
    public static final PdfName EXTEND;
    public static final PdfName EXTGSTATE;
    public static final PdfName F;
    public static final PdfName FB;
    public static final PdfName FDECODEPARMS;
    public static final PdfName FDF;
    public static final PdfName FF;
    public static final PdfName FFILTER;
    public static final PdfName FIELDS;
    public static final PdfName FILEATTACHMENT;
    public static final PdfName FILESPEC;
    public static final PdfName FILTER;
    public static final PdfName FIRST;
    public static final PdfName FIRSTCHAR;
    public static final PdfName FIRSTPAGE;
    public static final PdfName FIT;
    public static final PdfName FITB;
    public static final PdfName FITBH;
    public static final PdfName FITBV;
    public static final PdfName FITH;
    public static final PdfName FITR;
    public static final PdfName FITV;
    public static final PdfName FITWINDOW;
    public static final PdfName FLAGS;
    public static final PdfName FLATEDECODE;
    public static final PdfName FO;
    public static final PdfName FONT;
    public static final PdfName FONTBBOX;
    public static final PdfName FONTDESCRIPTOR;
    public static final PdfName FONTFILE;
    public static final PdfName FONTFILE2;
    public static final PdfName FONTFILE3;
    public static final PdfName FONTMATRIX;
    public static final PdfName FONTNAME;
    public static final PdfName FORM;
    public static final PdfName FORMTYPE;
    public static final PdfName FREETEXT;
    public static final PdfName FRM;
    public static final PdfName FS;
    public static final PdfName FT;
    public static final PdfName FULLSCREEN;
    public static final PdfName FUNCTION;
    public static final PdfName FUNCTIONS;
    public static final PdfName FUNCTIONTYPE;
    public static final PdfName GAMMA;
    public static final PdfName GBK;
    public static final PdfName GLITTER;
    public static final PdfName GOTO;
    public static final PdfName GOTOR;
    public static final PdfName GROUP;
    public static final PdfName GTS_PDFX;
    public static final PdfName GTS_PDFXVERSION;
    public static final PdfName H;
    public static final PdfName HEIGHT;
    public static final PdfName HELVETICA;
    public static final PdfName HELVETICA_BOLD;
    public static final PdfName HELVETICA_BOLDOBLIQUE;
    public static final PdfName HELVETICA_OBLIQUE;
    public static final PdfName HID;
    public static final PdfName HIDE;
    public static final PdfName HIDEMENUBAR;
    public static final PdfName HIDETOOLBAR;
    public static final PdfName HIDEWINDOWUI;
    public static final PdfName HIGHLIGHT;
    public static final PdfName I;
    public static final PdfName ICCBASED;
    public static final PdfName ID;
    public static final PdfName IDENTITY;
    public static final PdfName IF;
    public static final PdfName IMAGE;
    public static final PdfName IMAGEB;
    public static final PdfName IMAGEC;
    public static final PdfName IMAGEI;
    public static final PdfName IMAGEMASK;
    public static final PdfName IMPORTDATA;
    public static final PdfName INDEX;
    public static final PdfName INDEXED;
    public static final PdfName INFO;
    public static final PdfName INK;
    public static final PdfName INKLIST;
    public static final PdfName INTENT;
    public static final PdfName INTERPOLATE;
    public static final PdfName IRT;
    public static final PdfName ISMAP;
    public static final PdfName ITALICANGLE;
    public static final PdfName IX;
    public static final PdfName JAVASCRIPT;
    public static final PdfName JS;
    public static final PdfName K;
    public static final PdfName KEYWORDS;
    public static final PdfName KIDS;
    public static final PdfName L;
    public static final PdfName L2R;
    public static final PdfName LANG;
    public static final PdfName LANGUAGE;
    public static final PdfName LAST;
    public static final PdfName LASTCHAR;
    public static final PdfName LASTPAGE;
    public static final PdfName LAUNCH;
    public static final PdfName LENGTH;
    public static final PdfName LENGTH1;
    public static final PdfName LIMITS;
    public static final PdfName LINE;
    public static final PdfName LINK;
    public static final PdfName LISTMODE;
    public static final PdfName LOCATION;
    public static final PdfName LOCK;
    public static final PdfName LZWDECODE;
    public static final PdfName M;
    public static final PdfName MAC_EXPERT_ENCODING;
    public static final PdfName MAC_ROMAN_ENCODING;
    public static final PdfName MARKED;
    public static final PdfName MARKINFO;
    public static final PdfName MASK;
    public static final PdfName MATRIX;
    public static final PdfName MAX;
    public static final PdfName MAXLEN;
    public static final PdfName MCID;
    public static final PdfName MCR;
    public static final PdfName MEDIABOX;
    public static final PdfName METADATA;
    public static final PdfName MIN;
    public static final PdfName MK;
    public static final PdfName MMTYPE1;
    public static final PdfName MODDATE;
    public static final PdfName N;
    public static final PdfName N0;
    public static final PdfName N1;
    public static final PdfName N2;
    public static final PdfName N3;
    public static final PdfName N4;
    public static final PdfName NAME;
    public static final PdfName NAMED;
    public static final PdfName NAMES;
    public static final PdfName NEEDAPPEARANCES;
    public static final PdfName NEWWINDOW;
    public static final PdfName NEXT;
    public static final PdfName NEXTPAGE;
    public static final PdfName NM;
    public static final PdfName NONE;
    public static final PdfName NONFULLSCREENPAGEMODE;
    public static final PdfName NUMS;
    public static final PdfName O;
    public static final PdfName OBJSTM;
    public static final PdfName OC;
    public static final PdfName OCG;
    public static final PdfName OCGS;
    public static final PdfName OCMD;
    public static final PdfName OCPROPERTIES;
    public static final PdfName OFF;
    public static final PdfName ON;
    public static final PdfName ONECOLUMN;
    public static final PdfName OP;
    public static final PdfName OPEN;
    public static final PdfName OPENACTION;
    public static final PdfName OPM;
    public static final PdfName OPT;
    public static final PdfName ORDER;
    public static final PdfName ORDERING;
    public static final PdfName OUTLINES;
    public static final PdfName OUTPUTCONDITION;
    public static final PdfName OUTPUTCONDITIONIDENTIFIER;
    public static final PdfName OUTPUTINTENT;
    public static final PdfName OUTPUTINTENTS;
    public static final PdfName Off;
    public static final PdfName P;
    public static final PdfName PAGE;
    public static final PdfName PAGELABELS;
    public static final PdfName PAGELAYOUT;
    public static final PdfName PAGEMODE;
    public static final PdfName PAGES;
    public static final PdfName PAINTTYPE;
    public static final PdfName PANOSE;
    public static final PdfName PARAMS;
    public static final PdfName PARENT;
    public static final PdfName PARENTTREE;
    public static final PdfName PATTERN;
    public static final PdfName PATTERNTYPE;
    public static final PdfName PDF;
    public static final PdfName PERCEPTUAL;
    public static final PdfName PG;
    public static final PdfName POPUP;
    public static final PdfName PREDICTOR;
    public static final PdfName PREFERRED;
    public static final PdfName PRESERVERB;
    public static final PdfName PREV;
    public static final PdfName PREVPAGE;
    public static final PdfName PRINT;
    public static final PdfName PRINTSCALING;
    public static final PdfName PRINTSTATE;
    public static final PdfName PROCSET;
    public static final PdfName PRODUCER;
    public static final PdfName PROPERTIES;
    public static final PdfName PS;
    public static final PdfName Q;
    public static final PdfName QUADPOINTS;
    public static final PdfName R;
    public static final PdfName R2L;
    public static final PdfName RANGE;
    public static final PdfName RBGROUPS;
    public static final PdfName RC;
    public static final PdfName REASON;
    public static final PdfName RECT;
    public static final PdfName REGISTRY;
    public static final PdfName REGISTRYNAME;
    public static final PdfName RELATIVECALORIMETRIC;
    public static final PdfName RENDITION;
    public static final PdfName RESETFORM;
    public static final PdfName RESOURCES;
    public static final PdfName RI;
    public static final PdfName ROLEMAP;
    public static final PdfName ROOT;
    public static final PdfName ROTATE;
    public static final PdfName ROWS;
    public static final PdfName RUNLENGTHDECODE;
    public static final PdfName RV;
    public static final PdfName S;
    public static final PdfName SATURATION;
    public static final PdfName SCREEN;
    public static final PdfName SEPARATION;
    public static final PdfName SETOCGSTATE;
    public static final PdfName SHADING;
    public static final PdfName SHADINGTYPE;
    public static final PdfName SHIFT_JIS;
    public static final PdfName SIG;
    public static final PdfName SIGFLAGS;
    public static final PdfName SINGLEPAGE;
    public static final PdfName SIZE;
    public static final PdfName SMASK;
    public static final PdfName SPLIT;
    public static final PdfName SQUARE;
    public static final PdfName ST;
    public static final PdfName STAMP;
    public static final PdfName STANDARD;
    public static final PdfName STATE;
    public static final PdfName STEMV;
    public static final PdfName STRIKEOUT;
    public static final PdfName STRUCTPARENT;
    public static final PdfName STRUCTPARENTS;
    public static final PdfName STRUCTTREEROOT;
    public static final PdfName STYLE;
    public static final PdfName SUBFILTER;
    public static final PdfName SUBJECT;
    public static final PdfName SUBMITFORM;
    public static final PdfName SUBTYPE;
    public static final PdfName SUPPLEMENT;
    public static final PdfName SV;
    public static final PdfName SW;
    public static final PdfName SYMBOL;
    public static final PdfName T;
    public static final PdfName TEXT;
    public static final PdfName THREADS;
    public static final PdfName THUMB;
    public static final PdfName TI;
    public static final PdfName TILINGTYPE;
    public static final PdfName TIMES_BOLD;
    public static final PdfName TIMES_BOLDITALIC;
    public static final PdfName TIMES_ITALIC;
    public static final PdfName TIMES_ROMAN;
    public static final PdfName TITLE;
    public static final PdfName TK;
    public static final PdfName TM;
    public static final PdfName TOGGLE;
    public static final PdfName TOUNICODE;
    public static final PdfName TP;
    public static final PdfName TRANS;
    public static final PdfName TRANSPARENCY;
    public static final PdfName TRAPPED;
    public static final PdfName TRIMBOX;
    public static final PdfName TRUETYPE;
    public static final PdfName TU;
    public static final PdfName TWOCOLUMNLEFT;
    public static final PdfName TWOCOLUMNRIGHT;
    public static final PdfName TWOPAGELEFT;
    public static final PdfName TWOPAGERIGHT;
    public static final PdfName TX;
    public static final PdfName TYPE;
    public static final PdfName TYPE0;
    public static final PdfName TYPE1;
    public static final PdfName TYPE3;
    public static final PdfName U;
    public static final PdfName UHC;
    public static final PdfName UNDERLINE;
    public static final PdfName URI;
    public static final PdfName URL;
    public static final PdfName USAGE;
    public static final PdfName USEATTACHMENTS;
    public static final PdfName USENONE;
    public static final PdfName USEOC;
    public static final PdfName USEOUTLINES;
    public static final PdfName USER;
    public static final PdfName USERUNIT;
    public static final PdfName USETHUMBS;
    public static final PdfName V;
    public static final PdfName VERISIGN_PPKVS;
    public static final PdfName VIEW;
    public static final PdfName VIEWERPREFERENCES;
    public static final PdfName VIEWSTATE;
    public static final PdfName VISIBLEPAGES;
    public static final PdfName W;
    public static final PdfName W2;
    public static final PdfName WC;
    public static final PdfName WHITEPOINT;
    public static final PdfName WIDGET;
    public static final PdfName WIDTH;
    public static final PdfName WIDTHS;
    public static final PdfName WIN;
    public static final PdfName WIN_ANSI_ENCODING;
    public static final PdfName WIPE;
    public static final PdfName WP;
    public static final PdfName WS;
    public static final PdfName X;
    public static final PdfName XFA;
    public static final PdfName XML;
    public static final PdfName XOBJECT;
    public static final PdfName XREF;
    public static final PdfName XREFSTM;
    public static final PdfName XSTEP;
    public static final PdfName XYZ;
    public static final PdfName YSTEP;
    public static final PdfName ZAPFDINGBATS;
    public static final PdfName ZOOM;
    public static final PdfName ca;
    private int hash = 0;
    public static final PdfName op;

    static {
        ANTIALIAS = new PdfName("AntiAlias");
        ANNOTS = new PdfName("Annots");
        AP = new PdfName("AP");
        ARTBOX = new PdfName("ArtBox");
        ASCENT = new PdfName("Ascent");
        AS = new PdfName("AS");
        ASCII85DECODE = new PdfName("ASCII85Decode");
        ASCIIHEXDECODE = new PdfName("ASCIIHexDecode");
        AUTHOR = new PdfName("Author");
        B = new PdfName("B");
        BASEENCODING = new PdfName("BaseEncoding");
        BASEFONT = new PdfName("BaseFont");
        BBOX = new PdfName("BBox");
        BC = new PdfName("BC");
        BG = new PdfName("BG");
        BIGFIVE = new PdfName("BigFive");
        BITSPERCOMPONENT = new PdfName("BitsPerComponent");
        BITSPERSAMPLE = new PdfName("BitsPerSample");
        BL = new PdfName("Bl");
        BLACKIS1 = new PdfName("BlackIs1");
        BLACKPOINT = new PdfName("BlackPoint");
        BLEEDBOX = new PdfName("BleedBox");
        BLINDS = new PdfName("Blinds");
        BM = new PdfName("BM");
        BORDER = new PdfName("Border");
        BOUNDS = new PdfName("Bounds");
        BOX = new PdfName("Box");
        BS = new PdfName("BS");
        BTN = new PdfName("Btn");
        BYTERANGE = new PdfName("ByteRange");
        C = new PdfName("C");
        C0 = new PdfName("C0");
        C1 = new PdfName("C1");
        CA = new PdfName("CA");
        ca = new PdfName("ca");
        CALGRAY = new PdfName("CalGray");
        CALRGB = new PdfName("CalRGB");
        CAPHEIGHT = new PdfName("CapHeight");
        CATALOG = new PdfName("Catalog");
        CATEGORY = new PdfName("Category");
        CCITTFAXDECODE = new PdfName("CCITTFaxDecode");
        CENTERWINDOW = new PdfName("CenterWindow");
        CERT = new PdfName("Cert");
        CH = new PdfName("Ch");
        CHARPROCS = new PdfName("CharProcs");
        CIDFONTTYPE0 = new PdfName("CIDFontType0");
        CIDFONTTYPE2 = new PdfName("CIDFontType2");
        CIDSYSTEMINFO = new PdfName("CIDSystemInfo");
        CIDTOGIDMAP = new PdfName("CIDToGIDMap");
        CIRCLE = new PdfName("Circle");
        CO = new PdfName("CO");
        COLORS = new PdfName("Colors");
        COLORSPACE = new PdfName("ColorSpace");
        COLUMNS = new PdfName("Columns");
        CONTACTINFO = new PdfName("ContactInfo");
        CONTENT = new PdfName("Content");
        CONTENTS = new PdfName("Contents");
        COORDS = new PdfName("Coords");
        COUNT = new PdfName("Count");
        COURIER = new PdfName("Courier");
        COURIER_BOLD = new PdfName("Courier-Bold");
        COURIER_OBLIQUE = new PdfName("Courier-Oblique");
        COURIER_BOLDOBLIQUE = new PdfName("Courier-BoldOblique");
        CREATIONDATE = new PdfName("CreationDate");
        CREATOR = new PdfName("Creator");
        CREATORINFO = new PdfName("CreatorInfo");
        CROPBOX = new PdfName("CropBox");
        CS = new PdfName("CS");
        D = new PdfName("D");
        DA = new PdfName("DA");
        DC = new PdfName("DC");
        DCTDECODE = new PdfName("DCTDecode");
        DECODE = new PdfName("Decode");
        DECODEPARMS = new PdfName("DecodeParms");
        DEFAULTCMYK = new PdfName("DefaultCMYK");
        DEFAULTGRAY = new PdfName("DefaultGray");
        DEFAULTRGB = new PdfName("DefaultRGB");
        DESC = new PdfName("Desc");
        DESCENDANTFONTS = new PdfName("DescendantFonts");
        DESCENT = new PdfName("Descent");
        DEST = new PdfName("Dest");
        DESTOUTPUTPROFILE = new PdfName("DestOutputProfile");
        DESTS = new PdfName("Dests");
        DEVICEGRAY = new PdfName("DeviceGray");
        DEVICERGB = new PdfName("DeviceRGB");
        DEVICECMYK = new PdfName("DeviceCMYK");
        DI = new PdfName("Di");
        DIFFERENCES = new PdfName("Differences");
        DISSOLVE = new PdfName("Dissolve");
        DIRECTION = new PdfName("Direction");
        DISPLAYDOCTITLE = new PdfName("DisplayDocTitle");
        DM = new PdfName("Dm");
        DOMAIN = new PdfName("Domain");
        DP = new PdfName("DP");
        DR = new PdfName("DR");
        DS = new PdfName("DS");
        DUR = new PdfName("Dur");
        DV = new PdfName("DV");
        DW = new PdfName("DW");
        E = new PdfName("E");
        EARLYCHANGE = new PdfName("EarlyChange");
        EF = new PdfName("EF");
        EMBEDDEDFILE = new PdfName("EmbeddedFile");
        EMBEDDEDFILES = new PdfName("EmbeddedFiles");
        ENCODE = new PdfName("Encode");
        ENCODEDBYTEALIGN = new PdfName("EncodedByteAlign");
        ENCODING = new PdfName("Encoding");
        ENCRYPT = new PdfName("Encrypt");
        ENDOFBLOCK = new PdfName("EndOfBlock");
        ENDOFLINE = new PdfName("EndOfLine");
        EXTEND = new PdfName("Extend");
        EXTGSTATE = new PdfName("ExtGState");
        EXPORT = new PdfName("Export");
        EXPORTSTATE = new PdfName("ExportState");
        EVENT = new PdfName("Event");
        F = new PdfName("F");
        FB = new PdfName("FB");
        FDECODEPARMS = new PdfName("FDecodeParms");
        FDF = new PdfName("FDF");
        FF = new PdfName("Ff");
        FFILTER = new PdfName("FFilter");
        FIELDS = new PdfName("Fields");
        FILEATTACHMENT = new PdfName("FileAttachment");
        FILESPEC = new PdfName("Filespec");
        FILTER = new PdfName("Filter");
        FIRST = new PdfName("First");
        FIRSTCHAR = new PdfName("FirstChar");
        FIRSTPAGE = new PdfName("FirstPage");
        FIT = new PdfName("Fit");
        FITH = new PdfName("FitH");
        FITV = new PdfName("FitV");
        FITR = new PdfName("FitR");
        FITB = new PdfName("FitB");
        FITBH = new PdfName("FitBH");
        FITBV = new PdfName("FitBV");
        FITWINDOW = new PdfName("FitWindow");
        FLAGS = new PdfName("Flags");
        FLATEDECODE = new PdfName("FlateDecode");
        FO = new PdfName("Fo");
        FONT = new PdfName("Font");
        FONTBBOX = new PdfName("FontBBox");
        FONTDESCRIPTOR = new PdfName("FontDescriptor");
        FONTFILE = new PdfName("FontFile");
        FONTFILE2 = new PdfName("FontFile2");
        FONTFILE3 = new PdfName("FontFile3");
        FONTMATRIX = new PdfName("FontMatrix");
        FONTNAME = new PdfName("FontName");
        FORM = new PdfName("Form");
        FORMTYPE = new PdfName("FormType");
        FREETEXT = new PdfName("FreeText");
        FRM = new PdfName("FRM");
        FS = new PdfName("FS");
        FT = new PdfName("FT");
        FULLSCREEN = new PdfName("FullScreen");
        FUNCTION = new PdfName("Function");
        FUNCTIONS = new PdfName("Functions");
        FUNCTIONTYPE = new PdfName("FunctionType");
        GAMMA = new PdfName("Gamma");
        GBK = new PdfName("GBK");
        GLITTER = new PdfName("Glitter");
        GOTO = new PdfName("GoTo");
        GOTOR = new PdfName("GoToR");
        GROUP = new PdfName("Group");
        GTS_PDFX = new PdfName("GTS_PDFX");
        GTS_PDFXVERSION = new PdfName("GTS_PDFXVersion");
        H = new PdfName("H");
        HEIGHT = new PdfName("Height");
        HELVETICA = new PdfName("Helvetica");
        HELVETICA_BOLD = new PdfName("Helvetica-Bold");
        HELVETICA_OBLIQUE = new PdfName("Helvetica-Oblique");
        HELVETICA_BOLDOBLIQUE = new PdfName("Helvetica-BoldOblique");
        HID = new PdfName("Hid");
        HIDE = new PdfName("Hide");
        HIDEMENUBAR = new PdfName("HideMenubar");
        HIDETOOLBAR = new PdfName("HideToolbar");
        HIDEWINDOWUI = new PdfName("HideWindowUI");
        HIGHLIGHT = new PdfName("Highlight");
        I = new PdfName("I");
        ICCBASED = new PdfName("ICCBased");
        ID = new PdfName("ID");
        IDENTITY = new PdfName("Identity");
        IF = new PdfName("IF");
        IMAGE = new PdfName("Image");
        IMAGEB = new PdfName("ImageB");
        IMAGEC = new PdfName("ImageC");
        IMAGEI = new PdfName("ImageI");
        IMAGEMASK = new PdfName("ImageMask");
        INDEX = new PdfName("Index");
        INDEXED = new PdfName("Indexed");
        INFO = new PdfName("Info");
        INK = new PdfName("Ink");
        INKLIST = new PdfName("InkList");
        IMPORTDATA = new PdfName("ImportData");
        INTENT = new PdfName("Intent");
        INTERPOLATE = new PdfName("Interpolate");
        ISMAP = new PdfName("IsMap");
        IRT = new PdfName("IRT");
        ITALICANGLE = new PdfName("ItalicAngle");
        IX = new PdfName("IX");
        JAVASCRIPT = new PdfName("JavaScript");
        JS = new PdfName("JS");
        K = new PdfName("K");
        KEYWORDS = new PdfName("Keywords");
        KIDS = new PdfName("Kids");
        L = new PdfName("L");
        L2R = new PdfName("L2R");
        LANG = new PdfName("Lang");
        LANGUAGE = new PdfName("Language");
        LAST = new PdfName("Last");
        LASTCHAR = new PdfName("LastChar");
        LASTPAGE = new PdfName("LastPage");
        LAUNCH = new PdfName("Launch");
        LENGTH = new PdfName("Length");
        LENGTH1 = new PdfName("Length1");
        LIMITS = new PdfName("Limits");
        LINE = new PdfName("Line");
        LINK = new PdfName("Link");
        LISTMODE = new PdfName("ListMode");
        LOCATION = new PdfName("Location");
        LOCK = new PdfName("Lock");
        LZWDECODE = new PdfName("LZWDecode");
        M = new PdfName("M");
        MATRIX = new PdfName("Matrix");
        MAC_EXPERT_ENCODING = new PdfName("MacExpertEncoding");
        MAC_ROMAN_ENCODING = new PdfName("MacRomanEncoding");
        MARKED = new PdfName("Marked");
        MARKINFO = new PdfName("MarkInfo");
        MASK = new PdfName("Mask");
        MAX = new PdfName("max");
        MAXLEN = new PdfName("MaxLen");
        MEDIABOX = new PdfName("MediaBox");
        MCID = new PdfName("MCID");
        MCR = new PdfName("MCR");
        METADATA = new PdfName("Metadata");
        MIN = new PdfName("min");
        MK = new PdfName("MK");
        MMTYPE1 = new PdfName("MMType1");
        MODDATE = new PdfName("ModDate");
        N = new PdfName("N");
        N0 = new PdfName("n0");
        N1 = new PdfName("n1");
        N2 = new PdfName("n2");
        N3 = new PdfName("n3");
        N4 = new PdfName("n4");
        NAME = new PdfName("Name");
        NAMED = new PdfName("Named");
        NAMES = new PdfName("Names");
        NEEDAPPEARANCES = new PdfName("NeedAppearances");
        NEWWINDOW = new PdfName("NewWindow");
        NEXT = new PdfName("Next");
        NEXTPAGE = new PdfName("NextPage");
        NM = new PdfName("NM");
        NONE = new PdfName("None");
        NONFULLSCREENPAGEMODE = new PdfName("NonFullScreenPageMode");
        NUMS = new PdfName("Nums");
        O = new PdfName("O");
        OBJSTM = new PdfName("ObjStm");
        OC = new PdfName("OC");
        OCG = new PdfName("OCG");
        OCGS = new PdfName("OCGs");
        OCMD = new PdfName("OCMD");
        OCPROPERTIES = new PdfName("OCProperties");
        Off = new PdfName("Off");
        OFF = new PdfName("OFF");
        ON = new PdfName("ON");
        ONECOLUMN = new PdfName("OneColumn");
        OPEN = new PdfName("Open");
        OPENACTION = new PdfName("OpenAction");
        OP = new PdfName("OP");
        op = new PdfName("op");
        OPM = new PdfName("OPM");
        OPT = new PdfName("Opt");
        ORDER = new PdfName("Order");
        ORDERING = new PdfName("Ordering");
        OUTLINES = new PdfName("Outlines");
        OUTPUTCONDITION = new PdfName("OutputCondition");
        OUTPUTCONDITIONIDENTIFIER = new PdfName("OutputConditionIdentifier");
        OUTPUTINTENT = new PdfName("OutputIntent");
        OUTPUTINTENTS = new PdfName("OutputIntents");
        P = new PdfName("P");
        PAGE = new PdfName("Page");
        PAGELABELS = new PdfName("PageLabels");
        PAGELAYOUT = new PdfName("PageLayout");
        PAGEMODE = new PdfName("PageMode");
        PAGES = new PdfName("Pages");
        PAINTTYPE = new PdfName("PaintType");
        PANOSE = new PdfName("Panose");
        PARAMS = new PdfName("Params");
        PARENT = new PdfName("Parent");
        PARENTTREE = new PdfName("ParentTree");
        PATTERN = new PdfName("Pattern");
        PATTERNTYPE = new PdfName("PatternType");
        PDF = new PdfName("PDF");
        PERCEPTUAL = new PdfName("Perceptual");
        PG = new PdfName("Pg");
        POPUP = new PdfName("Popup");
        PREDICTOR = new PdfName("Predictor");
        PREFERRED = new PdfName("Preferred");
        PRESERVERB = new PdfName("PreserveRB");
        PREV = new PdfName("Prev");
        PREVPAGE = new PdfName("PrevPage");
        PRINT = new PdfName("Print");
        PRINTSCALING = new PdfName("PrintScaling");
        PRINTSTATE = new PdfName("PrintState");
        PROCSET = new PdfName("ProcSet");
        PRODUCER = new PdfName("Producer");
        PROPERTIES = new PdfName("Properties");
        PS = new PdfName("PS");
        Q = new PdfName("Q");
        QUADPOINTS = new PdfName("QuadPoints");
        R = new PdfName("R");
        R2L = new PdfName("R2L");
        RANGE = new PdfName("Range");
        RC = new PdfName("RC");
        RBGROUPS = new PdfName("RBGroups");
        REASON = new PdfName("Reason");
        RECT = new PdfName("Rect");
        REGISTRY = new PdfName("Registry");
        REGISTRYNAME = new PdfName("RegistryName");
        RELATIVECALORIMETRIC = new PdfName("RelativeColorimetric");
        RENDITION = new PdfName("Rendition");
        RESETFORM = new PdfName("ResetForm");
        RESOURCES = new PdfName("Resources");
        RI = new PdfName("RI");
        ROLEMAP = new PdfName("RoleMap");
        ROOT = new PdfName("Root");
        ROTATE = new PdfName("Rotate");
        ROWS = new PdfName("Rows");
        RUNLENGTHDECODE = new PdfName("RunLengthDecode");
        RV = new PdfName("RV");
        S = new PdfName("S");
        SATURATION = new PdfName("Saturation");
        SCREEN = new PdfName("Screen");
        SEPARATION = new PdfName("Separation");
        SETOCGSTATE = new PdfName("SetOCGState");
        SHADING = new PdfName("Shading");
        SHADINGTYPE = new PdfName("ShadingType");
        SHIFT_JIS = new PdfName("Shift-JIS");
        SIG = new PdfName("Sig");
        SIGFLAGS = new PdfName("SigFlags");
        SINGLEPAGE = new PdfName("SinglePage");
        SIZE = new PdfName("Size");
        SMASK = new PdfName("SMask");
        SPLIT = new PdfName("Split");
        SQUARE = new PdfName("Square");
        ST = new PdfName("St");
        STAMP = new PdfName("Stamp");
        STANDARD = new PdfName("Standard");
        STATE = new PdfName("State");
        STRIKEOUT = new PdfName("StrikeOut");
        STRUCTPARENT = new PdfName("StructParent");
        STRUCTPARENTS = new PdfName("StructParents");
        STRUCTTREEROOT = new PdfName("StructTreeRoot");
        STYLE = new PdfName("Style");
        STEMV = new PdfName("StemV");
        SUBFILTER = new PdfName("SubFilter");
        SUBJECT = new PdfName("Subject");
        SUBMITFORM = new PdfName("SubmitForm");
        SUBTYPE = new PdfName("Subtype");
        SUPPLEMENT = new PdfName("Supplement");
        SV = new PdfName("SV");
        SW = new PdfName("SW");
        SYMBOL = new PdfName("Symbol");
        T = new PdfName("T");
        TEXT = new PdfName("Text");
        THUMB = new PdfName("Thumb");
        THREADS = new PdfName("Threads");
        TI = new PdfName("TI");
        TILINGTYPE = new PdfName("TilingType");
        TIMES_ROMAN = new PdfName("Times-Roman");
        TIMES_BOLD = new PdfName("Times-Bold");
        TIMES_ITALIC = new PdfName("Times-Italic");
        TIMES_BOLDITALIC = new PdfName("Times-BoldItalic");
        TITLE = new PdfName("Title");
        TK = new PdfName("TK");
        TM = new PdfName("TM");
        TOGGLE = new PdfName("Toggle");
        TOUNICODE = new PdfName("ToUnicode");
        TP = new PdfName("TP");
        TRANS = new PdfName("Trans");
        TRANSPARENCY = new PdfName("Transparency");
        TRAPPED = new PdfName("Trapped");
        TRIMBOX = new PdfName("TrimBox");
        TRUETYPE = new PdfName("TrueType");
        TU = new PdfName("TU");
        TWOCOLUMNLEFT = new PdfName("TwoColumnLeft");
        TWOCOLUMNRIGHT = new PdfName("TwoColumnRight");
        TWOPAGELEFT = new PdfName("TwoPageLeft");
        TWOPAGERIGHT = new PdfName("TwoPageRight");
        TX = new PdfName("Tx");
        TYPE = new PdfName("Type");
        TYPE0 = new PdfName("Type0");
        TYPE1 = new PdfName("Type1");
        TYPE3 = new PdfName("Type3");
        U = new PdfName("U");
        UHC = new PdfName("UHC");
        UNDERLINE = new PdfName("Underline");
        URI = new PdfName("URI");
        URL = new PdfName("URL");
        USAGE = new PdfName("Usage");
        USEATTACHMENTS = new PdfName("UseAttachments");
        USENONE = new PdfName("UseNone");
        USEOC = new PdfName("UseOC");
        USEOUTLINES = new PdfName("UseOutlines");
        USER = new PdfName("User");
        USERUNIT = new PdfName("UserUnit");
        USETHUMBS = new PdfName("UseThumbs");
        V = new PdfName("V");
        VERISIGN_PPKVS = new PdfName("VeriSign.PPKVS");
        VIEW = new PdfName("View");
        VIEWERPREFERENCES = new PdfName("ViewerPreferences");
        VIEWSTATE = new PdfName("ViewState");
        VISIBLEPAGES = new PdfName("VisiblePages");
        W = new PdfName("W");
        W2 = new PdfName("W2");
        WC = new PdfName("WC");
        WIDGET = new PdfName("Widget");
        WIDTH = new PdfName("Width");
        WIDTHS = new PdfName("Widths");
        WIN = new PdfName("Win");
        WIN_ANSI_ENCODING = new PdfName("WinAnsiEncoding");
        WIPE = new PdfName("Wipe");
        WHITEPOINT = new PdfName("WhitePoint");
        WP = new PdfName("WP");
        WS = new PdfName("WS");
        X = new PdfName("X");
        XFA = new PdfName("XFA");
        XML = new PdfName("XML");
        XOBJECT = new PdfName("XObject");
        XSTEP = new PdfName("XStep");
        XREF = new PdfName("XRef");
        XREFSTM = new PdfName("XRefStm");
        XYZ = new PdfName("XYZ");
        YSTEP = new PdfName("YStep");
        ZAPFDINGBATS = new PdfName("ZapfDingbats");
        ZOOM = new PdfName("Zoom");
    }

    public PdfName(byte[] bytes) {
        super(4, bytes);
    }

    public PdfName(String name, boolean lengthCheck) {
        super(4);
        int length = name.length();
        if (lengthCheck && length > 127) {
            throw new IllegalArgumentException("The name '" + name + "' is too long (" + length + " characters).");
        }
        ByteBuffer pdfName = new ByteBuffer(length + 20);
        pdfName.append('/');
        char[] chars = name.toCharArray();
        int index = 0;
        while (index < length) {
            char character = (char)(chars[index] & 0xFF);
            switch (character) {
                case ' ': 
                case '#': 
                case '%': 
                case '(': 
                case ')': 
                case '/': 
                case '<': 
                case '>': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    pdfName.append('#');
                    pdfName.append(Integer.toString(character, 16));
                    break;
                }
                default: {
                    if (character > '~' || character < ' ') {
                        pdfName.append('#');
                        if (character < '\u0010') {
                            pdfName.append('0');
                        }
                        pdfName.append(Integer.toString(character, 16));
                        break;
                    }
                    pdfName.append(character);
                }
            }
            ++index;
        }
        this.bytes = pdfName.toByteArray();
    }

    public PdfName(String name) {
        this(name, true);
    }

    public int compareTo(Object object) {
        PdfName name = (PdfName)object;
        byte[] myBytes = this.bytes;
        byte[] objBytes = name.bytes;
        int len = Math.min(myBytes.length, objBytes.length);
        int i = 0;
        while (i < len) {
            if (myBytes[i] > objBytes[i]) {
                return 1;
            }
            if (myBytes[i] < objBytes[i]) {
                return -1;
            }
            ++i;
        }
        if (myBytes.length < objBytes.length) {
            return -1;
        }
        if (myBytes.length > objBytes.length) {
            return 1;
        }
        return 0;
    }

    public static String decodeName(String name) {
        StringBuffer buf = new StringBuffer();
        try {
            int len = name.length();
            int k = 1;
            while (k < len) {
                char c = name.charAt(k);
                if (c == '#') {
                    c = (char)((PRTokeniser.getHex(name.charAt(k + 1)) << 4) + PRTokeniser.getHex(name.charAt(k + 2)));
                    k += 2;
                }
                buf.append(c);
                ++k;
            }
        }
        catch (IndexOutOfBoundsException e) {}
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PdfName) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int ptr = 0;
            int len = this.bytes.length;
            int i = 0;
            while (i < len) {
                h = 31 * h + (this.bytes[ptr++] & 0xFF);
                ++i;
            }
            this.hash = h;
        }
        return h;
    }
}

