/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.pdf.PdfArray;
import com.lowagie2.text.pdf.PdfDate;
import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfNumber;
import com.lowagie2.text.pdf.PdfString;

public class PdfSignature
extends PdfDictionary {
    public PdfSignature(PdfName filter, PdfName subFilter) {
        super(PdfName.SIG);
        this.put(PdfName.FILTER, filter);
        this.put(PdfName.SUBFILTER, subFilter);
    }

    public void setByteRange(int[] range) {
        PdfArray array = new PdfArray();
        int k = 0;
        while (k < range.length) {
            array.add(new PdfNumber(range[k]));
            ++k;
        }
        this.put(PdfName.BYTERANGE, array);
    }

    public void setCert(byte[] cert) {
        this.put(PdfName.CERT, new PdfString(cert));
    }

    public void setContact(String name) {
        this.put(PdfName.CONTACTINFO, new PdfString(name, "UnicodeBig"));
    }

    public void setContents(byte[] contents) {
        this.put(PdfName.CONTENTS, new PdfString(contents).setHexWriting(true));
    }

    public void setDate(PdfDate date) {
        this.put(PdfName.M, date);
    }

    public void setLocation(String name) {
        this.put(PdfName.LOCATION, new PdfString(name, "UnicodeBig"));
    }

    public void setName(String name) {
        this.put(PdfName.NAME, new PdfString(name, "UnicodeBig"));
    }

    public void setReason(String name) {
        this.put(PdfName.REASON, new PdfString(name, "UnicodeBig"));
    }
}

