/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.DocWriter;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.ExceptionConverter;
import com.lowagie2.text.Image;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.pdf.AcroFields;
import com.lowagie2.text.pdf.ByteBuffer;
import com.lowagie2.text.pdf.FdfReader;
import com.lowagie2.text.pdf.PdfAction;
import com.lowagie2.text.pdf.PdfAnnotation;
import com.lowagie2.text.pdf.PdfContentByte;
import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfEncodings;
import com.lowagie2.text.pdf.PdfException;
import com.lowagie2.text.pdf.PdfFileSpecification;
import com.lowagie2.text.pdf.PdfImportedPage;
import com.lowagie2.text.pdf.PdfLiteral;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfReader;
import com.lowagie2.text.pdf.PdfSigGenericPKCS;
import com.lowagie2.text.pdf.PdfSignatureAppearance;
import com.lowagie2.text.pdf.PdfStamperImp;
import com.lowagie2.text.pdf.PdfString;
import com.lowagie2.text.pdf.PdfTransition;
import com.lowagie2.text.pdf.PdfWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PdfStamper {
    private boolean hasSignature;
    private HashMap moreInfo;
    private PdfSignatureAppearance sigApp;
    protected PdfStamperImp stamper;

    public PdfStamper(PdfReader reader, OutputStream os, char pdfVersion, boolean append) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(reader, os, pdfVersion, append);
    }

    public PdfStamper(PdfReader reader, OutputStream os, char pdfVersion) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(reader, os, pdfVersion, false);
    }

    public PdfStamper(PdfReader reader, OutputStream os) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(reader, os, '\u0000', false);
    }

    public void addAnnotation(PdfAnnotation annot, int page) {
        this.stamper.addAnnotation(annot, page);
    }

    public void addComments(FdfReader fdf) throws IOException {
        this.stamper.addComments(fdf);
    }

    public void addFileAttachment(String description, PdfFileSpecification fs) throws IOException {
        this.stamper.addFileAttachment(description, fs);
    }

    public void addFileAttachment(String description, byte[] fileStore, String file, String fileDisplay) throws IOException {
        this.addFileAttachment(description, PdfFileSpecification.fileEmbedded(this.stamper, file, fileDisplay, fileStore));
    }

    public void addJavaScript(String js) {
        this.stamper.addJavaScript(js, !PdfEncodings.isPdfDocEncoding(js));
    }

    /*
     * WARNING - void declaration
     */
    public void close() throws DocumentException, IOException {
        if (!this.hasSignature) {
            this.stamper.close(this.moreInfo);
            return;
        }
        this.sigApp.preClose();
        PdfSigGenericPKCS sig = this.sigApp.getSigStandard();
        PdfLiteral lit = (PdfLiteral)sig.get(PdfName.CONTENTS);
        int totalBuf = (lit.getPosLength() - 2) / 2;
        byte[] buf = new byte[8192];
        InputStream inp = this.sigApp.getRangeStream();
        try {
            int n;
            while ((n = inp.read(buf)) > 0) {
                void var5_6;
                sig.getSigner().update(buf, 0, (int)var5_6);
            }
        }
        catch (SignatureException se) {
            throw new ExceptionConverter(se);
        }
        buf = new byte[totalBuf];
        byte[] bsig = sig.getSignerContents();
        System.arraycopy(bsig, 0, buf, 0, bsig.length);
        PdfString str = new PdfString(buf);
        str.setHexWriting(true);
        PdfDictionary dic = new PdfDictionary();
        dic.put(PdfName.CONTENTS, str);
        this.sigApp.close(dic);
        this.stamper.reader.close();
    }

    public static PdfStamper createSignature(PdfReader reader, OutputStream os, char pdfVersion, File tempFile) throws DocumentException, IOException {
        return PdfStamper.createSignature(reader, os, pdfVersion, tempFile, false);
    }

    public static PdfStamper createSignature(PdfReader reader, OutputStream os, char pdfVersion) throws DocumentException, IOException {
        return PdfStamper.createSignature(reader, os, pdfVersion, null, false);
    }

    public static PdfStamper createSignature(PdfReader reader, OutputStream os, char pdfVersion, File tempFile, boolean append) throws DocumentException, IOException {
        PdfStamper stp;
        if (tempFile == null) {
            ByteBuffer bout = new ByteBuffer();
            stp = new PdfStamper(reader, bout, pdfVersion, append);
            stp.sigApp = new PdfSignatureAppearance(stp.stamper);
            stp.sigApp.setSigout(bout);
        } else {
            if (tempFile.isDirectory()) {
                tempFile = File.createTempFile("pdf", null, tempFile);
            }
            FileOutputStream fout = new FileOutputStream(tempFile);
            stp = new PdfStamper(reader, fout, pdfVersion, append);
            stp.sigApp = new PdfSignatureAppearance(stp.stamper);
            stp.sigApp.setTempFile(tempFile);
        }
        stp.sigApp.setOriginalout(os);
        stp.sigApp.setStamper(stp);
        stp.hasSignature = true;
        return stp;
    }

    public AcroFields getAcroFields() {
        return this.stamper.getAcroFields();
    }

    public PdfImportedPage getImportedPage(PdfReader reader, int pageNumber) {
        return this.stamper.getImportedPage(reader, pageNumber);
    }

    public HashMap getMoreInfo() {
        return this.moreInfo;
    }

    private String getNewSigName() {
        AcroFields af = this.getAcroFields();
        String name = "Signature";
        int step = 0;
        boolean found = false;
        block0: while (!found) {
            String n1 = name + ++step;
            if (af.getFieldItem(n1) != null) continue;
            n1 = n1 + ".";
            found = true;
            Iterator it = af.getFields().keySet().iterator();
            while (it.hasNext()) {
                String fn = (String)it.next();
                if (!fn.startsWith(n1)) continue;
                found = false;
                continue block0;
            }
        }
        name = name + step;
        return name;
    }

    public PdfContentByte getOverContent(int pageNum) {
        return this.stamper.getOverContent(pageNum);
    }

    public PdfReader getReader() {
        return this.stamper.reader;
    }

    public PdfSignatureAppearance getSignatureAppearance() {
        return this.sigApp;
    }

    public PdfContentByte getUnderContent(int pageNum) {
        return this.stamper.getUnderContent(pageNum);
    }

    public PdfWriter getWriter() {
        return this.stamper;
    }

    private static int indexArray(byte[] bout, int position, String search) {
        byte[] ss = PdfEncodings.convertToBytes(search, null);
        while (true) {
            int k = 0;
            while (k < ss.length) {
                if (ss[k] != bout[position + k]) break;
                ++k;
            }
            if (k == ss.length) {
                return position;
            }
            ++position;
        }
    }

    private static int indexFile(RandomAccessFile raf, int position, String search) throws IOException {
        byte[] ss = PdfEncodings.convertToBytes(search, null);
        while (true) {
            raf.seek(position);
            int k = 0;
            while (k < ss.length) {
                int b = raf.read();
                if (b < 0) {
                    throw new EOFException("Unexpected EOF");
                }
                if (ss[k] != (byte)b) break;
                ++k;
            }
            if (k == ss.length) {
                return position;
            }
            ++position;
        }
    }

    public void insertPage(int pageNumber, Rectangle mediabox) {
        this.stamper.insertPage(pageNumber, mediabox);
    }

    public boolean isFullCompression() {
        return this.stamper.isFullCompression();
    }

    public boolean isRotateContents() {
        return this.stamper.isRotateContents();
    }

    public boolean partialFormFlattening(String name) {
        return this.stamper.partialFormFlattening(name);
    }

    public void setDuration(int seconds, int page) {
        this.stamper.setDuration(seconds, page);
    }

    public void setEncryption(boolean strength, String userPassword, String ownerPassword, int permissions) throws DocumentException {
        this.setEncryption(DocWriter.getISOBytes(userPassword), DocWriter.getISOBytes(ownerPassword), permissions, strength);
    }

    public void setEncryption(byte[] userPassword, byte[] ownerPassword, int permissions, boolean strength128Bits) throws DocumentException {
        if (this.stamper.isAppend()) {
            throw new DocumentException("Append mode does not support changing the encryption status.");
        }
        if (this.stamper.isContentWritten()) {
            throw new DocumentException("Content was already written to the output.");
        }
        this.stamper.setEncryption(userPassword, ownerPassword, permissions, strength128Bits);
    }

    public void setFormFlattening(boolean flat) {
        this.stamper.setFormFlattening(flat);
    }

    public void setFreeTextFlattening(boolean flat) {
        this.stamper.setFreeTextFlattening(flat);
    }

    public void setFullCompression() {
        if (this.stamper.isAppend()) {
            return;
        }
        this.stamper.setFullCompression();
    }

    public void setMoreInfo(HashMap moreInfo) {
        this.moreInfo = moreInfo;
    }

    public void setOutlines(List outlines) throws IOException {
        this.stamper.setOutlines(outlines);
    }

    public void setPageAction(PdfName actionType, PdfAction action, int page) throws PdfException {
        this.stamper.setPageAction(actionType, action, page);
    }

    public void setRotateContents(boolean rotateContents) {
        this.stamper.setRotateContents(rotateContents);
    }

    public void setThumbnail(Image image, int page) throws PdfException, DocumentException {
        this.stamper.setThumbnail(image, page);
    }

    public void setTransition(PdfTransition transition, int page) {
        this.stamper.setTransition(transition, page);
    }

    public void setViewerPreferences(int preferences) {
        this.stamper.setViewerPreferences(preferences);
    }

    public void setXmpMetadata(byte[] xmp) {
        this.stamper.setXmpMetadata(xmp);
    }
}

