/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.Cell;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.Row;
import com.lowagie2.text.Table;
import com.lowagie2.text.pdf.PdfCell;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfTable
extends Rectangle {
    private ArrayList cells;
    private int columns;
    private ArrayList headercells;
    protected float[] positions;
    protected Table table;

    PdfTable(Table table, float left, float right, float top, boolean supportUpdateRowAdditions) {
        super(left, top, right, top);
        this.table = table;
        table.complete();
        this.cloneNonPositionParameters(table);
        this.columns = table.columns();
        this.positions = table.getWidths(left, right - left);
        this.setLeft(this.positions[0]);
        this.setRight(this.positions[this.positions.length - 1]);
        this.headercells = new ArrayList();
        this.cells = new ArrayList();
        this.updateRowAdditionsInternal();
        if (supportUpdateRowAdditions) {
            table.deleteAllRows();
        }
    }

    final float cellpadding() {
        return this.table.cellpadding();
    }

    final float cellspacing() {
        return this.table.cellspacing();
    }

    int columns() {
        return this.columns;
    }

    ArrayList getCells() {
        return this.cells;
    }

    ArrayList getHeaderCells() {
        return this.headercells;
    }

    public float getOffset() {
        return this.table.getOffset();
    }

    boolean hasHeader() {
        return this.headercells.size() > 0;
    }

    public final boolean hasToFitPageCells() {
        return this.table.hasToFitPageCells();
    }

    public final boolean hasToFitPageTable() {
        return this.table.hasToFitPageTable();
    }

    int rows() {
        return this.cells.size() == 0 ? 0 : ((PdfCell)this.cells.get(this.cells.size() - 1)).rownumber() + 1;
    }

    public int type() {
        return 22;
    }

    void updateRowAdditions() {
        this.table.complete();
        this.updateRowAdditionsInternal();
        this.table.deleteAllRows();
    }

    private void updateRowAdditionsInternal() {
        PdfCell currentCell;
        int prevRows = this.rows();
        int rowNumber = 0;
        int groupNumber = 0;
        int firstDataRow = this.table.firstDataRow();
        ArrayList<PdfCell> newCells = new ArrayList<PdfCell>();
        int rows = this.table.size() + 1;
        float[] offsets = new float[rows];
        int i = 0;
        while (i < rows) {
            offsets[i] = this.bottom();
            ++i;
        }
        Iterator rowIterator = this.table.iterator();
        while (rowIterator.hasNext()) {
            boolean groupChange = false;
            Row row = (Row)rowIterator.next();
            if (row.isEmpty()) {
                if (rowNumber < rows - 1 && offsets[rowNumber + 1] > offsets[rowNumber]) {
                    offsets[rowNumber + 1] = offsets[rowNumber];
                }
            } else {
                int i2 = 0;
                while (i2 < row.columns()) {
                    Cell cell = (Cell)row.getCell(i2);
                    if (cell != null) {
                        block14: {
                            currentCell = new PdfCell(cell, rowNumber + prevRows, this.positions[i2], this.positions[i2 + cell.colspan()], offsets[rowNumber], this.cellspacing(), this.cellpadding());
                            try {
                                if (offsets[rowNumber] - currentCell.height() - this.cellpadding() < offsets[rowNumber + currentCell.rowspan()]) {
                                    offsets[rowNumber + currentCell.rowspan()] = offsets[rowNumber] - currentCell.height() - this.cellpadding();
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException aioobe) {
                                if (!(offsets[rowNumber] - currentCell.height() < offsets[rows - 1])) break block14;
                                offsets[rows - 1] = offsets[rowNumber] - currentCell.height();
                            }
                        }
                        if (rowNumber < firstDataRow) {
                            currentCell.setHeader();
                            this.headercells.add(currentCell);
                        }
                        currentCell.setGroupNumber(groupNumber);
                        groupChange |= cell.getGroupChange();
                        newCells.add(currentCell);
                    }
                    ++i2;
                }
            }
            ++rowNumber;
            if (!groupChange) continue;
            ++groupNumber;
        }
        int n = newCells.size();
        int i3 = 0;
        while (i3 < n) {
            currentCell = (PdfCell)newCells.get(i3);
            try {
                currentCell.setBottom(offsets[currentCell.rownumber() - prevRows + currentCell.rowspan()]);
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                currentCell.setBottom(offsets[rows - 1]);
            }
            ++i3;
        }
        this.cells.addAll(newCells);
        this.setBottom(offsets[rows - 1]);
    }
}

