/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.DocumentException;
import com.lowagie2.text.ExceptionConverter;
import com.lowagie2.text.pdf.PdfEncodings;
import com.lowagie2.text.pdf.RandomAccessFileOrArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

class TrueTypeFontSubSet {
    static final int ARG_1_AND_2_ARE_WORDS = 1;
    static final int HEAD_LOCA_FORMAT_OFFSET = 51;
    static final int MORE_COMPONENTS = 32;
    static final int TABLE_CHECKSUM = 0;
    static final int TABLE_LENGTH = 2;
    static final int TABLE_OFFSET = 1;
    static final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
    static final int WE_HAVE_A_SCALE = 8;
    static final int WE_HAVE_A_TWO_BY_TWO = 128;
    protected int directoryOffset;
    static final int[] entrySelectors;
    protected String fileName;
    protected int fontPtr;
    protected int glyfTableRealSize;
    protected ArrayList glyphsInList;
    protected HashMap glyphsUsed;
    protected boolean includeCmap;
    protected boolean includeExtras;
    protected boolean locaShortTable;
    protected int[] locaTable;
    protected int locaTableRealSize;
    protected byte[] newGlyfTable;
    protected int[] newLocaTable;
    protected byte[] newLocaTableOut;
    protected byte[] outFont;
    protected RandomAccessFileOrArray rf;
    protected HashMap tableDirectory;
    protected int tableGlyphOffset;
    static final String[] tableNamesCmap;
    static final String[] tableNamesExtra;
    static final String[] tableNamesSimple;

    static {
        tableNamesSimple = new String[]{"cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "prep"};
        tableNamesCmap = new String[]{"cmap", "cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "prep"};
        tableNamesExtra = new String[]{"OS/2", "cmap", "cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "name, prep"};
        entrySelectors = new int[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4};
    }

    TrueTypeFontSubSet(String fileName, RandomAccessFileOrArray rf, HashMap glyphsUsed, int directoryOffset, boolean includeCmap, boolean includeExtras) {
        this.fileName = fileName;
        this.rf = rf;
        this.glyphsUsed = glyphsUsed;
        this.includeCmap = includeCmap;
        this.includeExtras = includeExtras;
        this.directoryOffset = directoryOffset;
        this.glyphsInList = new ArrayList(glyphsUsed.keySet());
    }

    protected void assembleFont() throws IOException, DocumentException {
        int[] tableLocation;
        int fullFontSize = 0;
        String[] tableNames = this.includeExtras ? tableNamesExtra : (this.includeCmap ? tableNamesCmap : tableNamesSimple);
        int tablesUsed = 2;
        int len = 0;
        int k = 0;
        while (k < tableNames.length) {
            String name = tableNames[k];
            if (!name.equals("glyf") && !name.equals("loca") && (tableLocation = (int[])this.tableDirectory.get(name)) != null) {
                ++tablesUsed;
                fullFontSize += tableLocation[2] + 3 & 0xFFFFFFFC;
            }
            ++k;
        }
        fullFontSize += this.newLocaTableOut.length;
        fullFontSize += this.newGlyfTable.length;
        int ref = 16 * tablesUsed + 12;
        this.outFont = new byte[fullFontSize += ref];
        this.fontPtr = 0;
        this.writeFontInt(65536);
        this.writeFontShort(tablesUsed);
        int selector = entrySelectors[tablesUsed];
        this.writeFontShort((1 << selector) * 16);
        this.writeFontShort(selector);
        this.writeFontShort((tablesUsed - (1 << selector)) * 16);
        int k2 = 0;
        while (k2 < tableNames.length) {
            String name = tableNames[k2];
            tableLocation = (int[])this.tableDirectory.get(name);
            if (tableLocation != null) {
                this.writeFontString(name);
                if (name.equals("glyf")) {
                    this.writeFontInt(this.calculateChecksum(this.newGlyfTable));
                    len = this.glyfTableRealSize;
                } else if (name.equals("loca")) {
                    this.writeFontInt(this.calculateChecksum(this.newLocaTableOut));
                    len = this.locaTableRealSize;
                } else {
                    this.writeFontInt(tableLocation[0]);
                    len = tableLocation[2];
                }
                this.writeFontInt(ref);
                this.writeFontInt(len);
                ref += len + 3 & 0xFFFFFFFC;
            }
            ++k2;
        }
        int k3 = 0;
        while (k3 < tableNames.length) {
            String name = tableNames[k3];
            tableLocation = (int[])this.tableDirectory.get(name);
            if (tableLocation != null) {
                if (name.equals("glyf")) {
                    System.arraycopy(this.newGlyfTable, 0, this.outFont, this.fontPtr, this.newGlyfTable.length);
                    this.fontPtr += this.newGlyfTable.length;
                    this.newGlyfTable = null;
                } else if (name.equals("loca")) {
                    System.arraycopy(this.newLocaTableOut, 0, this.outFont, this.fontPtr, this.newLocaTableOut.length);
                    this.fontPtr += this.newLocaTableOut.length;
                    this.newLocaTableOut = null;
                } else {
                    this.rf.seek(tableLocation[1]);
                    this.rf.readFully(this.outFont, this.fontPtr, tableLocation[2]);
                    this.fontPtr += tableLocation[2] + 3 & 0xFFFFFFFC;
                }
            }
            ++k3;
        }
    }

    protected int calculateChecksum(byte[] b) {
        int len = b.length / 4;
        int v0 = 0;
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        int ptr = 0;
        int k = 0;
        while (k < len) {
            v3 += b[ptr++] & 0xFF;
            v2 += b[ptr++] & 0xFF;
            v1 += b[ptr++] & 0xFF;
            v0 += b[ptr++] & 0xFF;
            ++k;
        }
        return v0 + (v1 << 8) + (v2 << 16) + (v3 << 24);
    }

    protected void checkGlyphComposite(int glyph) throws IOException {
        int start = this.locaTable[glyph];
        if (start == this.locaTable[glyph + 1]) {
            return;
        }
        this.rf.seek(this.tableGlyphOffset + start);
        short numContours = this.rf.readShort();
        if (numContours >= 0) {
            return;
        }
        this.rf.skipBytes(8);
        while (true) {
            int flags = this.rf.readUnsignedShort();
            Integer cGlyph = new Integer(this.rf.readUnsignedShort());
            if (!this.glyphsUsed.containsKey(cGlyph)) {
                this.glyphsUsed.put(cGlyph, null);
                this.glyphsInList.add(cGlyph);
            }
            if ((flags & 0x20) == 0) {
                return;
            }
            int skip = (flags & 1) != 0 ? 4 : 2;
            if ((flags & 8) != 0) {
                skip += 2;
            } else if ((flags & 0x40) != 0) {
                skip += 4;
            }
            if ((flags & 0x80) != 0) {
                skip += 8;
            }
            this.rf.skipBytes(skip);
        }
    }

    protected void createNewGlyphTables() throws IOException {
        this.newLocaTable = new int[this.locaTable.length];
        int[] activeGlyphs = new int[this.glyphsInList.size()];
        int k = 0;
        while (k < activeGlyphs.length) {
            activeGlyphs[k] = (Integer)this.glyphsInList.get(k);
            ++k;
        }
        Arrays.sort(activeGlyphs);
        int glyfSize = 0;
        int k2 = 0;
        while (k2 < activeGlyphs.length) {
            int glyph = activeGlyphs[k2];
            glyfSize += this.locaTable[glyph + 1] - this.locaTable[glyph];
            ++k2;
        }
        this.glyfTableRealSize = glyfSize;
        glyfSize = glyfSize + 3 & 0xFFFFFFFC;
        this.newGlyfTable = new byte[glyfSize];
        int glyfPtr = 0;
        int listGlyf = 0;
        int k3 = 0;
        while (k3 < this.newLocaTable.length) {
            this.newLocaTable[k3] = glyfPtr;
            if (listGlyf < activeGlyphs.length && activeGlyphs[listGlyf] == k3) {
                ++listGlyf;
                this.newLocaTable[k3] = glyfPtr;
                int start = this.locaTable[k3];
                int len = this.locaTable[k3 + 1] - start;
                if (len > 0) {
                    this.rf.seek(this.tableGlyphOffset + start);
                    this.rf.readFully(this.newGlyfTable, glyfPtr, len);
                    glyfPtr += len;
                }
            }
            ++k3;
        }
    }

    protected void createTableDirectory() throws IOException, DocumentException {
        this.tableDirectory = new HashMap();
        this.rf.seek(this.directoryOffset);
        int id = this.rf.readInt();
        if (id != 65536) {
            throw new DocumentException(this.fileName + " is not a true type file.");
        }
        int num_tables = this.rf.readUnsignedShort();
        this.rf.skipBytes(6);
        int k = 0;
        while (k < num_tables) {
            String tag = this.readStandardString(4);
            int[] tableLocation = new int[]{this.rf.readInt(), this.rf.readInt(), this.rf.readInt()};
            this.tableDirectory.put(tag, tableLocation);
            ++k;
        }
    }

    protected void flatGlyphs() throws IOException, DocumentException {
        int[] tableLocation = (int[])this.tableDirectory.get("glyf");
        if (tableLocation == null) {
            throw new DocumentException("Table 'glyf' does not exist in " + this.fileName);
        }
        Integer glyph0 = new Integer(0);
        if (!this.glyphsUsed.containsKey(glyph0)) {
            this.glyphsUsed.put(glyph0, null);
            this.glyphsInList.add(glyph0);
        }
        this.tableGlyphOffset = tableLocation[1];
        int k = 0;
        while (k < this.glyphsInList.size()) {
            int glyph = (Integer)this.glyphsInList.get(k);
            this.checkGlyphComposite(glyph);
            ++k;
        }
    }

    protected void locaTobytes() {
        this.locaTableRealSize = this.locaShortTable ? this.newLocaTable.length * 2 : this.newLocaTable.length * 4;
        this.newLocaTableOut = new byte[this.locaTableRealSize + 3 & 0xFFFFFFFC];
        this.outFont = this.newLocaTableOut;
        this.fontPtr = 0;
        int k = 0;
        while (k < this.newLocaTable.length) {
            if (this.locaShortTable) {
                this.writeFontShort(this.newLocaTable[k] / 2);
            } else {
                this.writeFontInt(this.newLocaTable[k]);
            }
            ++k;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] process() throws IOException, DocumentException {
        byte[] byArray;
        try {
            this.rf.reOpen();
            this.createTableDirectory();
            this.readLoca();
            this.flatGlyphs();
            this.createNewGlyphTables();
            this.locaTobytes();
            this.assembleFont();
            byArray = this.outFont;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                this.rf.close();
            }
            catch (Exception e) {
            }
            throw throwable;
        }
        try {
            this.rf.close();
        }
        catch (Exception e) {
        }
        return byArray;
    }

    protected void readLoca() throws IOException, DocumentException {
        int[] tableLocation = (int[])this.tableDirectory.get("head");
        if (tableLocation == null) {
            throw new DocumentException("Table 'head' does not exist in " + this.fileName);
        }
        this.rf.seek(tableLocation[1] + 51);
        this.locaShortTable = this.rf.readUnsignedShort() == 0;
        tableLocation = (int[])this.tableDirectory.get("loca");
        if (tableLocation == null) {
            throw new DocumentException("Table 'loca' does not exist in " + this.fileName);
        }
        this.rf.seek(tableLocation[1]);
        if (this.locaShortTable) {
            int entries = tableLocation[2] / 2;
            this.locaTable = new int[entries];
            int k = 0;
            while (k < entries) {
                this.locaTable[k] = this.rf.readUnsignedShort() * 2;
                ++k;
            }
        } else {
            int entries = tableLocation[2] / 4;
            this.locaTable = new int[entries];
            int k = 0;
            while (k < entries) {
                this.locaTable[k] = this.rf.readInt();
                ++k;
            }
        }
    }

    protected String readStandardString(int length) throws IOException {
        byte[] buf = new byte[length];
        this.rf.readFully(buf);
        try {
            return new String(buf, "Cp1252");
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    protected void writeFontInt(int n) {
        this.outFont[this.fontPtr++] = (byte)(n >> 24);
        this.outFont[this.fontPtr++] = (byte)(n >> 16);
        this.outFont[this.fontPtr++] = (byte)(n >> 8);
        this.outFont[this.fontPtr++] = (byte)n;
    }

    protected void writeFontShort(int n) {
        this.outFont[this.fontPtr++] = (byte)(n >> 8);
        this.outFont[this.fontPtr++] = (byte)n;
    }

    protected void writeFontString(String s) {
        byte[] b = PdfEncodings.convertToBytes(s, "Cp1252");
        System.arraycopy(b, 0, this.outFont, this.fontPtr, b.length);
        this.fontPtr += b.length;
    }
}

