/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf;

import com.lowagie2.text.Chunk;
import com.lowagie2.text.Font;
import com.lowagie2.text.rtf.RtfField;
import com.lowagie2.text.rtf.RtfWriter;
import java.io.IOException;
import java.io.OutputStream;

abstract class AbstractRtfField
extends Chunk
implements RtfField {
    private static final byte[] fldAlt;
    private static final byte[] fldDirty;
    private static final byte[] fldEdit;
    private static final byte[] fldLock;
    private static final byte[] fldPriv;
    private boolean rtfFieldIsAlt = false;
    private boolean rtfFieldIsDirty = false;
    private boolean rtfFieldIsLocked = false;
    private boolean rtfFieldIsPrivate = false;
    private boolean rtfFieldWasEdited = false;

    static {
        fldDirty = "\\flddirty".getBytes();
        fldPriv = "\\fldpriv".getBytes();
        fldLock = "\\fldlock".getBytes();
        fldEdit = "\\fldedit".getBytes();
        fldAlt = "\\fldalt".getBytes();
    }

    public AbstractRtfField(String content, Font font) {
        super(content, font);
    }

    public final String content() {
        return "";
    }

    public final boolean isAlt() {
        return this.rtfFieldIsAlt;
    }

    public final boolean isDirty() {
        return this.rtfFieldIsDirty;
    }

    public final boolean isLocked() {
        return this.rtfFieldIsLocked;
    }

    public final boolean isPrivate() {
        return this.rtfFieldIsPrivate;
    }

    public final void setAlt(boolean rtfFieldIsAlt) {
        this.rtfFieldIsAlt = rtfFieldIsAlt;
    }

    public final void setDirty(boolean rtfFieldIsDirty) {
        this.rtfFieldIsDirty = rtfFieldIsDirty;
    }

    public final void setEdited(boolean rtfFieldWasEdited) {
        this.rtfFieldWasEdited = rtfFieldWasEdited;
    }

    public final void setLocked(boolean rtfFieldIsLocked) {
        this.rtfFieldIsLocked = rtfFieldIsLocked;
    }

    public final void setPrivate(boolean rtfFieldIsPrivate) {
        this.rtfFieldIsPrivate = rtfFieldIsPrivate;
    }

    public final boolean wasEdited() {
        return this.rtfFieldWasEdited;
    }

    public void write(RtfWriter writer, OutputStream out) throws IOException {
        this.writeRtfFieldBegin(out);
        this.writeRtfFieldModifiers(out);
        this.writeRtfFieldInstBegin(out);
        writer.writeInitialFontSignature(out, this);
        this.writeRtfFieldInitializationStuff(out);
        this.writeRtfFieldInstEnd(out);
        this.writeRtfFieldResultBegin(out);
        writer.writeInitialFontSignature(out, this);
        this.writeRtfFieldResultStuff(out);
        this.writeRtfFieldResultEnd(out);
        this.writeRtfFieldEnd(out);
    }

    protected final void writeRtfFieldBegin(OutputStream out) throws IOException {
        out.write(123);
        out.write(92);
        out.write(RtfWriter.field);
    }

    protected final void writeRtfFieldEnd(OutputStream out) throws IOException {
        out.write(125);
    }

    public abstract void writeRtfFieldInitializationStuff(OutputStream var1) throws IOException;

    protected final void writeRtfFieldInstBegin(OutputStream out) throws IOException {
        out.write(123);
        out.write(92);
        out.write(RtfWriter.fieldContent);
        out.write(32);
    }

    protected final void writeRtfFieldInstEnd(OutputStream out) throws IOException {
        if (this.isAlt()) {
            out.write(fldAlt);
            out.write(32);
        }
        out.write(125);
    }

    protected final void writeRtfFieldModifiers(OutputStream out) throws IOException {
        if (this.isDirty()) {
            out.write(fldDirty);
        }
        if (this.wasEdited()) {
            out.write(fldEdit);
        }
        if (this.isLocked()) {
            out.write(fldLock);
        }
        if (this.isPrivate()) {
            out.write(fldPriv);
        }
    }

    protected final void writeRtfFieldResultBegin(OutputStream out) throws IOException {
        out.write(123);
        out.write(92);
        out.write(RtfWriter.fieldDisplay);
        out.write(32);
    }

    protected final void writeRtfFieldResultEnd(OutputStream out) throws IOException {
        out.write(32);
        out.write(125);
    }

    public abstract void writeRtfFieldResultStuff(OutputStream var1) throws IOException;
}

