/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.document;

import com.lowagie2.text.Meta;
import com.lowagie2.text.rtf.RtfBasicElement;
import com.lowagie2.text.rtf.RtfElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RtfInfoElement
extends RtfElement {
    private static final byte[] INFO_AUTHOR = "\\author".getBytes();
    private static final byte[] INFO_CREATION_DATE;
    private static final byte[] INFO_KEYWORDS;
    private static final byte[] INFO_PRODUCER;
    private static final byte[] INFO_SUBJECT;
    private static final byte[] INFO_TITLE;
    private String content = "";
    private int infoType = -1;

    static {
        INFO_SUBJECT = "\\subject".getBytes();
        INFO_KEYWORDS = "\\keywords".getBytes();
        INFO_TITLE = "\\title".getBytes();
        INFO_PRODUCER = "\\operator".getBytes();
        INFO_CREATION_DATE = "\\creationdate".getBytes();
    }

    public RtfInfoElement(RtfDocument doc, Meta meta) {
        super(doc);
        this.infoType = meta.type();
        this.content = meta.content();
    }

    private String convertDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        try {
            Date creationDate = sdf.parse(date);
            sdf = new SimpleDateFormat("\\'yr'yyyy\\'mo'MM\\'dy'dd\\'hr'HH\\'min'mm\\'sec'ss");
            return sdf.format(creationDate);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            return "";
        }
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(RtfBasicElement.OPEN_GROUP);
            switch (this.infoType) {
                case 4: {
                    result.write(INFO_AUTHOR);
                    break;
                }
                case 2: {
                    result.write(INFO_SUBJECT);
                    break;
                }
                case 3: {
                    result.write(INFO_KEYWORDS);
                    break;
                }
                case 1: {
                    result.write(INFO_TITLE);
                    break;
                }
                case 5: {
                    result.write(INFO_PRODUCER);
                    break;
                }
                case 6: {
                    result.write(INFO_CREATION_DATE);
                    break;
                }
                default: {
                    result.write(INFO_AUTHOR);
                }
            }
            result.write(RtfBasicElement.DELIMITER);
            if (this.infoType == 6) {
                result.write(this.convertDate(this.content).getBytes());
            } else {
                result.write(this.content.getBytes());
            }
            result.write(RtfBasicElement.CLOSE_GROUP);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

