/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.field;

import com.lowagie2.text.Chunk;
import com.lowagie2.text.Font;
import com.lowagie2.text.rtf.RtfBasicElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.style.RtfFont;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class RtfField
extends Chunk
implements RtfBasicElement {
    private static final byte[] FIELD = "\\field".getBytes();
    private static final byte[] FIELD_ALT;
    private static final byte[] FIELD_DIRTY;
    private static final byte[] FIELD_EDIT;
    private static final byte[] FIELD_INSTRUCTIONS;
    private static final byte[] FIELD_LOCKED;
    private static final byte[] FIELD_PRIVATE;
    private static final byte[] FIELD_RESULT;
    protected RtfDocument document = null;
    private boolean fieldAlt = false;
    private boolean fieldDirty = false;
    private boolean fieldEdit = false;
    private boolean fieldLocked = false;
    private boolean fieldPrivate = false;
    private RtfFont font = null;
    private boolean inHeader = false;
    private boolean inTable = false;

    static {
        FIELD_DIRTY = "\\flddirty".getBytes();
        FIELD_PRIVATE = "\\fldpriv".getBytes();
        FIELD_LOCKED = "\\fldlock".getBytes();
        FIELD_EDIT = "\\fldedit".getBytes();
        FIELD_ALT = "\\fldalt".getBytes();
        FIELD_INSTRUCTIONS = "\\*\\fldinst".getBytes();
        FIELD_RESULT = "\\fldrslt".getBytes();
    }

    protected RtfField(RtfDocument doc, Font font) {
        super("", font);
        this.document = doc;
        this.font = new RtfFont(this.document, font);
    }

    protected RtfField(RtfDocument doc) {
        this(doc, new Font());
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isFieldAlt() {
        return this.fieldAlt;
    }

    public boolean isFieldDirty() {
        return this.fieldDirty;
    }

    public boolean isFieldEdit() {
        return this.fieldEdit;
    }

    public boolean isFieldLocked() {
        return this.fieldLocked;
    }

    public boolean isFieldPrivate() {
        return this.fieldPrivate;
    }

    public void setFieldAlt(boolean fieldAlt) {
        this.fieldAlt = fieldAlt;
    }

    public void setFieldDirty(boolean fieldDirty) {
        this.fieldDirty = fieldDirty;
    }

    public void setFieldEdit(boolean fieldEdit) {
        this.fieldEdit = fieldEdit;
    }

    public void setFieldLocked(boolean fieldLocked) {
        this.fieldLocked = fieldLocked;
    }

    public void setFieldPrivate(boolean fieldPrivate) {
        this.fieldPrivate = fieldPrivate;
    }

    public void setInHeader(boolean inHeader) {
        this.inHeader = inHeader;
    }

    public void setInTable(boolean inTable) {
        this.inTable = inTable;
    }

    public void setRtfDocument(RtfDocument doc) {
        this.document = doc;
        this.font.setRtfDocument(this.document);
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(this.font.writeBegin());
            result.write(this.writeFieldBegin());
            result.write(this.writeFieldInstBegin());
            result.write(this.writeFieldInstContent());
            result.write(this.writeFieldInstEnd());
            result.write(this.writeFieldResultBegin());
            result.write(this.writeFieldResultContent());
            result.write(this.writeFieldResultEnd());
            result.write(this.writeFieldEnd());
            result.write(this.font.writeEnd());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    private byte[] writeFieldBegin() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.write(RtfBasicElement.OPEN_GROUP);
        result.write(FIELD);
        if (this.fieldDirty) {
            result.write(FIELD_DIRTY);
        }
        if (this.fieldEdit) {
            result.write(FIELD_EDIT);
        }
        if (this.fieldLocked) {
            result.write(FIELD_LOCKED);
        }
        if (this.fieldPrivate) {
            result.write(FIELD_PRIVATE);
        }
        return result.toByteArray();
    }

    private byte[] writeFieldEnd() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.write(RtfBasicElement.CLOSE_GROUP);
        return result.toByteArray();
    }

    private byte[] writeFieldInstBegin() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.write(RtfBasicElement.OPEN_GROUP);
        result.write(FIELD_INSTRUCTIONS);
        result.write(RtfBasicElement.DELIMITER);
        return result.toByteArray();
    }

    protected abstract byte[] writeFieldInstContent() throws IOException;

    private byte[] writeFieldInstEnd() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        if (this.fieldAlt) {
            result.write(RtfBasicElement.DELIMITER);
            result.write(FIELD_ALT);
        }
        result.write(RtfBasicElement.CLOSE_GROUP);
        return result.toByteArray();
    }

    private byte[] writeFieldResultBegin() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.write(RtfBasicElement.OPEN_GROUP);
        result.write(FIELD_RESULT);
        result.write(RtfBasicElement.DELIMITER);
        return result.toByteArray();
    }

    protected abstract byte[] writeFieldResultContent() throws IOException;

    private byte[] writeFieldResultEnd() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.write(RtfBasicElement.DELIMITER);
        result.write(RtfBasicElement.CLOSE_GROUP);
        return result.toByteArray();
    }
}

